/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.environment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.EnvironmentObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.message.delete.DeleteEntityResultMessage;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.report.ReportLinkCollector;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironment;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironmentItem;
import org.qubership.automation.itf.ui.messages.objects.transport.UIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.UITriggerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EnvironmentController
extends AbstractController<UIEnvironment, Environment> {
    private ReportLinkCollector reportLinkCollector;

    @Autowired
    public EnvironmentController(ReportLinkCollector reportLinkCollector) {
        this.reportLinkCollector = reportLinkCollector;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/environment/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Environments for project {{#projectId}}/{{#projectUuid}}")
    public List<? extends UIObject> getAll(@RequestParam UUID projectUuid, @RequestParam BigInteger projectId) {
        return this.asListUIObject(((EnvironmentObjectManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentObjectManager.class)).getByProjectId(projectId), false, true, new String[0]);
    }

    @Override
    @Transactional(readOnly=true)
    @RequestMapping(value={"/environment/allbyparent"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Environments by parent id {{#parentId}}")
    public List<? extends UIObject> getAll(@RequestParam(value="parentId", defaultValue="0") String parentId) {
        return super.getAll(parentId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/environment"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Environment by id {{#id}} in the project {{#projectUuid}}")
    public UIEnvironment getById(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UIEnvironment)super.getById(id);
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/environment/{id}"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Environment by id {{#id}} via feign")
    public UIEnvironment feignGetById(@PathVariable(value="id") String id) {
        return (UIEnvironment)super.getById(id);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"CREATE\")")
    @RequestMapping(value={"/environment"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Environment under parent id {{#parentId}} in the project {{#projectId}}/{{#projectUuid}}")
    public UIEnvironment create(@RequestParam(value="parentId", defaultValue="0") String parentId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UIEnvironment)super.create(parentId, projectId);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/environment"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Environment by id {{#uiEnvironment.id}} in the project {{#projectUuid}}")
    public UIEnvironment update(@RequestBody UIEnvironment uiEnvironment, @RequestParam(value="projectUuid") UUID projectUuid) {
        return super.update(uiEnvironment);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"DELETE\")")
    @RequestMapping(value={"/environment"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Environments from project {{#projectUuid}}")
    public DeleteEntityResultMessage<String, UITriggerConfiguration> deleteEnv(@RequestBody Collection<UIEnvironment> objectsToDelete, @RequestParam(value="projectUuid") UUID projectUuid) {
        HashMap envsWithActiveTriggers = new HashMap();
        HashMap<String, String> usingEnvs = new HashMap<String, String>();
        for (UIObject uIObject : objectsToDelete) {
            ArrayList<UITriggerConfiguration> activeTriggers = new ArrayList<UITriggerConfiguration>();
            Environment envToDelete = (Environment)ControllerHelper.getManager(Environment.class).getById((Object)uIObject.getId());
            Collection serversUnderEnv = envToDelete.getInbound().values();
            for (Server server : serversUnderEnv) {
                if (server == null || !server.findUsages().stream().filter(usageInfo -> usageInfo.getProperty().equals("inbound")).allMatch(usageInfo -> usageInfo.getReferer().getID().equals(envToDelete.getID()))) continue;
                for (InboundTransportConfiguration inboundTransportConfiguration : server.getInbounds()) {
                    for (TriggerConfiguration triggerConfiguration : inboundTransportConfiguration.getTriggerConfigurations()) {
                        if (!triggerConfiguration.getState().isOn()) continue;
                        activeTriggers.add(new UITriggerConfiguration((Configuration)triggerConfiguration));
                    }
                }
            }
            if (activeTriggers.size() > 0) {
                envsWithActiveTriggers.put(envToDelete.getID().toString(), activeTriggers);
                continue;
            }
            Collection usageInfo2 = envToDelete.remove();
            if (usageInfo2 == null) continue;
            usingEnvs.put(envToDelete.getID().toString(), this.usageInfoListAsString(usageInfo2));
        }
        return new DeleteEntityResultMessage(envsWithActiveTriggers, usingEnvs);
    }

    @Transactional
    @RequestMapping(value={"/environment/bulk"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Bulk Update Servers in the Environment")
    public UIResult bulkServerUpdate(@RequestBody String[] serverData) {
        serverData[0] = serverData[0].trim();
        serverData[1] = serverData[1].trim();
        for (int i = 2; i < serverData.length; ++i) {
            Environment environment = (Environment)ControllerHelper.getManager(Environment.class).getById((Object)serverData[i]);
            this.updateServerConfigurations(serverData[0], serverData[1], environment.getInbound(), true);
            this.updateServerConfigurations(serverData[0], serverData[1], environment.getOutbound(), false);
        }
        return new UIResult(true, "success");
    }

    private void updateServerConfigurations(String oldServerIp, String newServerIp, Map<System, Server> configurations, boolean isInbound) {
        for (Map.Entry<System, Server> entry : configurations.entrySet()) {
            String oldValue;
            System system = entry.getKey();
            Server server = entry.getValue();
            if (isInbound) {
                for (InboundTransportConfiguration inbound : server.getInbounds(system)) {
                    for (String key : inbound.keySet()) {
                        oldValue = inbound.get((Object)key);
                        if (!oldValue.contains(oldServerIp)) continue;
                        inbound.put(key, this.performReplace(oldValue, oldServerIp, newServerIp));
                    }
                }
            } else {
                for (OutboundTransportConfiguration outbound : server.getOutbounds(system)) {
                    for (String key : outbound.keySet()) {
                        oldValue = outbound.get((Object)key);
                        if (!oldValue.contains(oldServerIp)) continue;
                        outbound.put(key, this.performReplace(oldValue, oldServerIp, newServerIp));
                    }
                }
            }
            if (!server.getUrl().equals(oldServerIp)) continue;
            server.setUrl(newServerIp);
        }
    }

    private String performReplace(String oldValue, String oldServerIp, String newServerIp) {
        int indexPosition = oldValue.indexOf(oldServerIp);
        String firstPartSubString = oldValue.substring(0, indexPosition);
        String secondPartSubString = oldValue.substring(indexPosition + oldServerIp.length());
        return firstPartSubString + newServerIp + secondPartSubString;
    }

    @Override
    protected Environment _beforeUpdate(UIEnvironment uiEnvironment, Environment environment) {
        this.updateEnvironment(uiEnvironment.getInbound(), environment.getInbound());
        this.updateEnvironment(uiEnvironment.getOutbound(), environment.getOutbound());
        if (uiEnvironment.getReportLinkCollectors() != null) {
            for (LinkCollectorConfiguration configuration : environment.getReportCollectors()) {
                CoreObjectManager.getInstance().getManager(TransportConfiguration.class).remove((Storable)configuration, true);
            }
            environment.getReportCollectors().clear();
            for (UIConfiguration uiConfiguration : uiEnvironment.getReportLinkCollectors()) {
                LinkCollectorConfiguration configuration = new LinkCollectorConfiguration();
                configuration.setParent(environment);
                configuration.setName(uiConfiguration.getName());
                configuration.setTypeName(uiConfiguration.getType());
                this.reportLinkCollector.registerCollectors(Collections.singletonList(uiConfiguration.getType()));
                Collection properties = this.reportLinkCollector.getProperties(uiConfiguration.getType());
                for (UIProperty uiProperty : uiConfiguration.getProperties()) {
                    for (PropertyDescriptor descriptor : properties) {
                        if (!descriptor.getShortName().equals(uiProperty.getName())) continue;
                        try {
                            Class<?> aClass = Class.forName(descriptor.getTypeName());
                            if (Storable.class.isAssignableFrom(aClass)) {
                                String id = uiProperty.getReferenceValue() != null ? uiProperty.getReferenceValue().getId() : "";
                                configuration.put(descriptor.getShortName(), id);
                                continue;
                            }
                            configuration.put(descriptor.getShortName(), uiProperty.getValue());
                        }
                        catch (ClassNotFoundException e) {
                            configuration.put(descriptor.getShortName(), uiProperty.getValue());
                        }
                    }
                }
                environment.getReportCollectors().add(configuration);
            }
        }
        return super._beforeUpdate(uiEnvironment, environment);
    }

    @Override
    protected Class<Environment> _getGenericUClass() {
        return Environment.class;
    }

    @Override
    protected UIEnvironment _newInstanceTClass(Environment object) {
        if (object.getEnvironmentState() == null) {
            object.setEnvironmentState(TriggerState.EMPTY);
        }
        UIEnvironment uiEnvironment = new UIEnvironment(object);
        ArrayList configurations = Lists.newArrayList();
        for (LinkCollectorConfiguration configuration : object.getReportCollectors()) {
            try {
                UIConfiguration uiConfiguration = this.createLinkCollectorConfiguration(configuration);
                configurations.add(uiConfiguration);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Error creating collector view", (Throwable)e);
            }
        }
        uiEnvironment.setReportLinkCollectors(configurations);
        return uiEnvironment;
    }

    @Override
    protected Storable _getParent(String parentId) {
        return ControllerHelper.getManager(Folder.class).getById((Object)parentId);
    }

    private void updateEnvironment(ImmutableList<UIEnvironmentItem> environmentItems, Map<System, Server> systemServerMap) {
        if (environmentItems != null) {
            systemServerMap.clear();
            for (UIEnvironmentItem entry : environmentItems) {
                System system = (System)ControllerHelper.getManager(System.class).getById((Object)entry.getSystem().getId());
                Server server = (Server)ControllerHelper.getManager(Server.class).getById((Object)entry.getServer().getId());
                if (system == null || server == null) continue;
                systemServerMap.put(system, server);
            }
        }
    }

    private UIConfiguration createLinkCollectorConfiguration(LinkCollectorConfiguration configuration) throws ClassNotFoundException {
        UIConfiguration uiConfiguration = new UIConfiguration((Configuration)configuration);
        uiConfiguration.setClassName(LinkCollectorConfiguration.class.getName());
        uiConfiguration.setType(configuration.getTypeName());
        try {
            UserName annotation = Class.forName(configuration.getTypeName()).getAnnotation(UserName.class);
            uiConfiguration.setUserTypeName(annotation == null ? configuration.getTypeName() : annotation.value());
        }
        catch (Exception e) {
            uiConfiguration.setUserTypeName(configuration.getTypeName());
        }
        Collection properties = this.reportLinkCollector.getProperties(configuration.getTypeName());
        ArrayList uiProperties = Lists.newArrayListWithExpectedSize((int)properties.size());
        for (PropertyDescriptor descriptor : properties) {
            UIProperty uiProperty;
            String o = configuration.get((Object)descriptor.getShortName());
            Class<?> propertyType = Class.forName(descriptor.getTypeName());
            if (StringUtils.isBlank((CharSequence)o)) {
                uiProperty = new UIProperty(descriptor);
            } else if (Storable.class.isAssignableFrom(propertyType)) {
                Storable storable = CoreObjectManager.getInstance().getManager(propertyType.asSubclass(Storable.class)).getById((Object)o);
                uiProperty = new UIProperty(descriptor, new UIObject(storable));
            } else {
                uiProperty = new UIProperty(descriptor, o);
            }
            uiProperties.add(uiProperty);
        }
        uiConfiguration.setProperties(uiProperties);
        return uiConfiguration;
    }
}

