/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.operation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSyncActivationRequest;
import org.qubership.automation.itf.core.model.communication.message.delete.DeleteEntityResultMessage;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.Pair;
import org.qubership.automation.itf.core.util.provider.KeyDefinitionProvider;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.entities.util.KeyDefinitionControllerHelper;
import org.qubership.automation.itf.ui.controls.entities.util.SituationControllerHelper;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIOperation;
import org.qubership.automation.itf.ui.messages.objects.eventtrigger.UIEventTriggerSyncActivationRequest;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OperationController
extends AbstractController<UIOperation, Operation> {
    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).OPERATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/operation/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get {{#direction}} Operations under System id {{#id}} in the project {{#projectUuid}}")
    public List<? extends UIObject> getAll(@RequestParam(value="system", required=false) String id, @RequestParam(value="displayType", defaultValue="selectList") String displayType, @RequestParam(value="direction", defaultValue="all") String direction, @RequestParam(value="projectUuid") UUID projectUuid) {
        if ("selectList".equals(displayType)) {
            super.setSimple(true);
            List<UIObject> list = StringUtils.isNotBlank((CharSequence)direction) && !direction.equals("all") ? super.getAllSuitable(id, direction) : super.getAll(id);
            super.setSimple(false);
            return list;
        }
        ArrayList<UIOperation> list = new ArrayList<UIOperation>();
        boolean onlyInbound = StringUtils.isNotBlank((CharSequence)direction) && "inbound".equals(direction);
        boolean onlyOutbound = StringUtils.isNotBlank((CharSequence)direction) && "outbound".equals(direction);
        Collection operations = ControllerHelper.getManager(Operation.class).getAllByParentId((Object)id);
        for (Operation operation : operations) {
            if (onlyInbound && !operation.getMep().isInboundRequest() || onlyOutbound && !operation.getMep().isOutboundRequest()) continue;
            UIOperation uiOperation = new UIOperation();
            uiOperation.fillForQuickDisplay(operation);
            list.add(uiOperation);
        }
        return list;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).OPERATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/operation"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Operation by id {{#id}} in the project {{#projectUuid}}")
    public UIOperation getById(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UIOperation)super.getById(id);
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/operation/{id}"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Operation by id {{#id}} via feign")
    public UIOperation feignGetById(@PathVariable(value="id") String id) {
        return (UIOperation)super.getById(id);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).OPERATION.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/operation"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Operation under System id {{#id}} in the project {{#projectUuid}}")
    public UIOperation create(@RequestParam(value="system", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UIOperation)super.create(id);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).OPERATION.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/operation"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Operation in the project {{#projectUuid}}")
    public Pair<UIOperation, UIEventTriggerSyncActivationRequest> update(@RequestBody UIOperation uiOperation, @RequestParam(value="projectUuid") UUID projectUuid) {
        Operation object = (Operation)this.manager().getById((Object)uiOperation.getId());
        this.beforeStoreUpdated(object, uiOperation);
        EventTriggerSyncActivationRequest request = this.beforeUpdate(uiOperation, object);
        UIOperation updatedUiOperation = this.storeUpdated(object, uiOperation);
        return new Pair((Object)updatedUiOperation, (Object)new UIEventTriggerSyncActivationRequest(request));
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).OPERATION.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/operation"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Operations from system id {{#id}} in the project {{#projectUuid}}")
    public Map<String, Object> delete(@RequestParam(value="ignoreUsages", defaultValue="false") Boolean ignoreUsages, @RequestParam(value="system", defaultValue="0") String id, @RequestBody UIIds deleteRequest, @RequestParam(value="projectUuid") UUID projectUuid) {
        System system = (System)ControllerHelper.getManager(System.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)system, "", id, System.class, "delete operation");
        List filteredOperations = system.getOperations().stream().filter(operation -> Arrays.asList(deleteRequest.getIds()).contains(operation.getID().toString())).collect(Collectors.toList());
        HashMap operationsWithTriggers = new HashMap();
        HashMap<String, String> usingOperations = new HashMap<String, String>();
        ArrayList<Operation> operationsWithoutTriggers = new ArrayList<Operation>();
        for (Operation operation2 : filteredOperations) {
            ArrayList<UIObject> eventTriggers = new ArrayList<UIObject>();
            Map blockingTriggers = ControllerHelper.getManager(Operation.class).findImportantChildren((Storable)operation2);
            if (blockingTriggers != null && !blockingTriggers.isEmpty() && blockingTriggers.containsKey("SituationEventTriggers")) {
                for (BigInteger triggerId : (List)blockingTriggers.get("SituationEventTriggers")) {
                    UIObject uiObject = new UIObject();
                    uiObject.setId(triggerId.toString());
                    uiObject.setClassName("SituationEventTrigger");
                    eventTriggers.add(uiObject);
                }
            }
            if (!eventTriggers.isEmpty()) {
                operationsWithTriggers.put(operation2.getID().toString(), eventTriggers);
                continue;
            }
            operationsWithoutTriggers.add(operation2);
        }
        Iterator iter = operationsWithoutTriggers.iterator();
        while (iter.hasNext()) {
            Operation operation2;
            operation2 = (Operation)iter.next();
            Collection usageInfo = ControllerHelper.getManager(Operation.class).remove((Storable)operation2, ignoreUsages.booleanValue());
            if (usageInfo != null) {
                usingOperations.put(operation2.getID().toString(), this.usageInfoListAsString(usageInfo));
            }
            iter.remove();
        }
        system.store();
        system.flush();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("parentVersion", system.getVersion());
        result.put("result", new DeleteEntityResultMessage(operationsWithTriggers, usingOperations));
        return result;
    }

    protected EventTriggerSyncActivationRequest beforeUpdate(UIOperation uiOperation, Operation operation) {
        this.updateTransport(uiOperation, operation);
        this.updateDefinitionKey(uiOperation, operation);
        KeyDefinitionControllerHelper.editContextKeyDefinition((KeyDefinitionProvider)operation, uiOperation.getIncoming(), uiOperation.getOutgoing());
        return SituationControllerHelper.synchronizeSituations(uiOperation, operation);
    }

    @Override
    protected boolean _isObjectSuitable(Operation object, String ... param) {
        if (Objects.nonNull(param[0])) {
            return "outbound".equals(param[0]) && object.getMep().isOutboundRequest() || "inbound".equals(param[0]) && object.getMep().isInboundRequest() || "all".equals(param[0]);
        }
        throw new RuntimeException("Param [0] for Suitable can't be null");
    }

    @Override
    protected Class<Operation> _getGenericUClass() {
        return Operation.class;
    }

    @Override
    protected UIOperation _newInstanceTClass(Operation object) {
        return new UIOperation(object);
    }

    @Override
    protected Storable _getParent(String parentId) {
        System system = (System)ControllerHelper.getManager(System.class).getById((Object)parentId);
        ControllerHelper.throwExceptionIfNull((Storable)system, "", parentId, System.class, "get System by id");
        return system;
    }

    private void updateTransport(UIOperation uiOperation, Operation operation) {
        TransportConfiguration transport;
        UITransport uiTransport;
        if (uiOperation.getTransport() != null && (uiTransport = uiOperation.getTransport().getData()) != null && (transport = (TransportConfiguration)ControllerHelper.getManager(TransportConfiguration.class).getById((Object)uiTransport.getId())) != null) {
            operation.setTransport(transport);
        }
    }

    private void updateDefinitionKey(UIOperation uiOperation, Operation operation) {
        if (uiOperation.getDefinitionKey() == null) {
            operation.setOperationDefinitionKey(null);
        } else {
            operation.setOperationDefinitionKey(uiOperation.getDefinitionKey().getData().getKey());
        }
    }

    @Override
    protected void checkVersion(Operation object, UIOperation uiObject) {
    }
}

