/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.template;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.OperationTemplateObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SystemTemplateObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.TransportConfigurationObjectManager;
import org.qubership.automation.itf.core.model.IdNamePair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironment;
import org.qubership.automation.itf.ui.messages.objects.environment.UIEnvironmentItem;
import org.qubership.automation.itf.ui.messages.objects.template.UITemplate;
import org.qubership.automation.itf.ui.messages.objects.template.UITransportPropsForTemplate;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional(readOnly=true)
public class TemplateController
extends AbstractController<UITemplate, Template> {
    private static final Logger log = LoggerFactory.getLogger(TemplateController.class);

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Templates in the project {{#projectId}}/{{#projectUuid}}")
    public List<? extends UIObject> getAll(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="projectId") BigInteger projectId) {
        return TemplateHelper.getByProjectId((BigInteger)projectId).stream().map(UIObject::new).collect(Collectors.toList());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/allIdAndName"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Templates (briefly) in the project {{#projectId}}/{{#projectUuid}}")
    public List<SystemTemplate> getIdAndName(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="systemId", required=false) BigInteger systemId, @RequestParam(value="transportId", required=false) BigInteger transportId) {
        if (Objects.nonNull(transportId) && Objects.isNull(systemId)) {
            OutboundTransportConfiguration outboundTransportConfiguration = (OutboundTransportConfiguration)CoreObjectManager.getInstance().getManager(OutboundTransportConfiguration.class).getById((Object)transportId);
            systemId = (BigInteger)outboundTransportConfiguration.getSystem().getID();
        }
        return ((SystemTemplateObjectManager)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, SystemTemplateObjectManager.class)).getSimpleSystemTemplatesByParentId(systemId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/onOperationAndSystem"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Templates under Operation by id {{#id}} and parent System in the project {{#projectUuid}}")
    public List<? extends UIObject> getTemplateOnOperationAndSystem(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        super.setSimple(true);
        Operation operation = (Operation)CoreObjectManager.getInstance().getManager(Operation.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)operation, "", id, Operation.class, "get Templates under Operation");
        List<UIObject> uiObjects = this.asListUIObject(operation.returnTemplates(), true, true, new String[0]);
        uiObjects.addAll(this.asListUIObject(operation.getParent().returnTemplates(), true, true, new String[0]));
        super.setSimple(false);
        return uiObjects;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/onOperationAndSystemFiltered"}, method={RequestMethod.GET})
    public List<IdNamePair> getTemplateOnOperationAndSystemFiltered(@RequestParam(value="id") String id, @RequestParam(value="name") String name, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Situation situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)situation, "", id, Situation.class, "get Situation by id");
        Operation operation = situation.getParent();
        CoreObjectManagerService objectManagerService = CoreObjectManager.getInstance();
        List uiObjects = ((SystemTemplateObjectManager)objectManagerService.getSpecialManager(SystemTemplate.class, SystemTemplateObjectManager.class)).getByPieceOfNameAndParentId(name, (BigInteger)operation.getParent().getID());
        uiObjects.addAll(((OperationTemplateObjectManager)objectManagerService.getSpecialManager(OperationTemplate.class, OperationTemplateObjectManager.class)).getByPieceOfNameAndParentId(name, (BigInteger)operation.getID()));
        return uiObjects;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Template by id {{#id}} in the project {{#projectUuid}}")
    public UITemplate getById(@RequestParam(value="id", defaultValue="0") BigInteger id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return new UITemplate(TemplateHelper.getById((Object)id));
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/template"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Template under {{#type}} with id {{#parentId}} in the project {{#projectUuid}}")
    public UITemplate create(@RequestParam(value="selectedId") String parentId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="type") Class<? extends TemplateProvider> type) {
        TemplateProvider parent = Template.class.isAssignableFrom(type) ? this._getParent(parentId) : (TemplateProvider)CoreObjectManager.getInstance().getManager(type).getById((Object)parentId);
        return new UITemplate((Template)TemplateHelper.getManagerByParent((TemplateProvider)parent).create((Storable)parent));
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/template"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Template with id {{#uiTemplate.id}} in the project {{#projectUuid}}")
    public UITemplate update(@RequestBody UITemplate uiTemplate, @RequestParam(value="projectUuid") UUID projectUuid) {
        ObjectManager<SystemTemplate> objectManager = SystemTemplate.class.getName().equals(uiTemplate.getClassName()) ? ControllerHelper.getManager(SystemTemplate.class) : ControllerHelper.getManager(OperationTemplate.class);
        return this.updateUIObject(objectManager.getById((Object)uiTemplate.getId()), uiTemplate);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/template"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @AuditAction(auditAction="Delete Templates from project {{#projectUuid}}")
    public List<List<UIObject>> delete(@RequestParam(value="ignoreUsages", defaultValue="false") Boolean ignoreUsages, @RequestBody UIIds uiDeleteObjectReq, @RequestParam(value="projectUuid") UUID projectUuid) {
        ArrayList<UIObject> deletedUiObjects = new ArrayList<UIObject>();
        ArrayList<UIObject> usedUiObjects = new ArrayList<UIObject>();
        HashMap result = Maps.newHashMap();
        for (String id : uiDeleteObjectReq.getIds()) {
            Template template = TemplateHelper.getById((Object)id);
            if (this.haveUsages(template, result, ignoreUsages)) {
                usedUiObjects.add(new UIObject((Storable)template));
                continue;
            }
            deletedUiObjects.add(new UIObject((Storable)template));
            this.delete(template);
            LOGGER.info("Storable {} is deleted", (Object)template);
        }
        ArrayList<List<UIObject>> allObjects = new ArrayList<List<UIObject>>();
        allObjects.add(deletedUiObjects);
        allObjects.add(usedUiObjects);
        return allObjects;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/templateByName"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Templates by name {{#name}} in the project {{#projectUuid}}")
    public UITemplate getByName(@RequestParam(value="name") String name, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Collection templates = TemplateHelper.getByNameAndProjectId((String)name, (BigInteger)projectId);
        if (templates.isEmpty()) {
            throw new ObjectNotFoundException(Template.class.getSimpleName(), null, name, "get Templates by name");
        }
        return new UITemplate((Template)templates.iterator().next());
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/usages"}, method={RequestMethod.GET}, produces={"application/json"})
    @AuditAction(auditAction="Get usages of Template with id {{#id}} in the project {{#projectUuid}}")
    public Map<String, Object> getUsages(@RequestParam(value="id") BigInteger id, @RequestParam(value="projectUuid") UUID projectUuid) {
        Template template = TemplateHelper.getById((Object)id);
        HashMap<String, Object> usages = new HashMap<String, Object>();
        usages.put("situations", this.findTemplateUsagesOnSituations((Template<? extends TemplateProvider>)template));
        usages.put("transports", this.findTemplateUsagesOnTransportConfigurations((Template<? extends TemplateProvider>)template));
        usages.put("environments", this.findTemplateUsagesOnOutboundConfigurations((Template<? extends TemplateProvider>)template));
        return usages;
    }

    private List findTemplateUsagesOnSituations(Template<? extends TemplateProvider> template) {
        Collection usageInfo = TemplateHelper.getManagerByParent((TemplateProvider)template.getParent()).findUsages(template);
        ArrayList<UISituation> situations = new ArrayList<UISituation>();
        if (usageInfo != null) {
            for (UsageInfo item : usageInfo) {
                UISituation uiSituation = null;
                if (item.getReferer().getParent() instanceof Situation) {
                    Situation situation = (Situation)item.getReferer().getParent();
                    uiSituation = new UISituation(situation);
                }
                situations.add(uiSituation);
            }
        }
        return situations;
    }

    private List findTemplateUsagesOnTransportConfigurations(Template<? extends TemplateProvider> template) {
        ArrayList transports = new ArrayList();
        if (template instanceof SystemTemplate) {
            Collection transportConfigurations = ((TransportConfigurationObjectManager)CoreObjectManager.getInstance().getSpecialManager(TransportConfiguration.class, TransportConfigurationObjectManager.class)).findUsagesTemplateOnTransport((BigInteger)template.getID());
            transportConfigurations.forEach(transportConfiguration -> {
                UITransport uiTransport = new UITransport((TransportConfiguration)transportConfiguration);
                transports.add(uiTransport);
            });
        }
        return transports;
    }

    private List findTemplateUsagesOnOutboundConfigurations(Template<? extends TemplateProvider> template) {
        ArrayList environments = new ArrayList();
        if (template instanceof SystemTemplate) {
            List findUsagesOnConfigurationDiameterOutbound = ((SystemTemplateObjectManager)CoreObjectManager.getInstance().getSpecialManager(SystemTemplate.class, SystemTemplateObjectManager.class)).findUsagesOnOutboundDiameterConfiguration(template);
            findUsagesOnConfigurationDiameterOutbound.forEach(stringObjectMap -> {
                UIEnvironment uiEnvironment = new UIEnvironment();
                uiEnvironment.setId(stringObjectMap.get("env_id").toString());
                uiEnvironment.setName(stringObjectMap.get("env_name").toString());
                final UIEnvironmentItem uiEnvironmentItem = new UIEnvironmentItem();
                UIObject system = new UIObject();
                system.setName(stringObjectMap.get("system_name").toString());
                UIObject server = new UIObject();
                server.setName(stringObjectMap.get("server_name").toString());
                uiEnvironmentItem.setSystem(system);
                uiEnvironmentItem.setServer(server);
                uiEnvironment.setOutbound((List<UIEnvironmentItem>)new ArrayList<UIEnvironmentItem>(){
                    {
                        this.add(uiEnvironmentItem);
                    }
                });
                environments.add(uiEnvironment);
            });
        }
        return environments;
    }

    @Override
    protected Template _beforeUpdate(UITemplate editRequest, Template template) {
        ImmutableList<UITransportPropsForTemplate> uiProperties;
        template.setText(editRequest.getContent());
        ImmutableList<UIProperty> uiHeaders = editRequest.getHeaders();
        if (uiHeaders != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            for (UIProperty uiHeader : uiHeaders) {
                headers.put(uiHeader.getName(), uiHeader.getValue());
            }
            template.fillHeaders(headers);
        }
        if ((uiProperties = editRequest.getTransportProperties()) != null) {
            ArrayList templateProperties = Lists.newArrayList();
            for (UITransportPropsForTemplate uiProperty : uiProperties) {
                if (uiProperty.getTransportProperties().isEmpty()) continue;
                OutboundTemplateTransportConfiguration properties = new OutboundTemplateTransportConfiguration(uiProperty.getClassName(), template);
                for (UIProperty property : uiProperty.getTransportProperties()) {
                    if (!StringUtils.isNotEmpty((CharSequence)property.getValue())) continue;
                    properties.put(property.getName(), property.getValue());
                }
                if (properties.isEmpty()) continue;
                templateProperties.add(properties);
            }
            template.fillTransportProperties((Collection)templateProperties);
        }
        return super._beforeUpdate(editRequest, template);
    }

    @Override
    protected Class<Template> _getGenericUClass() {
        return Template.class;
    }

    @Override
    protected UITemplate _newInstanceTClass(Template object) {
        return new UITemplate(object);
    }

    protected TemplateProvider _getParent(String templateId) {
        Template template = TemplateHelper.getById((Object)templateId);
        if (Objects.nonNull(template)) {
            return template.getParent();
        }
        throw new ObjectNotFoundException(Template.class.getSimpleName(), templateId, null, null);
    }

    private TemplateProvider getParentInTransaction(String parentId, Class<? extends TemplateProvider> parentClass) throws Exception {
        return (TemplateProvider)TxExecutor.execute(() -> (TemplateProvider)ControllerHelper.getManager(parentClass).getById((Object)parentId), (TransactionDefinition)TxExecutor.defaultWritableTransaction());
    }
}

