/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.transport;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.NotValidValueException;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.InboundTransportConfigurationObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.message.delete.DeleteEntityResultMessage;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.helper.Comparators;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.base.AbstractTransportImpl;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.entities.util.ConfigurationControllerHelper;
import org.qubership.automation.itf.ui.controls.entities.util.ResponseCacheHelper;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UITypedObject;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TransportController
extends AbstractController<UITransport, TransportConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportController.class);
    @Autowired
    private ConfigurationControllerHelper configurationControllerHelper;

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/transport/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Transports by parent id {{#parentId}} in the project {{#projectUuid}}")
    public List<? extends UIObject> getAll(@RequestParam(value="parent", defaultValue="0") String parentId, @RequestParam(value="isFull", defaultValue="true") boolean isFull, @RequestParam(value="displayType", defaultValue="selectList") String displayType, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isEmpty((CharSequence)parentId) || "0".equals(parentId)) {
            throw new NotValidValueException("Get All Transports: operation can be performed only for parent System; parent id can't be empty");
        }
        if (isFull) {
            return super.getAll(parentId);
        }
        ArrayList<UITransport> uiTransports = new ArrayList<UITransport>();
        boolean toTableDisplay = "table".equals(displayType);
        Collection configurations = ControllerHelper.getManager(TransportConfiguration.class).getAllByParentId((Object)parentId);
        for (TransportConfiguration transport : configurations) {
            if (transport == null) continue;
            UITransport uiTransport = new UITransport();
            uiTransport.fillForQuickDisplay(transport, toTableDisplay);
            uiTransports.add(uiTransport);
        }
        return uiTransports;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/transport"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Transport Configuration by id {{#id}} in the project {{#projectUuid}}")
    public UITransport get(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        TransportConfiguration transport = (TransportConfiguration)ControllerHelper.getManager(TransportConfiguration.class).getById((Object)id);
        ControllerHelper.throwExceptionIfNull((Storable)transport, "", id, TransportConfiguration.class, "get Transport by id");
        UITransport uiTransport = new UITransport(transport);
        if (!uiTransport.defineProperties(transport)) {
            uiTransport.setName(uiTransport.getName() + " [Implementation not deployed]");
        }
        uiTransport.setTransportInterceptors(this.getUIInterceptors(transport));
        return uiTransport;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'CREATE')")
    @RequestMapping(value={"/transport"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Transport under System with id {{#parentId}} in the project {{#projectUuid}}")
    public UIObject create(@RequestParam(value="system", defaultValue="0") String parentId, @RequestBody UITypedObject uiTypedObject, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        return super.create(parentId, uiTypedObject.getName(), uiTypedObject.getType());
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/transport"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Transport from System with id {{#id}} from project {{#projectId}}/{{#projectUuid}}")
    public Map<String, Object> delete(@RequestParam(value="system", defaultValue="0") String id, @RequestParam(value="ignoreUsages", defaultValue="false") Boolean ignoreUsages, @RequestBody UIIds uiDeleteObjectReq, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        System system = (System)ControllerHelper.getManager(System.class).getById((Object)id);
        List filteredTransportConfigurations = system.getTransports().stream().filter(transportConfiguration -> Arrays.asList(uiDeleteObjectReq.getIds()).contains(transportConfiguration.getID().toString())).collect(Collectors.toList());
        HashMap transportsWithTriggers = new HashMap();
        HashMap<String, String> usingTransports = new HashMap<String, String>();
        ArrayList<TransportConfiguration> transportsWithoutTriggers = new ArrayList<TransportConfiguration>();
        for (TransportConfiguration transportConfiguration2 : filteredTransportConfigurations) {
            ArrayList<UIObject> triggers = new ArrayList<UIObject>();
            if (transportConfiguration2.getMep().isInbound()) {
                Map blockingTriggers = ControllerHelper.getManager(TransportConfiguration.class).findImportantChildren((Storable)transportConfiguration2);
                if (blockingTriggers != null && !blockingTriggers.isEmpty() && blockingTriggers.containsKey("TransportTriggers")) {
                    for (BigInteger triggerId : (List)blockingTriggers.get("TransportTriggers")) {
                        UIObject uiObject = new UIObject();
                        uiObject.setId(triggerId.toString());
                        uiObject.setClassName("TransportTrigger");
                        triggers.add(uiObject);
                    }
                }
                if (!triggers.isEmpty()) {
                    transportsWithTriggers.put(transportConfiguration2.getID().toString(), triggers);
                } else {
                    transportsWithoutTriggers.add(transportConfiguration2);
                }
            } else {
                transportsWithoutTriggers.add(transportConfiguration2);
            }
            if (!transportConfiguration2.getMep().isInbound()) continue;
            Collection configurations = ((InboundTransportConfigurationObjectManager)CoreObjectManager.getInstance().getSpecialManager(InboundTransportConfiguration.class, InboundTransportConfigurationObjectManager.class)).getConfigurationsByTransportId((BigInteger)transportConfiguration2.getID());
            for (InboundTransportConfiguration configuration : configurations) {
                Server server = (Server)ControllerHelper.getManager(Server.class).getById(configuration.getParent().getID());
                Collection inboundTransportConfigurations = server.getInbounds();
                inboundTransportConfigurations.remove(configuration);
                server.store();
            }
        }
        Iterator iter = transportsWithoutTriggers.iterator();
        while (iter.hasNext()) {
            TransportConfiguration transportConfiguration2;
            transportConfiguration2 = (TransportConfiguration)iter.next();
            Collection usageInfoList = ControllerHelper.getManager(TransportConfiguration.class).remove((Storable)transportConfiguration2, ignoreUsages.booleanValue());
            if (usageInfoList != null) {
                usingTransports.put(transportConfiguration2.getID().toString(), this.usageInfoListAsString(usageInfoList));
            }
            iter.remove();
        }
        system.store();
        system.flush();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("parentVersion", system.getVersion());
        result.put("result", new DeleteEntityResultMessage(transportsWithTriggers, usingTransports));
        return result;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/transport"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Transport by id {{#id}} in the project {{#projectUuid}}")
    public UITransport update(@RequestParam(value="id", defaultValue="0") String id, @RequestBody UITransport uiTransport, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        TransportConfiguration objectTransport = (TransportConfiguration)ControllerHelper.getManager(TransportConfiguration.class).getById((Object)id);
        this.beforeStoreUpdated(objectTransport, uiTransport);
        ResponseCacheHelper.beforeUpdatedForRestAndSoapTransport((Configuration)objectTransport, uiTransport, projectId);
        if (uiTransport.getProperties() != null) {
            for (UIProperty entryUIProperty : uiTransport.getProperties()) {
                this.configurationControllerHelper.setProperty((Configuration)objectTransport, entryUIProperty, projectUuid);
            }
        }
        if (!uiTransport.defineProperties(objectTransport)) {
            uiTransport.setName(uiTransport.getName() + " [Implementation not deployed]");
        }
        return this.storeUpdated(objectTransport, uiTransport);
    }

    private Collection<UIInterceptor> getUIInterceptors(TransportConfiguration transport) {
        ArrayList<UIInterceptor> result = new ArrayList<UIInterceptor>();
        List interceptors = transport.getInterceptors();
        interceptors.sort(Comparators.INTERCEPTOR_COMPARATOR);
        for (Interceptor interceptor : interceptors) {
            try {
                result.add(new UIInterceptor(interceptor));
            }
            catch (Exception e) {
                LOGGER.error("Cannot instantiate the \"{}\" interceptor. Check that the appropriate interceptor's implementation wad added and interceptor successfully registered.", (Object)interceptor.getName(), (Object)e);
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/transport/getTransportPropertiesByType"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Transport properties by type {{#type}}")
    public List<UIProperty> getTransportPropertiesByType(@RequestParam(value="type") Class<? extends AbstractTransportImpl> type) throws TransportException {
        Map transportParameters = TransportRegistryManager.getInstance().getProperties(type.getName());
        ArrayList uiProperties = Lists.newArrayListWithExpectedSize((int)transportParameters.size());
        for (PropertyDescriptor descriptor : transportParameters.values()) {
            UIProperty uiProperty = new UIProperty(descriptor);
            uiProperties.add(uiProperty);
        }
        return uiProperties;
    }

    @Transactional(readOnly=true)
    @RequestMapping(value={"/transport/getTransportPropertiesForTrigger"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Transport properties by type {{#type}} for trigger")
    public List<UIProperty> getTransportPropertiesForTrigger(@RequestParam(value="type") Class<? extends AbstractTransportImpl> type) throws TransportException {
        Map transportParameters = TransportRegistryManager.getInstance().getProperties(type.getName());
        ArrayList uiProperties = Lists.newArrayListWithExpectedSize((int)transportParameters.size());
        for (PropertyDescriptor propertyDescriptor : transportParameters.values()) {
            if (!propertyDescriptor.isForServer()) continue;
            uiProperties.add(new UIProperty(propertyDescriptor));
        }
        return uiProperties;
    }

    @Override
    protected Class<TransportConfiguration> _getGenericUClass() {
        return TransportConfiguration.class;
    }

    @Override
    protected UITransport _newInstanceTClass(TransportConfiguration object) {
        return new UITransport(object);
    }

    @Override
    protected Storable _getParent(String parentId) {
        return ControllerHelper.getManager(System.class).getById((Object)parentId);
    }
}

