/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.transport;

import java.util.Map;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.UITypeList;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TransportTypeController {
    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TRANSPORT.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/transport/types"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all supported Transport Types")
    public UITypeList getTransportTypes(@RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        Map objectTransportTypes = TransportRegistryManager.getInstance().getTransportTypes();
        return UIHelper.convertMapOfTypeToUITypeList(objectTransportTypes);
    }
}

