/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.execute;

import com.google.common.base.Strings;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.adapter.common.context.AtpCompaund;
import org.qubership.atp.adapter.common.context.TestRunContext;
import org.qubership.atp.adapter.common.context.TestRunContextHolder;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByParameterAndProjectIdManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.extension.Extension;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.testcase.TestCase;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.ExtensionManager;
import org.qubership.automation.itf.execution.data.CallchainExecutionData;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.executor.service.TCContextService;
import org.qubership.automation.itf.integration.bv.utils.BvHelper;
import org.qubership.automation.itf.report.extension.TCContextRamExtension;
import org.qubership.automation.itf.ui.controls.execute.ExecutorControllerHelper;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.ExecutionRequest;
import org.qubership.automation.itf.ui.messages.objects.UIDataSet;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetParameter;
import org.qubership.automation.itf.ui.messages.objects.UIDataSetParametersGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tags(value={@Tag(name="Executor commands API.", description="Executor API to control execution. Called through REST.")})
public class ExecutorController
extends ControllerHelper {
    private static final Logger log = LoggerFactory.getLogger(ExecutorController.class);
    private static final String CALLCHAIN_ID_OR_NAME_MUST_BE_SET = "One (not both) of callchain 'id' or 'name' must be specified";
    private static final String INVALID_RAM_SETTINGS = "'external.app.name' and ('testRunId' or 'ram2TestRunId') work together: you must specify or not specify both of them";
    private static final String PROJECT_UUID_MUST_BE_SET = "'projectId' property must be specified";
    private static final String ENVIRONMENT_NAME_MUST_BE_SET = "'environment' property must be specified";
    private final Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new DatasetContentExclusionStrategy()}).create();
    private final ProjectSettingsService projectSettingsService;

    private static void processValidationError(Errors errors, String errorCategory, String errorMessage) {
        log.error("Invalid request to executor: {}", (Object)errorMessage);
        errors.reject(errorCategory, errorMessage);
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{new Validator(){

            public boolean supports(Class<?> clazz) {
                return ExecutionRequest.class.equals(clazz);
            }

            public void validate(Object target, Errors errors) {
                boolean environmentIsEmpty;
                boolean projectIdIsEmpty;
                boolean testRunIdIsEmpty;
                boolean idIsEmpty;
                ExecutionRequest toValidate = (ExecutionRequest)target;
                boolean nameIsEmpty = Strings.isNullOrEmpty((String)toValidate.getStarterChainName());
                if (nameIsEmpty == (idIsEmpty = Strings.isNullOrEmpty((String)toValidate.getStarterChainId()))) {
                    ExecutorController.processValidationError(errors, "lackOfId", ExecutorController.CALLCHAIN_ID_OR_NAME_MUST_BE_SET);
                }
                boolean exAppNameIsEmpty = Strings.isNullOrEmpty((String)toValidate.getExternalAppName());
                boolean bl = testRunIdIsEmpty = toValidate.getTestRunId() == null && Strings.isNullOrEmpty((String)toValidate.getRam2TestRunId());
                if (exAppNameIsEmpty != testRunIdIsEmpty) {
                    ExecutorController.processValidationError(errors, "unexpectedSettings", ExecutorController.INVALID_RAM_SETTINGS);
                }
                if (projectIdIsEmpty = Strings.isNullOrEmpty((String)toValidate.getProjectId())) {
                    ExecutorController.processValidationError(errors, "unexpectedSettings", ExecutorController.PROJECT_UUID_MUST_BE_SET);
                }
                if (environmentIsEmpty = Strings.isNullOrEmpty((String)toValidate.getEnvironment())) {
                    ExecutorController.processValidationError(errors, "unexpectedSettings", ExecutorController.ENVIRONMENT_NAME_MUST_BE_SET);
                }
                if (errors.hasErrors()) {
                    log.error("Request isn't executed due to above errors, error code 400 'Bad request' is returned instead.\nRequest body: {}", (Object)ExecutorController.this.gson.toJson(target));
                }
            }
        }});
    }

    @Transactional
    @RequestMapping(value={"/executor/execute"}, method={RequestMethod.POST})
    @Operation(summary="Execute", description="Execute callchain", tags={"Executor commands API."})
    @AuditAction(auditAction="Execute CallChain with properties")
    public String execute(@RequestBody @Valid ExecutionRequest properties) throws Exception {
        return ExecutionServices.getCallChainExecutorService().executeInstance(this.doTestCase(properties)).getContext().tc().getID().toString();
    }

    private CallChainInstance doTestCase(ExecutionRequest properties) throws Exception {
        return (CallChainInstance)TxExecutor.execute(() -> {
            List chains;
            UUID projectUuid = UUID.fromString(properties.getProjectId());
            BigInteger projectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
            if (projectId == null) {
                throw new ObjectNotFoundException("Project", properties.getProjectId(), null, "execute Test Case");
            }
            SearchByParameterAndProjectIdManager man = (SearchByParameterAndProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(CallChain.class, SearchByParameterAndProjectIdManager.class);
            String callChainName = properties.getStarterChainName();
            CallChain chain = callChainName != null ? ((chains = man.getByNameAndProjectId(callChainName, projectId)) != null && !chains.isEmpty() ? (CallChain)chains.iterator().next() : null) : (CallChain)man.getById((Object)properties.getStarterChainId());
            ControllerHelper.throwExceptionIfNull((Storable)chain, callChainName, properties.getStarterChainId(), CallChain.class, "get CallChain by id or name");
            CallChainInstance instance = this.createTestCaseInstance(properties.getDataset(), properties.getEnvironment(), chain, properties.getDataSetList(), properties.getDataSetMap(), properties.getMergeDatasetWithContext(), projectId, projectUuid);
            instance.getContext().setProjectUuid(projectUuid);
            TCContextRamExtension extension = new TCContextRamExtension();
            this.configureExtension(projectId, properties, extension);
            TcContext tcContext = instance.getContext().tc();
            tcContext.setStartedFrom(extension.getStartedFrom());
            tcContext.setAndCalculateNeedToReportToItf();
            tcContext.setPartNum(TCContextService.getCurrentPartitionNumberByProject((UUID)tcContext.getProjectUuid()));
            ExtensionManager.getInstance().extend((Object)tcContext, (Extension)extension);
            CallchainExecutionData data = new CallchainExecutionData(chain, properties.getEnvironment(), tcContext.getEnvironmentId().toString(), properties.getDataset());
            data.setProjectUuid(projectUuid);
            data.setNeedToLogInATP(Boolean.TRUE.booleanValue());
            tcContext.put((Object)"DATASET_NAME", (Object)data.getDatasetName());
            if (properties.getValidateAtEnd().booleanValue()) {
                String propValue = this.projectSettingsService.get((Object)projectId, "bv.default.action", "CreateNewTestRun");
                BvHelper.addOnCaseFinishValidation((CallChainInstance)instance, (CallChain)chain, (String)properties.getDataset(), (boolean)true, (String)propValue);
                data.setRunBvCase(properties.getValidateAtEnd().booleanValue());
                data.setBvAction(propValue);
            }
            if (properties.getValidateOnSituation().booleanValue()) {
                BvHelper.addMessageOnStepValidation((CallChainInstance)instance);
                data.setValidateMessageOnStep(properties.getValidateOnSituation().booleanValue());
            }
            instance.setCallchainExecutionData(this.gson.toJson((Object)data));
            return instance;
        });
    }

    private void configureExtension(@Nonnull BigInteger projectId, @Nonnull ExecutionRequest properties, @Nonnull TCContextRamExtension extension) {
        extension.setErName(properties.getRamExecRequestName());
        extension.setSuiteName(properties.getRamSuite());
        extension.setMailList(properties.getRamMailList());
        extension.setProjectName(properties.getRamProject());
        extension.setStartedFrom(StartedFrom.EXECUTOR);
        String ram2TestRunId = properties.getRam2TestRunId();
        log.debug("Configure extension testRunId for RAM2: {}", (Object)ram2TestRunId);
        if (!Strings.isNullOrEmpty((String)ram2TestRunId)) {
            TestRunContext runContext = TestRunContextHolder.getContext((String)properties.getRam2TestRunId());
            String sectionId = properties.getRam2TestRunId();
            runContext.setTestRunId(sectionId);
            LogRecord section = new LogRecord();
            section.setUuid(UUID.fromString(properties.getRam2SectionId() == null ? runContext.getAtpCompaund().getSectionId() : properties.getRam2SectionId()));
            section.setMessage("");
            section.setTestRunId(UUID.fromString(sectionId));
            section.setName(properties.getRam2SectionName());
            section.setTestingStatus(null);
            section.setType(TypeAction.ITF);
            section.setStartDate(new Timestamp(System.currentTimeMillis()));
            runContext.addSection(section);
            AtpCompaund compaund = new AtpCompaund();
            compaund.setSectionName(properties.getRam2SectionName());
            compaund.setSectionId(properties.getRam2SectionId());
            runContext.setAtpCompaund(compaund);
            extension.setRunContext(runContext);
            extension.setExternalRun(Boolean.valueOf(true));
            extension.setStartedFrom(StartedFrom.RAM2);
        }
    }

    private CallChainInstance createTestCaseInstance(@Nullable String datasetName, String environmentName, @Nonnull CallChain callChain, @Nullable Map<String, Map<String, String>> dataSetList, @Nullable Map<String, String> datasetMap, Boolean mergeDatasetWithContext, BigInteger projectId, UUID projectUuid) throws Exception {
        List environments = ((SearchByParameterAndProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, SearchByParameterAndProjectIdManager.class)).getByNameAndProjectId(environmentName, projectId);
        Environment environment = environments != null && !environments.isEmpty() ? (Environment)environments.iterator().next() : null;
        ControllerHelper.throwExceptionIfNull((Storable)environment, StringUtils.isBlank((CharSequence)environmentName) ? "(name is null or empty)" : environmentName, null, Environment.class, "get Environment by name");
        JsonContext variablesJson = null;
        IDataSet dataSet = null;
        boolean contextEmpty = true;
        if (datasetMap != null) {
            variablesJson = new JsonContext();
            variablesJson.putAll(datasetMap);
            contextEmpty = datasetMap.isEmpty();
        }
        if (contextEmpty && dataSetList != null) {
            variablesJson = new JsonContext();
            variablesJson.merge(dataSetList);
            contextEmpty = dataSetList.isEmpty();
        }
        if ((contextEmpty || mergeDatasetWithContext.booleanValue()) && !StringUtils.isBlank((CharSequence)datasetName)) {
            dataSet = ExecutorControllerHelper.findDataSetByName(datasetName, callChain, projectId);
        }
        return ExecutionServices.getCallChainExecutorService().prepare(projectId, projectUuid, (TestCase)callChain, null, environment, dataSet, variablesJson, true);
    }

    @Nonnull
    private UIDataSet toUIDataSet(@Nonnull Map<String, Map<String, String>> dataSetList) {
        UIDataSet dataSet = new UIDataSet();
        dataSet.setDataSetParametersGroup(dataSetList.entrySet().stream().map(new Function<Map.Entry<String, Map<String, String>>, UIDataSetParametersGroup>(){

            @Override
            @Nullable
            public UIDataSetParametersGroup apply(@Nonnull Map.Entry<String, Map<String, String>> input) {
                UIDataSetParametersGroup result = new UIDataSetParametersGroup();
                result.setName(input.getKey());
                result.setDataSetParameter(input.getValue().entrySet().stream().map(new Function<Map.Entry<String, String>, UIDataSetParameter>(){

                    @Override
                    @Nullable
                    public UIDataSetParameter apply(@Nonnull Map.Entry<String, String> input) {
                        return new UIDataSetParameter(input.getKey(), input.getValue());
                    }
                }).collect(Collectors.toSet()));
                return result;
            }
        }).collect(Collectors.toSet()));
        return dataSet;
    }

    @ConstructorProperties(value={"projectSettingsService"})
    public ExecutorController(ProjectSettingsService projectSettingsService) {
        this.projectSettingsService = projectSettingsService;
    }

    public class DatasetContentExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getName().equals("dataSetList");
        }
    }
}

