/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.execute;

import io.swagger.v3.oas.annotations.Operation;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.IllegalClassException;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.integration.IntegrationException;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.BvCaseContainingObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.util.Maps2;
import org.qubership.automation.itf.core.util.constants.ProjectSettingsConstants;
import org.qubership.automation.itf.core.util.engine.EngineControlIntegration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.qubership.automation.itf.core.util.registry.EngineIntegrationRegistry;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.ui.controls.execute.ExecutorControllerHelper;
import org.qubership.automation.itf.ui.controls.util.Collector;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Transactional(readOnly=true)
@RestController
public class IntegrationCallChainController
extends ExecutorControllerHelper {
    private static final Logger log = LoggerFactory.getLogger(IntegrationCallChainController.class);
    private final ProjectSettingsService projectSettingsService;

    private static List<Storable> initObjects(Collection<UIObject> sources) {
        ArrayList<Storable> result = new ArrayList<Storable>();
        CoreObjectManagerService coreObjectManager = CoreObjectManager.getInstance();
        for (UIIdentifiedObject uIIdentifiedObject : sources) {
            String sourceId = uIIdentifiedObject.getId();
            String sourceClassName = uIIdentifiedObject.getClassName();
            if (!CallChain.class.getCanonicalName().equals(sourceClassName)) {
                throw new IllegalClassException("Unexpected class: " + sourceClassName + ". Class is not supported by reference regenerator.");
            }
            result.add(coreObjectManager.getManager(CallChain.class).getById((Object)sourceId));
        }
        return result;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'DELETE')")
    @RequestMapping(value={"/callchain/integration/bv"}, method={RequestMethod.DELETE})
    @Operation(summary="DeleteOrUnlinkBvCase", description="Delete or unlink bv case", tags={"Bulk Validator Integration API"})
    @AuditAction(auditAction="Delete or unlink bv case with selected DataSet name {{#dsName}} and CallChain id {{#callChainId}} in the project {{#projectId}}/{{#projectUuid}}")
    public void deleteOrUnlinkBvCase(@RequestParam(value="dsName") String dsName, @RequestParam(value="chainId") String callChainId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="isDeleting") Boolean isDeleting, @RequestParam(value="projectUuid") UUID projectUuid) throws IOException {
        IntegrationConfig bvConfig;
        CallChain callChain = (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)callChainId);
        IntegrationCallChainController.throwExceptionIfNull((Storable)callChain, null, callChainId, CallChain.class, "get callchain by id");
        if (isDeleting.booleanValue() && ((BvCaseContainingObjectManager)CoreObjectManager.getInstance().getSpecialManager(CallChain.class, BvCaseContainingObjectManager.class)).countBvCaseUsages((String)callChain.getBvCases().get(dsName)) == 1 && (bvConfig = IntegrationCallChainController.findIntegrationConfig("Bulk Validator Integration", projectId)) != null) {
            EngineControlIntegration engine = (EngineControlIntegration)EngineIntegrationRegistry.getInstance().find("Bulk Validator Integration");
            engine.delete(callChain, bvConfig, Maps2.map((Object)"dataset.name", (Object)dsName).build(), projectId);
        }
        callChain.getBvCases().remove(dsName);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'UPDATE')")
    @RequestMapping(value={"/callchain/integration/bv/read"}, method={RequestMethod.POST})
    @Operation(summary="ReadBVCase", description="Read BV Case", tags={"Bulk Validator Integration API"})
    @AuditAction(auditAction="Read BV case with selected DataSet name {{#dsName}} and CallChain id {{#chainId}} in the project {{#projectId}}/{{#projectUuid}}")
    public void readBvCase(@RequestParam(value="dsName") String dsName, @RequestParam(value="chainId") String chainId, @RequestBody Properties properties, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        IntegrationConfig integrationConf;
        EngineControlIntegration engine = (EngineControlIntegration)EngineIntegrationRegistry.getInstance().find("Bulk Validator Integration");
        if (engine != null) {
            integrationConf = IntegrationCallChainController.findIntegrationConfig("Bulk Validator Integration", projectId);
            if (integrationConf == null) {
                throw new IntegrationException("Bulk Validator Integration config isn't found for the project!");
            }
        } else {
            throw new IntegrationException("Bulk Validator Integration Engine isn't found in the registry!");
        }
        CallChain callChain = (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)chainId);
        engine.configure(callChain, integrationConf, Maps2.map((Object)"dataset.name", (Object)dsName).val((Object)"islLink", (Object)((String)properties.get("islLink"))).build(), projectId);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).CALLCHAIN.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/callchain/integration/bv/get/bvconfig"}, method={RequestMethod.GET})
    @Operation(summary="GetBvAction", description="Retrieve BV Case config", tags={"Bulk Validator Integration API"})
    @AuditAction(auditAction="Get BV action config for project {{#projectId}}/{{#projectUuid}}")
    public Map<String, Object> getBvAction(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String defaultAction = this.projectSettingsService.get((Object)projectId, "bv.default.action", "CreateNewTestRun");
        result.put("actions", ProjectSettingsConstants.BV_DEFAULT_ACTION_OPTIONS_VALUE);
        result.put("defaultAction", defaultAction);
        return result;
    }

    @Transactional
    @RequestMapping(value={"/callchain/integration/bv"}, method={RequestMethod.GET}, produces={"text/plain"})
    @Operation(summary="CreateBvCase", description="Create BV Case", tags={"Bulk Validator Integration API"})
    @AuditAction(auditAction="Create BV case using BV link {{#bvTcId}} with selected DataSet name {{#dsName}} and CallChain id {{#callChainId}} in the project {{#projectId}}/{{#projectUuid}}")
    public String createBvCase(@RequestParam(value="dsName") String dsName, @RequestParam(value="chainId") String callChainId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="bvTcId", required=false) String bvTcId) throws IOException {
        EngineControlIntegration engine = (EngineControlIntegration)EngineIntegrationRegistry.getInstance().find("Bulk Validator Integration");
        if (engine != null) {
            IntegrationConfig integrationConf = IntegrationCallChainController.findIntegrationConfig("Bulk Validator Integration", projectId);
            if (integrationConf != null) {
                CallChain callChain = (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)callChainId);
                if (bvTcId == null) {
                    engine.create(callChain, integrationConf, Maps2.map((Object)"dataset.name", (Object)dsName).build(), projectId);
                } else {
                    callChain.getBvCases().putAll(Maps2.map((Object)dsName, (Object)bvTcId).build());
                    if (!engine.isExist((Storable)callChain, integrationConf, Maps2.map((Object)"dataset.name", (Object)dsName).build(), projectId)) {
                        throw new IntegrationException("BV Test Case with ID '" + bvTcId + "' isn't found");
                    }
                }
                callChain.store();
                return (String)callChain.getBvCases().get(dsName);
            }
            throw new IntegrationException("Bulk Validator Integration config isn't found for the project!");
        }
        throw new IntegrationException("Bulk Validator Integration Engine isn't found in the registry!");
    }

    @Transactional
    @RequestMapping(value={"/callchain/integration/bv/regenerate"}, method={RequestMethod.PUT}, produces={"application/json"})
    @Operation(summary="RegenerateBvCases", description="Copy BV testcases linked with callchain + dataset", tags={"Bulk Validator Integration API"})
    @AuditAction(auditAction="Copy BV testcases linked with CallChain and Dataset in the project {{#projectId}}")
    public List<UIObject> regenerateBvCases(@RequestParam(value="create_new") boolean createNew, @RequestParam(value="projectId") BigInteger projectId, @RequestBody List<UIObject> objects) throws Exception {
        EngineControlIntegration engine = (EngineControlIntegration)EngineIntegrationRegistry.getInstance().find("Bulk Validator Integration");
        if (engine != null) {
            IntegrationConfig integrationConf = IntegrationCallChainController.findIntegrationConfig("Bulk Validator Integration", projectId);
            HashSet<CallChain> callChains = new HashSet<CallChain>(Collector.collectCallChainsFromCallChainsAndFolders(IntegrationCallChainController.initObjects(objects)));
            for (CallChain callChain : callChains) {
                CallChain callChainNatural = (CallChain)IntegrationCallChainController.getManager(CallChain.class).getById(callChain.getNaturalId());
                if (callChainNatural == null) {
                    log.warn("No natural parent found for callchain with id {}, so skipping BulkValidator links regeneration", callChain.getID());
                    continue;
                }
                if (createNew) {
                    for (Map.Entry bvCase : callChainNatural.getBvCases().entrySet()) {
                        String newTcId = engine.copyWithName(integrationConf, "", bvCase.getValue().toString(), projectId);
                        callChain.getBvCases().put(bvCase.getKey().toString(), newTcId);
                    }
                } else {
                    callChain.setBvCases(new HashMap(callChainNatural.getBvCases()));
                }
                callChain.store();
            }
        } else {
            throw new IntegrationException("Bulk Validator Integration Engine isn't found in the registry!");
        }
        return objects;
    }

    @ConstructorProperties(value={"projectSettingsService"})
    public IntegrationCallChainController(ProjectSettingsService projectSettingsService) {
        this.projectSettingsService = projectSettingsService;
    }
}

