/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.files;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.UUID;
import org.bson.types.ObjectId;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.representations.AccessToken;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.operation.FileProcessingException;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.model.FileEventType;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.core.util.eds.service.FileManagementService;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.util.FileUploadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class FileUploadController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);
    private final ExternalDataManagementService externalDataManagementService;
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;

    @Autowired
    public FileUploadController(ExternalDataManagementService externalDataManagementService, ExecutorToMessageBrokerSender executorToMessageBrokerSender) {
        this.externalDataManagementService = externalDataManagementService;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
    }

    @Transactional
    @PreAuthorize(value="(@entityAccess.checkAccess(#projectUuid, \"READ\") and !T(org.qubership.automation.itf.core.util.eds.service.EdsContentType).KEYSTORE.equals(#contentType) and !T(org.qubership.automation.itf.core.util.eds.service.EdsContentType).FAST_STUB.equals(#contentType)) or (@entityAccess.isSupport() or @entityAccess.isAdmin())")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Upload files with {{#contentType}} contentType, {{#filePath}} filePath for project {{#projectId}}")
    public UIResult uploadAttachments(@RequestParam(value="contentType") EdsContentType contentType, @RequestParam(value="filePath", required=false, defaultValue="") String filePath, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestHeader(value="X-Project-Id") String tenantId, @RequestParam(value="file") MultipartFile[] files) throws IOException {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String userName = "Undefined";
        UUID userId = null;
        if (principal instanceof KeycloakPrincipal) {
            AccessToken accessToken = ((KeycloakPrincipal)principal).getKeycloakSecurityContext().getToken();
            userId = UUID.fromString(((KeycloakPrincipal)principal).getName());
            userName = accessToken.getName();
        }
        log.info("Upload files to: contentType '{}', filePath '{}', projectId '{}', by user [name: {}, id: {}]...", new Object[]{contentType, filePath, projectId, userName, userId});
        FileManagementService fileManagementService = this.externalDataManagementService.getFileManagementService();
        filePath = fileManagementService.calcPredefinedPath(contentType.getStringValue(), filePath);
        String predefinedFileName = fileManagementService.calcPredefinedFileName(contentType.getStringValue(), null);
        if (fileManagementService.isContentTypeExist(contentType.getStringValue())) {
            if (fileManagementService.dontUseProjectForCreatingDirectory(contentType.getStringValue())) {
                log.info("Prepare to upload non-project files...");
                return this.uploadFiles(contentType.getStringValue(), null, filePath, files, tenantId, predefinedFileName, userName, userId);
            }
            StubProject project = (StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)projectId);
            if (project != null) {
                log.info("Prepare to upload files, project uuid = {}, id = {}...", (Object)projectUuid, (Object)projectId);
                return this.uploadFiles(contentType.getStringValue(), projectUuid, filePath, files, tenantId, predefinedFileName, userName, userId);
            }
            log.error("Project with id = {} is not found", (Object)projectId);
            return new UIResult(false, String.format("Project with id = %s is not found", projectId));
        }
        log.error("Content type = {} is not supported", (Object)contentType);
        return new UIResult(false, String.format("Content type=%s is not supported", contentType));
    }

    private UIResult uploadFiles(String contentType, UUID projectUuid, String filePath, MultipartFile[] files, String tenantId, String predefinedFileName, String userName, UUID userId) {
        int cnt = 0;
        for (MultipartFile file : files) {
            try {
                log.info("Prepare to store file '{}' ...", (Object)file.getName());
                String fileName = file.getOriginalFilename();
                if (predefinedFileName != null) {
                    log.info("File '{}' will be renamed to '{}' because it's name predefined by system logic...", (Object)file.getName(), (Object)predefinedFileName);
                    fileName = predefinedFileName;
                }
                ObjectId storedObjectId = this.externalDataManagementService.getExternalStorageService().store(contentType, projectUuid, userName, userId, filePath, fileName, file.getInputStream());
                log.info("File '{}' is stored. Prepare to duplicate/notify others via topic...", (Object)file.getName());
                FileUploadHelper.checkStoredObjectIdAndSendMessageToExternalDataStorageUpdateTopic(storedObjectId, fileName, filePath, contentType, projectUuid, new ByteArrayInputStream(file.getBytes()), FileEventType.UPLOAD, this.executorToMessageBrokerSender, tenantId);
                file.getInputStream().close();
                log.info("File '{}' processing is completed", (Object)file.getName());
                ++cnt;
            }
            catch (IOException e) {
                throw new FileProcessingException(e.getMessage());
            }
        }
        String msg = cnt > 0 ? "All (" + cnt + ") files are uploaded successfully." : "No files to process!";
        log.info(msg);
        return new UIResult(true, msg);
    }
}

