/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.diameter;

import java.util.List;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.diameter.DiameterConnectionInfo;
import org.qubership.automation.itf.core.util.DiameterConnectionInfoCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DiameterConnectionsController {
    private static final Logger log = LoggerFactory.getLogger(DiameterConnectionsController.class);
    private DiameterConnectionInfoCacheService diameterConnectionInfoCacheService;

    @Autowired
    public void setDiameterConnectionInfoCacheService(DiameterConnectionInfoCacheService diameterConnectionInfoCacheService) {
        this.diameterConnectionInfoCacheService = diameterConnectionInfoCacheService;
    }

    @PreAuthorize(value="@entityAccess.isSupport()")
    @GetMapping(value={"/tools/connections"})
    @AuditAction(auditAction="Get Diameter connections list")
    public List<DiameterConnectionInfo> getDiameterConnections() {
        return this.diameterConnectionInfoCacheService.getAllDiameterConnections();
    }

    @PreAuthorize(value="@entityAccess.isSupport()")
    @GetMapping(value={"/tools/drop"})
    @AuditAction(auditAction="Drop Diameter connection with key {{#key}}")
    public List<DiameterConnectionInfo> dropDiameterConnection(@RequestParam String key) {
        this.diameterConnectionInfoCacheService.remove(key);
        log.info(key + " is dropped");
        return this.getDiameterConnections();
    }
}

