/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.export;

import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.project.ProjectSettings;
import org.qubership.automation.itf.core.util.descriptor.Extractor;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.PropertyProvider;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.executor.transports.classloader.TransportClassLoader;
import org.qubership.automation.itf.ui.controls.service.export.TemplateExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExtraObjectsCollector {
    private static final Logger log = LoggerFactory.getLogger(ExtraObjectsCollector.class);
    private final TemplateExtractor templateExtractor;
    private final ProjectSettingsService projectSettingsService;
    private final Map<String, BiFunction<Storable, Map<String, Set<Object>>, Map<Object, Storable>>> functionsMap = new HashMap<String, BiFunction<Storable, Map<String, Set<Object>>, Map<Object, Storable>>>();

    public Map<Object, Storable> collect(Storable storable, Map<String, Set<Object>> checkedObjectsMap) {
        String storableName = storable.getClass().getSimpleName();
        log.info("Collecting of extra objects for type {} is started...", (Object)storableName);
        BiFunction<Storable, Map<String, Set<Object>>, Map<Object, Storable>> function = this.functionsMap.get(storable.getClass().getName());
        Objects.requireNonNull(function, String.format("Function to collect extra objects for object [%s] was not found.", storableName));
        Map<Object, Storable> extraObjects = function.apply(storable, checkedObjectsMap);
        log.info("Collecting of extra objects for type {} is completed.", (Object)storableName);
        return extraObjects;
    }

    private Map<Object, Storable> getExtraObjectsForCallChain(CallChain callChain, Map<String, Set<Object>> checkedObjectsMap) {
        HashMap<Object, Storable> extraObjects = new HashMap<Object, Storable>();
        if (!checkedObjectsMap.get(CallChain.class.getSimpleName()).contains(callChain.getID())) {
            log.info("List of checked callchain ids doesn't contain id {}. Callchain is checked...", callChain.getID());
            checkedObjectsMap.get(CallChain.class.getSimpleName()).add(callChain.getID());
            extraObjects.put(callChain.getID(), (Storable)callChain);
            for (Step step : callChain.getSteps()) {
                CallChain nested;
                if (step == null) continue;
                if (step instanceof SituationStep) {
                    if (((SituationStep)step).getSituation() == null) continue;
                    extraObjects.putAll(this.getExtraObjectsForSystem(((SituationStep)step).getSituation().getParent().getParent(), checkedObjectsMap));
                    this.collectSystemsFromSituations(extraObjects, ((SituationStep)step).getEndSituations(), checkedObjectsMap);
                    this.collectSystemsFromSituations(extraObjects, ((SituationStep)step).getExceptionalSituations(), checkedObjectsMap);
                    continue;
                }
                if (!(step instanceof EmbeddedStep) || (nested = ((EmbeddedStep)step).getChain()) == null) continue;
                extraObjects.putAll(this.getExtraObjectsForCallChain(nested, checkedObjectsMap));
            }
        } else {
            log.info("List of checked callchains ids already contains id {}. Callchain is skipped.", callChain.getID());
        }
        return extraObjects;
    }

    private void collectSystemsFromSituations(Map<Object, Storable> extraObjects, Set<Situation> situations, Map<String, Set<Object>> checkedObjectsMap) {
        for (Situation endSituation : situations) {
            extraObjects.putAll(this.getExtraObjectsForSystem(endSituation.getParent().getParent(), checkedObjectsMap));
        }
    }

    private Map<Object, Storable> getExtraObjectsForSystem(System system, Map<String, Set<Object>> checkedObjectsMap) {
        HashMap extraObjects = Maps.newHashMap();
        if (!checkedObjectsMap.get(System.class.getSimpleName()).contains(system.getID())) {
            log.info("List of checked systems ids doesn't contain id {}. System is checked...", system.getID());
            checkedObjectsMap.get(System.class.getSimpleName()).add(system.getID());
            extraObjects.put(system.getID(), system);
            this.collectSystemsThroughSituationEventTriggersAndReceivers(system, extraObjects, checkedObjectsMap);
        } else {
            log.info("List of checked systems ids already contains id {}. System is skipped.", system.getID());
        }
        return extraObjects;
    }

    private Map<Object, Storable> getExtraObjectsForFolder(Folder<?> folder) {
        HashMap extraObjects = Maps.newHashMap();
        folder.getObjects().forEach(storable -> extraObjects.put(storable.getID(), storable));
        folder.getSubFolders().forEach(subFolder -> extraObjects.putAll(this.getExtraObjectsForFolder((Folder<?>)subFolder)));
        return extraObjects;
    }

    private Map<Object, Storable> getProjectSettingsFromProject(StubProject project) {
        HashMap extraObjects = Maps.newHashMap();
        Object projectId = project.getID();
        ProjectSettings settings = new ProjectSettings(this.projectSettingsService.getAll(projectId));
        settings.setID(projectId);
        extraObjects.put(projectId, settings);
        return extraObjects;
    }

    private Map<Object, Storable> getIntegrationConfigsForProject(IntegrationConfig integrationConfig) {
        HashMap extraObjects = Maps.newHashMap();
        extraObjects.put(integrationConfig.getID(), integrationConfig);
        return extraObjects;
    }

    private void collectSystemsThroughSituationEventTriggersAndReceivers(System system, Map<Object, Storable> extraObjects, Map<String, Set<Object>> checkedObjectsMap) {
        if (Objects.isNull(system.getParent())) {
            log.error("Extra objects search is skipped for System '{}' [id={}], because its parent is null", (Object)system.getName(), system.getID());
            return;
        }
        BigInteger projectId = system.getParent().getProjectId();
        this.collectSystemsFromLoadPartInTemplates((TemplateProvider)system, extraObjects, checkedObjectsMap, projectId);
        this.collectSystemsFromDiameterTransportFields(system, extraObjects, checkedObjectsMap);
        for (Operation operation : system.getOperations()) {
            this.collectSystemsFromLoadPartInTemplates((TemplateProvider)operation, extraObjects, checkedObjectsMap, projectId);
            for (Situation situation : operation.getSituations()) {
                if (Objects.nonNull(situation.getIntegrationStep()) && situation.getIntegrationStep().getReceiver() != null) {
                    extraObjects.putAll(this.getExtraObjectsForSystem(situation.getIntegrationStep().getReceiver(), checkedObjectsMap));
                }
                for (SituationEventTrigger situationEventTrigger : situation.getSituationEventTriggers()) {
                    if (!Objects.nonNull(situationEventTrigger.getSituation())) continue;
                    extraObjects.putAll(this.getExtraObjectsForSystem(situationEventTrigger.getSituation().getParent().getParent(), checkedObjectsMap));
                }
            }
        }
    }

    private Map<Object, Storable> getExtraObjectsForEnvironment(Environment environment, Map<String, Set<Object>> checkedObjectsMap) {
        HashMap<Object, Storable> extraObjects = new HashMap<Object, Storable>();
        this.collectObjectsFromMapConfiguration(extraObjects, environment.getInbound(), checkedObjectsMap);
        this.collectObjectsFromMapConfiguration(extraObjects, environment.getOutbound(), checkedObjectsMap);
        this.collectSystemsFromExtraSettings(environment, extraObjects, checkedObjectsMap);
        return extraObjects;
    }

    private void collectObjectsFromMapConfiguration(Map<Object, Storable> extraObjects, Map<System, Server> mapConfiguration, Map<String, Set<Object>> checkedObjectsMap) {
        for (Map.Entry<System, Server> map : mapConfiguration.entrySet()) {
            extraObjects.putAll(this.getExtraObjectsForSystem(map.getKey(), checkedObjectsMap));
            extraObjects.putAll(this.getExtraObjectsForServer(map.getValue(), checkedObjectsMap));
        }
    }

    private Map<Object, Storable> getExtraObjectsForServer(Server server, Map<String, Set<Object>> checkedObjectsMap) {
        HashMap<Object, Storable> extraObjects = new HashMap<Object, Storable>();
        if (!checkedObjectsMap.get(ServerHB.class.getSimpleName()).contains(server.getID())) {
            log.info("List of checked servers ids doesn't contain id {}. Server is checked...", server.getID());
            checkedObjectsMap.get(ServerHB.class.getSimpleName()).add(server.getID());
            extraObjects.put(server.getID(), (Storable)server);
        } else {
            log.info("List of checked servers ids already contains id {}. Server is skipped.", server.getID());
        }
        return extraObjects;
    }

    private void collectObjectsFromInboundTransportConfig(Map<Object, Storable> extraObjects, Collection<InboundTransportConfiguration> inboundTransportConfig, Map<String, Set<Object>> checkedObjectsMap) {
        for (InboundTransportConfiguration inboundTransport : inboundTransportConfig) {
            extraObjects.putAll(this.getExtraObjectsForSystem(inboundTransport.getReferencedConfiguration().getParent(), checkedObjectsMap));
        }
    }

    private void collectObjectsFromOutboundTransportConfig(Map<Object, Storable> extraObjects, Collection<OutboundTransportConfiguration> outboundTransportConfig, Map<String, Set<Object>> checkedObjectsMap) {
        for (OutboundTransportConfiguration outboundTransport : outboundTransportConfig) {
            extraObjects.putAll(this.getExtraObjectsForSystem(outboundTransport.getSystem(), checkedObjectsMap));
        }
    }

    private void collectSystemsFromExtraSettings(Environment environment, Map<Object, Storable> extraObjects, Map<String, Set<Object>> checkedObjectsMap) {
        Map extraSystems = environment.getReportCollectors().stream().map(configuration -> (String)configuration.getConfiguration().get("system")).filter(id -> !id.isEmpty() && !((Set)checkedObjectsMap.get(System.class.getSimpleName())).contains(id)).collect(Collectors.toMap(Function.identity(), id -> (System)CoreObjectManager.getInstance().getManager(System.class).getById(id), (existing, replacement) -> existing, HashMap::new));
        extraSystems.values().forEach(system -> extraObjects.putAll(this.getExtraObjectsForSystem((System)system, checkedObjectsMap)));
        extraObjects.putAll(extraSystems);
    }

    public void collectParents(Storable source, ConcurrentHashMap<Object, Pair<Folder<?>, Integer>> collectTo) {
        Storable current = source.getParent();
        while (Objects.nonNull(current) && Objects.nonNull(current.getParent())) {
            if (current instanceof Folder) {
                collectTo.put(current.getID(), (Pair<Folder<?>, Integer>)new ImmutablePair((Object)this.simpleFolder((Folder)current), (Object)((Folder)current).hierarchyLevel()));
                current = current.getParent();
                continue;
            }
            log.warn("Parent of {} is not Folder but {}", (Object)current, current.getParent().getClass());
            break;
        }
    }

    private <T extends Folder<?>> T simpleFolder(T source) {
        try {
            Folder simpleFolder = (Folder)source.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            simpleFolder.setProject(source.getProject());
            simpleFolder.setTypeName(source.getTypeName());
            simpleFolder.setParent(source.getParent());
            simpleFolder.setID(source.getID());
            simpleFolder.setName(source.getName());
            simpleFolder.setVersion(source.getVersion());
            simpleFolder.setLabels(source.getLabels());
            simpleFolder.setPrefix(source.getPrefix());
            simpleFolder.setDescription(source.getDescription());
            simpleFolder.setStorableProp(source.getStorableProp());
            return (T)simpleFolder;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Folder instantiation exception", e);
        }
    }

    private Set<System> extractSystemFromLoadPart(String content, BigInteger projectId) {
        Set<String> loadPartTemplateIdentifiers = this.templateExtractor.findLoadPartTemplates(content);
        if (Objects.isNull(loadPartTemplateIdentifiers) || loadPartTemplateIdentifiers.isEmpty()) {
            return new HashSet<System>();
        }
        HashSet<System> systems = new HashSet<System>();
        for (String templateIdentifier : loadPartTemplateIdentifiers) {
            Template<? extends TemplateProvider> templateObject = this.templateExtractor.getTemplateObject(templateIdentifier, projectId);
            if (!Objects.nonNull(templateObject)) continue;
            System system = this.getSystem(templateObject);
            systems.add(system);
        }
        return systems;
    }

    private System getSystem(Template<? extends TemplateProvider> template) {
        return template instanceof SystemTemplate ? (System)template.getParent() : (System)template.getParent().getParent();
    }

    private void collectSystemsFromDiameterTransportFields(System system, Map<Object, Storable> extraObjects, Map<String, Set<Object>> checkedObjectsMap) {
        for (TransportConfiguration transport : system.getTransports()) {
            if (!"org.qubership.automation.itf.transport.diameter.outbound.DiameterOutbound".equals(transport.getTypeName())) continue;
            BigInteger projectId = system.getParent().getProjectId();
            List<PropertyDescriptor> transportPropertiesDescriptor = this.getTransportPropertyDescriptor(transport);
            if (transportPropertiesDescriptor.isEmpty()) continue;
            for (PropertyDescriptor property : transportPropertiesDescriptor) {
                Template<? extends TemplateProvider> templateObject;
                String shortName;
                String propertyValue;
                if (!property.loadTemplate() || !StringUtils.isNotEmpty((String)(propertyValue = transport.get((Object)(shortName = property.getShortName())))) || !Objects.nonNull(templateObject = this.templateExtractor.getTemplateObject(propertyValue, projectId))) continue;
                if (!checkedObjectsMap.get(Template.class.getSimpleName()).contains(templateObject.getID())) {
                    log.info("Diameter - List of checked templates doesn't contain template with id {}. It will be added and checked.", templateObject.getID());
                    checkedObjectsMap.get(Template.class.getSimpleName()).add(templateObject.getID());
                    extraObjects.putAll(this.getExtraObjectsForSystem(this.getSystem(templateObject), checkedObjectsMap));
                    continue;
                }
                log.info("Diameter - List of checked templates already contains template with id {}. Checking of template is skipped.", templateObject.getID());
            }
        }
    }

    private List<PropertyDescriptor> getTransportPropertyDescriptor(TransportConfiguration transport) {
        try {
            ClassLoader classLoader = ((ClassLoader)TransportClassLoader.getInstance().getClassLoaderHolder().get(transport.getTypeName())).loadClass(transport.getTypeName()).getClassLoader();
            return Extractor.extractProperties((PropertyProvider)((PropertyProvider)Class.forName(transport.getTypeName(), false, classLoader).newInstance()));
        }
        catch (Exception e) {
            log.error("Can't define transport properties '{}' while objects export", (Object)transport.getTypeName(), (Object)e);
            return new ArrayList<PropertyDescriptor>();
        }
    }

    private void collectSystemsFromLoadPartInTemplates(TemplateProvider templateProvider, Map<Object, Storable> extraObjects, Map<String, Set<Object>> checkedObjectsMap, BigInteger projectId) {
        for (Template template : templateProvider.returnTemplates()) {
            if (!checkedObjectsMap.get(Template.class.getSimpleName()).contains(template.getID())) {
                log.info("List of checked templates doesn't contain template with id {}. It will be added and checked.", template.getID());
                checkedObjectsMap.get(Template.class.getSimpleName()).add(template.getID());
                Set<System> systems = this.extractSystemFromLoadPart(template.getText(), projectId);
                for (System extractedSystem : systems) {
                    extraObjects.putAll(this.getExtraObjectsForSystem(extractedSystem, checkedObjectsMap));
                }
                continue;
            }
            log.info("List of checked templates already contains template with id {}. Checking of template is skipped.", template.getID());
        }
    }

    @ConstructorProperties(value={"templateExtractor", "projectSettingsService"})
    public ExtraObjectsCollector(TemplateExtractor templateExtractor, ProjectSettingsService projectSettingsService) {
        this.functionsMap.put(CallChain.class.getName(), (obj, checkedObjectsMap) -> this.getExtraObjectsForCallChain((CallChain)obj, (Map<String, Set<Object>>)checkedObjectsMap));
        this.functionsMap.put(System.class.getName(), (obj, checkedObjectsMap) -> this.getExtraObjectsForSystem((System)obj, (Map<String, Set<Object>>)checkedObjectsMap));
        this.functionsMap.put(Environment.class.getName(), (obj, checkedObjectsMap) -> this.getExtraObjectsForEnvironment((Environment)obj, (Map<String, Set<Object>>)checkedObjectsMap));
        this.functionsMap.put(ChainFolder.class.getName(), (obj, checkedObjectsMap) -> this.getExtraObjectsForFolder((Folder<?>)((ChainFolder)obj)));
        this.functionsMap.put(EnvFolder.class.getName(), (obj, checkedObjectsMap) -> this.getExtraObjectsForFolder((Folder<?>)((EnvFolder)obj)));
        this.functionsMap.put(SystemFolder.class.getName(), (obj, checkedObjectsMap) -> this.getExtraObjectsForFolder((Folder<?>)((SystemFolder)obj)));
        this.functionsMap.put(ServerHB.class.getName(), (obj, checkedObjectsMap) -> this.getExtraObjectsForServer((Server)((ServerHB)obj), (Map<String, Set<Object>>)checkedObjectsMap));
        this.functionsMap.put(StubProject.class.getName(), (obj, checkedObjectsMap) -> this.getProjectSettingsFromProject((StubProject)obj));
        this.functionsMap.put(IntegrationConfig.class.getName(), (obj, checkedObjectsMap) -> this.getIntegrationConfigsForProject((IntegrationConfig)obj));
        this.templateExtractor = templateExtractor;
        this.projectSettingsService = projectSettingsService;
    }
}

