/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.export;

import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.Hibernate;
import org.qubership.atp.ei.node.ExportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.project.ProjectSettings;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.service.export.ExtraObjectsCollector;
import org.qubership.automation.itf.ui.controls.service.export.ServiceScopeEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItfExportExecutor
implements ExportExecutor {
    private static final Logger log = LoggerFactory.getLogger(ItfExportExecutor.class);
    private final ObjectSaverToDiskService objectSaverToDiskService;
    private final ExtraObjectsCollector extraObjectsCollector;
    private final LinkedList<String> typesForExportInCorrectImportOrder = new LinkedList<String>(Arrays.asList(ProjectSettings.class.getName(), IntegrationConfig.class.getName(), System.class.getName(), ServerHB.class.getName(), CallChain.class.getName(), Environment.class.getName()));
    @Value(value="${spring.application.name}")
    private String implementationName;

    @Transactional(readOnly=true)
    public void exportToFolder(ExportImportData exportImportData, Path path) {
        log.info("Export started...");
        Map<String, Set<Object>> checkedObjectsMap = this.getCheckedObjectsMap();
        ConcurrentHashMap<Object, Storable> storablesForExport = new ConcurrentHashMap<Object, Storable>();
        this.extractFoldersFromExportImportData(exportImportData).stream().forEach(exportObject -> this.addObjectToStorablesForExport((Pair<String, String>)exportObject, storablesForExport, checkedObjectsMap, true));
        this.extractChildren(storablesForExport.values()).stream().forEach(storableObject -> this.addObjectToStorablesForExport((Storable)storableObject, storablesForExport, checkedObjectsMap, true));
        this.extractChildrenStorablesFromExportImportData(exportImportData).stream().forEach(exportObject -> this.addObjectToStorablesForExport((Pair<String, String>)exportObject, storablesForExport, checkedObjectsMap, false));
        ConcurrentHashMap parentsMap = new ConcurrentHashMap();
        storablesForExport.values().stream().forEach(storable -> this.extraObjectsCollector.collectParents((Storable)storable, parentsMap));
        parentsMap.values().forEach(parentObject -> this.saveToDisk((Storable)parentObject.getKey(), this.parentPath(path, (Integer)parentObject.getValue())));
        this.applyTcFilterForServer(checkedObjectsMap, storablesForExport);
        storablesForExport.values().forEach(storable -> this.saveToDisk((Storable)storable, this.otherObjectsPath(path, (Storable)storable)));
        this.cleanCheckedObjectsMap(checkedObjectsMap);
        log.info("Export completed.");
    }

    private List<Storable> extractChildren(Collection<Storable> storables) {
        ArrayList<Storable> childrenList = new ArrayList<Storable>();
        for (Storable storable : storables) {
            if (!(storable instanceof CallChain) && !(storable instanceof System) && !(storable instanceof Environment)) continue;
            childrenList.add(storable);
        }
        return childrenList;
    }

    private void applyTcFilterForServer(Map<String, Set<Object>> checkedObjectsMap, ConcurrentHashMap<Object, Storable> storableObjectsForExport) {
        log.info("Applying OutboundTransportConfiguration filter for Server objects is started...");
        Set<Object> systemIdsForExport = checkedObjectsMap.get(System.class.getSimpleName());
        Object[] serverIdsForExport = checkedObjectsMap.get(ServerHB.class.getSimpleName()).toArray();
        this.applyTcFilter(storableObjectsForExport, serverIdsForExport, systemIdsForExport);
        log.info("Applying OutboundTransportConfiguration filter for Server objects is completed.");
    }

    private void applyTcFilter(ConcurrentHashMap<Object, Storable> storableObjectsForExport, Object[] serverIdsForExport, Set<Object> systemIdsForExport) {
        for (Object serverId : serverIdsForExport) {
            Collection inbounds;
            ServerHB exportedServer = (ServerHB)storableObjectsForExport.get(serverId);
            Collection outbounds = exportedServer.getOutbounds();
            if (!Objects.isNull(outbounds) && !outbounds.isEmpty()) {
                Set<OutboundTransportConfiguration> filteredOutbounds = this.collectOtcByExportedSystems(outbounds, systemIdsForExport);
                exportedServer.fillOutbounds(filteredOutbounds);
            }
            if (Objects.isNull(inbounds = exportedServer.getInbounds()) || inbounds.isEmpty()) continue;
            Set<InboundTransportConfiguration> filteredInbounds = this.collectItcByExportedSystems(inbounds, systemIdsForExport);
            exportedServer.fillInbounds(filteredInbounds);
        }
    }

    private Set<OutboundTransportConfiguration> collectOtcByExportedSystems(Collection<OutboundTransportConfiguration> outbounds, Set<Object> systemIdsForExport) {
        HashSet<OutboundTransportConfiguration> filteredOutbounds = new HashSet<OutboundTransportConfiguration>();
        for (OutboundTransportConfiguration otc : outbounds) {
            Object systemIdUnderOtc;
            System systemUnderOtc = otc.getSystem();
            if (Objects.isNull(systemUnderOtc) || !systemIdsForExport.contains(systemIdUnderOtc = systemUnderOtc.getID())) continue;
            filteredOutbounds.add(otc);
        }
        return filteredOutbounds;
    }

    private Set<InboundTransportConfiguration> collectItcByExportedSystems(Collection<InboundTransportConfiguration> inbounds, Set<Object> systemIdsForExport) {
        HashSet<InboundTransportConfiguration> filteredInbounds = new HashSet<InboundTransportConfiguration>();
        for (InboundTransportConfiguration itc : inbounds) {
            Object systemIdUnderItc;
            System systemUnderItc = itc.getReferencedConfiguration().getParent();
            if (Objects.isNull(systemUnderItc) || !systemIdsForExport.contains(systemIdUnderItc = systemUnderItc.getID())) continue;
            filteredInbounds.add(itc);
        }
        return filteredInbounds;
    }

    private Path parentPath(Path initialPath, int order) {
        return initialPath.resolve(Paths.get(StringUtils.leftPad((String)String.valueOf(order), (int)4, (char)'0') + "_Parent", new String[0]));
    }

    private Path otherObjectsPath(Path initialPath, Storable storable) {
        return initialPath.resolve(Paths.get("1" + StringUtils.leftPad((String)String.valueOf(this.typesForExportInCorrectImportOrder.indexOf(storable.getClass().getName()) + 1), (int)3, (char)'0') + "_" + storable.getClass().getSimpleName(), new String[0]));
    }

    private void addObjectToStorablesForExport(Pair<String, String> objectForExportInfo, ConcurrentHashMap<Object, Storable> storablesForExport, Map<String, Set<Object>> checkedObjectsMap, boolean onlyExtra) {
        TxExecutor.executeVoid(() -> {
            try {
                Storable storable = CoreObjectManager.getInstance().getManager(Class.forName((String)objectForExportInfo.getKey()).asSubclass(Storable.class)).getById(objectForExportInfo.getValue());
                if (Objects.nonNull(storable)) {
                    storable = (Storable)Hibernate.unproxy((Object)storable);
                    log.info("Storable name: {}, class {}, id: {}", new Object[]{storable.getName(), storable.getClass(), storable.getID()});
                    if (!onlyExtra) {
                        storablesForExport.put(storable.getID(), storable);
                    }
                    storablesForExport.putAll(this.extraObjectsCollector.collect(storable, checkedObjectsMap));
                } else {
                    log.error("Object is excluded from export, because was not found. Object of class '{}', id={}", objectForExportInfo.getKey(), objectForExportInfo.getValue());
                }
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
    }

    private void addObjectToStorablesForExport(Storable storable, ConcurrentHashMap<Object, Storable> storablesForExport, Map<String, Set<Object>> checkedObjectsMap, boolean onlyExtra) {
        TxExecutor.executeVoid(() -> {
            log.info("[#2] Storable name: {}, class {}, id: {}", new Object[]{storable.getName(), storable.getClass(), storable.getID()});
            if (!onlyExtra) {
                storablesForExport.put(storable.getID(), storable);
            }
            storablesForExport.putAll(this.extraObjectsCollector.collect(storable, checkedObjectsMap));
        }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
    }

    private void saveToDisk(Storable exportObject, Path path) {
        this.objectSaverToDiskService.exportAtpEntity(UUID.nameUUIDFromBytes(exportObject.getID().toString().getBytes(StandardCharsets.UTF_8)), (Object)exportObject, path);
    }

    private List<Pair<String, String>> extractChildrenStorablesFromExportImportData(ExportImportData exportImportData) {
        ArrayList<Pair<String, String>> processed = new ArrayList<Pair<String, String>>();
        Map exportScopeEntities = exportImportData.getExportScope().getEntities();
        processed.addAll(this.transformSetToListOfPairs(CallChain.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_CALL_CHAINS.getValue(), new HashSet())));
        processed.addAll(this.transformSetToListOfPairs(System.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_SYSTEMS.getValue(), new HashSet())));
        processed.addAll(this.transformSetToListOfPairs(Environment.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_ENVIRONMENTS.getValue(), new HashSet())));
        processed.addAll(this.transformSetToListOfPairs(IntegrationConfig.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_INTEGRATION_CONFIGS.getValue(), new HashSet())));
        processed.addAll(this.transformSetToListOfPairs(StubProject.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_PROJECT_SETTINGS.getValue(), new HashSet())));
        return processed;
    }

    private List<Pair<String, String>> extractFoldersFromExportImportData(ExportImportData exportImportData) {
        ArrayList<Pair<String, String>> processed = new ArrayList<Pair<String, String>>();
        Map exportScopeEntities = exportImportData.getExportScope().getEntities();
        processed.addAll(this.transformSetToListOfPairs(ChainFolder.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_CALL_CHAIN_FOLDERS.getValue(), new HashSet())));
        processed.addAll(this.transformSetToListOfPairs(SystemFolder.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_SYSTEM_FOLDERS.getValue(), new HashSet())));
        processed.addAll(this.transformSetToListOfPairs(EnvFolder.class.getName(), exportScopeEntities.getOrDefault(ServiceScopeEntities.ENTITY_ITF_ENVIRONMENT_FOLDERS.getValue(), new HashSet())));
        return processed;
    }

    private List<Pair<String, String>> transformSetToListOfPairs(String className, Set<String> objects) {
        ArrayList<Pair<String, String>> collected = new ArrayList<Pair<String, String>>();
        objects.forEach(s -> collected.add((Pair<String, String>)new ImmutablePair((Object)className, s)));
        return collected;
    }

    public String getExportImplementationName() {
        return this.implementationName;
    }

    private Map<String, Set<Object>> getCheckedObjectsMap() {
        HashMap<String, Set<Object>> checkedObjectsMap = new HashMap<String, Set<Object>>();
        checkedObjectsMap.put(Template.class.getSimpleName(), new HashSet());
        checkedObjectsMap.put(System.class.getSimpleName(), new HashSet());
        checkedObjectsMap.put(CallChain.class.getSimpleName(), new HashSet());
        checkedObjectsMap.put(ServerHB.class.getSimpleName(), new HashSet());
        return checkedObjectsMap;
    }

    private void cleanCheckedObjectsMap(Map<String, Set<Object>> checkedObjectsMap) {
        checkedObjectsMap.forEach((key, value) -> value.clear());
    }

    @ConstructorProperties(value={"objectSaverToDiskService", "extraObjectsCollector"})
    public ItfExportExecutor(ObjectSaverToDiskService objectSaverToDiskService, ExtraObjectsCollector extraObjectsCollector) {
        this.objectSaverToDiskService = objectSaverToDiskService;
        this.extraObjectsCollector = extraObjectsCollector;
    }
}

