/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.export;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.vavr.Function3;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Session;
import org.qubership.atp.ei.node.ImportExecutor;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SituationEventTriggerObjectManager;
import org.qubership.automation.itf.core.model.common.Identified;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.StubUser;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSyncActivationRequest;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.ServerFolder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.project.ProjectSettings;
import org.qubership.automation.itf.core.util.Pair;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.ui.controls.service.export.ItfReplicationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItfImportExecutor
implements ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(ItfImportExecutor.class);
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final ProjectSettingsService projectSettingsService;
    @PersistenceContext
    protected EntityManager entityManager;
    Map<String, Class> map = Maps.newLinkedHashMapWithExpectedSize((int)7);
    Map<String, Function3<ConcurrentHashMap<Object, ? extends Storable>, StubProject, Map<BigInteger, BigInteger>, Void>> beforeImportFunctionMap = new HashMap<String, Function3<ConcurrentHashMap<Object, ? extends Storable>, StubProject, Map<BigInteger, BigInteger>, Void>>();
    private ItfReplicationService itfReplicationService;
    @Value(value="${ei.waiting.project.creation.timeout}")
    private int EI_WAITING_PROJECT_CREATION_TIMEOUT;
    @Value(value="${ei.waiting.project.creation.attempt.count}")
    private int EI_WAITING_PROJECT_CREATION_ATTEMPT_COUNT;

    @Autowired
    public void setItfReplicationService(ItfReplicationService itfReplicationService) {
        this.itfReplicationService = itfReplicationService;
    }

    @Transactional
    public void importData(ExportImportData exportImportData, Path path) {
        Timestamp timestampMainImportStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("Main import process start. Start Time: {}", (Object)timestampMainImportStart);
        ObjectManager manager = CoreObjectManager.getInstance().getManager(StubProject.class);
        UUID importedProjectId = exportImportData.getImportedProjectId();
        UUID destinationProjectUuid = (UUID)exportImportData.getReplacementMap().get(importedProjectId);
        UUID resultProjectUuid = destinationProjectUuid != null ? destinationProjectUuid : importedProjectId;
        BigInteger projectId = this.getProjectIdByUuid(resultProjectUuid);
        StubProject targetProject = (StubProject)manager.getById((Object)projectId);
        List<Pair<Path, String>> foldersForImport = this.prepareListOfFoldersForImport(path);
        HashMap replacementMap = Maps.newHashMap();
        HashMap postImportActions = new HashMap();
        ArrayList<BigInteger> systemIds = new ArrayList<BigInteger>();
        TxExecutor.executeVoid(() -> {
            try {
                manager.setReplicationRole("replica");
                for (Pair importFolder : foldersForImport) {
                    log.warn("entityType: {}, exportImportData: {}", importFolder.getValue(), (Object)exportImportData);
                    this.importObjects((String)importFolder.getValue(), exportImportData, (Path)importFolder.getKey(), targetProject, replacementMap, systemIds);
                    Timestamp timestampFlushStart = new Timestamp(java.lang.System.currentTimeMillis());
                    log.info("Start flush for entities: {}. Start time: {}", importFolder.getValue(), (Object)timestampFlushStart);
                    try {
                        ((Session)this.entityManager.getDelegate()).flush();
                    }
                    catch (Exception ex) {
                        log.error("Error while import: ", (Throwable)ex);
                    }
                    Timestamp timestampFlushFinish = new Timestamp(java.lang.System.currentTimeMillis());
                    log.info("Finish flush for entities: {}. Finish time: {}, Duration: {}", new Object[]{importFolder.getValue(), timestampFlushFinish, this.getTimestampDifference(timestampFlushStart, timestampFlushFinish)});
                    if (!"System".equals(importFolder.getValue())) continue;
                    postImportActions.put("shouldActivateEventTriggers", true);
                }
            }
            catch (Exception e) {
                log.error("Error while import: ", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            finally {
                manager.setReplicationRole("origin");
            }
        }, (TransactionDefinition)TxExecutor.defaultWritableTransaction());
        Timestamp timestampMainImportFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("Main import process finish. Finish Time: {}, Duration: {}", (Object)timestampMainImportFinish, (Object)this.getTimestampDifference(timestampMainImportStart, timestampMainImportFinish));
        if (postImportActions.getOrDefault("shouldActivateEventTriggers", false).booleanValue()) {
            this.prepareAndSendSyncEventTriggersRequest(systemIds, resultProjectUuid);
        }
    }

    private void prepareAndSendSyncEventTriggersRequest(List<BigInteger> systemIds, UUID projectUuid) {
        log.info("Activate Event Triggers (make and send SyncActivationRequest)...");
        TxExecutor.executeVoid(() -> {
            try {
                ArrayList triggersToDeactivate = new ArrayList();
                ArrayList triggersToReactivate = new ArrayList();
                SituationEventTriggerObjectManager objectManager = (SituationEventTriggerObjectManager)CoreObjectManager.getInstance().getSpecialManager(SituationEventTrigger.class, SituationEventTriggerObjectManager.class);
                for (BigInteger id : systemIds) {
                    Map map = objectManager.getTriggersBriefInfoBySystem(id);
                    triggersToReactivate.addAll((Collection)map.get("ToReactivate"));
                    triggersToDeactivate.addAll((Collection)map.get("ToDeactivate"));
                    log.info("Getting info for system {} is done.", (Object)id);
                }
                EventTriggerSyncActivationRequest eventTriggerSyncActivationRequest = new EventTriggerSyncActivationRequest(triggersToDeactivate, triggersToReactivate, new StubUser(""), UUID.randomUUID().toString());
                this.executorToMessageBrokerSender.sendMessage((Object)eventTriggerSyncActivationRequest, "message-broker.configurator-executor-event-triggers.topic", "topic", projectUuid.toString());
            }
            catch (Exception e) {
                log.error("Error while making/sending of SyncActivationRequest: ", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }, (TransactionDefinition)TxExecutor.readOnlyTransaction());
        log.info("Activate Event Triggers (make and send SyncActivationRequest) is done.");
    }

    public ValidationResult preValidateData(ExportImportData exportImportData, Path path) throws Exception {
        return null;
    }

    public ValidationResult validateData(ExportImportData exportImportData, Path path) throws Exception {
        return null;
    }

    private String getTimestampDifference(Timestamp first, Timestamp second) {
        long minutes = (second.getTime() - first.getTime()) / 60000L;
        if (minutes == 0L) {
            return (second.getTime() - first.getTime()) / 1000L + " sec.";
        }
        return minutes + " min.";
    }

    public void importObjects(String entityType, ExportImportData exportImportData, Path path, StubProject project, Map<BigInteger, BigInteger> replacementMap, List<BigInteger> systemIds) throws Exception {
        Timestamp timestampImportObjectsStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("Start import process for: {}. Start time: {}", (Object)entityType, (Object)timestampImportObjectsStart);
        Timestamp timestampGetStorablesFilesStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- Get storablesFiles - start. Start time: {}", (Object)timestampGetStorablesFilesStart);
        Map storablesFiles = this.objectLoaderFromDiskService.getListOfObjects(path, this.map.get(entityType));
        Timestamp timestampGetStorablesFilesFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- Get storablesFiles - finish. Finish time: {}, Duration: {}", (Object)timestampGetStorablesFilesFinish, (Object)this.getTimestampDifference(timestampGetStorablesFilesStart, timestampGetStorablesFilesFinish));
        ConcurrentHashMap<Object, Storable> storablesForImport = new ConcurrentHashMap<Object, Storable>();
        Timestamp timestampLoadFilesStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- loadFileAsObjectWithReplacementMap - start. Start time: {}", (Object)timestampLoadFilesStart);
        for (Map.Entry entry : storablesFiles.entrySet()) {
            Path filePath = (Path)entry.getValue();
            Storable storable = (Storable)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMapThrowException(filePath, this.map.get(entityType), exportImportData.getReplacementMap(), false);
            storablesForImport.put(storable.getID(), storable);
        }
        Timestamp timestampLoadFilesFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- loadFileAsObjectWithReplacementMap - finish. Finish time: {}, Duration: {}", (Object)timestampLoadFilesFinish, (Object)this.getTimestampDifference(timestampLoadFilesStart, timestampLoadFilesFinish));
        Timestamp timestampInvalidateStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- invalidateBeforeImport - start. Start time: {}", (Object)timestampInvalidateStart);
        this.invalidateBeforeImport(entityType, storablesForImport, project, replacementMap);
        Timestamp timestampInvalidateFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- invalidateBeforeImport - finish. Finish time: {}, Duration: {}", (Object)timestampInvalidateFinish, (Object)this.getTimestampDifference(timestampInvalidateStart, timestampInvalidateFinish));
        boolean internalProjectAnother = this.isInternalProjectAnother((BigInteger)project.getID(), storablesForImport.values());
        boolean catalogueProjectAnother = this.isCatalogueProjectAnotherOrNew(exportImportData);
        if (internalProjectAnother || catalogueProjectAnother) {
            Timestamp timestampPerformActionsForImportIntoAnotherProjectStart = new Timestamp(java.lang.System.currentTimeMillis());
            log.info("-- performActionsForImportIntoAnotherProject - start. Start time: {}", (Object)timestampPerformActionsForImportIntoAnotherProjectStart);
            this.performActionsForImportIntoAnotherProject(storablesForImport.values(), replacementMap, (BigInteger)project.getID(), project.getUuid(), internalProjectAnother, catalogueProjectAnother);
            Timestamp timestampPerformActionsForImportIntoAnotherProjectFinish = new Timestamp(java.lang.System.currentTimeMillis());
            log.info("-- performActionsForImportIntoAnotherProject - finish. Finish time: {}, Duration: {}", (Object)timestampPerformActionsForImportIntoAnotherProjectFinish, (Object)this.getTimestampDifference(timestampPerformActionsForImportIntoAnotherProjectStart, timestampPerformActionsForImportIntoAnotherProjectFinish));
        }
        Timestamp timestampconfigAndSaveStorablesStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- configAndSaveStorables - start. Start time: {}", (Object)timestampconfigAndSaveStorablesStart);
        this.configAndSaveStorables(storablesForImport.values(), project);
        Timestamp timestampconfigAndSaveStorablesFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("-- configAndSaveStorables - finish. Finish time: {}, Duration: {}", (Object)timestampconfigAndSaveStorablesFinish, (Object)this.getTimestampDifference(timestampconfigAndSaveStorablesStart, timestampconfigAndSaveStorablesFinish));
        for (Storable storable : storablesForImport.values()) {
            if (!(storable instanceof System)) continue;
            systemIds.add((BigInteger)storable.getID());
        }
        Timestamp timestampImportObjectsFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("Finish import process for: {}. Finish time: {}, Duration: {}", new Object[]{entityType, timestampImportObjectsFinish, this.getTimestampDifference(timestampImportObjectsStart, timestampImportObjectsFinish)});
    }

    private Storable getRoot(StubProject project, String entityType) throws ClassNotFoundException {
        Storable root = null;
        Pair<BigInteger, String> rootWithClass = this.defineParametersForParentInCaseOfTreeObjects(project, entityType);
        if (rootWithClass.getKey() != null && rootWithClass.getValue() != null) {
            root = CoreObjectManager.getInstance().getManager(Class.forName((String)rootWithClass.getValue()).asSubclass(Storable.class)).getById(rootWithClass.getKey());
        }
        return root;
    }

    private void invalidateBeforeImport(String entityType, ConcurrentHashMap<Object, Storable> storablesForImport, StubProject project, Map<BigInteger, BigInteger> replacementMap) throws ClassNotFoundException {
        Function3<ConcurrentHashMap<Object, ? extends Storable>, StubProject, Map<BigInteger, BigInteger>, Void> beforeImportConsumer = this.beforeImportFunctionMap.get(entityType);
        if (Objects.nonNull(beforeImportConsumer)) {
            beforeImportConsumer.apply(storablesForImport, (Object)project, replacementMap);
        }
        Storable root = this.getRoot(project, entityType);
        ObjectManager folderManager = CoreObjectManager.getInstance().getManager(Folder.class);
        storablesForImport.values().stream().filter(storable -> !(storable instanceof ProjectSettings)).forEach(storable -> {
            if (storable instanceof IntegrationConfig) {
                storable.setParent((Storable)project);
            } else if (Objects.isNull(storable.getParent())) {
                storable.setParent(root);
            } else {
                BigInteger serializedParentId = (BigInteger)storable.getParent().getID();
                BigInteger replacedParentId = (BigInteger)replacementMap.get(serializedParentId);
                storable.setParent(replacedParentId != null ? folderManager.getById((Object)replacedParentId) : folderManager.getById((Object)serializedParentId));
            }
        });
    }

    private Void invalidateSystemReferences(ConcurrentHashMap<Object, System> systems) {
        ConcurrentHashMap situations = systems.values().parallelStream().flatMap(system -> system.getOperations().stream()).flatMap(operation -> operation.getSituations().stream()).collect(Collectors.toMap(AbstractStorable::getID, Function.identity(), (existing, replacement) -> existing, ConcurrentHashMap::new));
        List integrationSteps = situations.values().parallelStream().flatMap(situation -> situation.getSteps().stream()).filter(step -> step instanceof IntegrationStep && Objects.nonNull(((IntegrationStep)step).getReceiver())).map(IntegrationStep.class::cast).collect(Collectors.toList());
        integrationSteps.parallelStream().forEach(step -> step.setReceiver((System)systems.get(step.getReceiver().getID())));
        ConcurrentHashMap situationEventTriggersRefersToSituation = situations.values().stream().flatMap(situation -> situation.getSituationEventTriggers().stream()).filter(situationEventTrigger -> Objects.nonNull(situationEventTrigger.getSituation())).collect(Collectors.toMap(trigger -> trigger, trigger -> trigger.getSituation().getID(), (existing, replacement) -> existing, ConcurrentHashMap::new));
        situationEventTriggersRefersToSituation.entrySet().stream().forEach(entry -> ((SituationEventTrigger)entry.getKey()).setSituation((Situation)situations.get(entry.getValue())));
        return null;
    }

    private Void invalidateServerReferences(ConcurrentHashMap<Object, ServerHB> servers, Map<BigInteger, BigInteger> replacementMap) {
        ObjectManager systemObjectManager = CoreObjectManager.getInstance().getManager(System.class);
        ObjectManager transportObjectManager = CoreObjectManager.getInstance().getManager(TransportConfiguration.class);
        servers.values().forEach(server -> {
            server.getOutbounds().forEach(outbound -> {
                BigInteger deserializedSystemId = (BigInteger)outbound.getSystem().getID();
                BigInteger replacedSystemId = (BigInteger)replacementMap.get(deserializedSystemId);
                outbound.setSystem(replacedSystemId != null ? (System)systemObjectManager.getById((Object)replacedSystemId) : (System)systemObjectManager.getById((Object)deserializedSystemId));
            });
            server.getInbounds().forEach(inbound -> {
                BigInteger deserializedReferencedConfigurationId = (BigInteger)inbound.getReferencedConfiguration().getID();
                BigInteger replacedReferencedConfigurationId = (BigInteger)replacementMap.get(deserializedReferencedConfigurationId);
                inbound.setReferencedConfiguration(replacedReferencedConfigurationId != null ? (TransportConfiguration)transportObjectManager.getById((Object)replacedReferencedConfigurationId) : (TransportConfiguration)transportObjectManager.getById((Object)deserializedReferencedConfigurationId));
            });
        });
        return null;
    }

    private Void invalidateEnvironmentReferences(ConcurrentHashMap<Object, Environment> environments, Map<BigInteger, BigInteger> replacementMap) {
        environments.values().forEach(environment -> {
            environment.fillOutbound(this.getEnvironmentsSystemServerPairs(environment.getOutbound(), replacementMap));
            environment.fillInbound(this.getEnvironmentsSystemServerPairs(environment.getInbound(), replacementMap));
        });
        return null;
    }

    private Map<System, Server> getEnvironmentsSystemServerPairs(Map<System, Server> pairs, Map<BigInteger, BigInteger> replacementMap) {
        HashMap pairsWithReplacedIds = Maps.newHashMap();
        ObjectManager systemManager = CoreObjectManager.getInstance().getManager(System.class);
        ObjectManager serverManager = CoreObjectManager.getInstance().getManager(Server.class);
        pairs.forEach((key, value) -> {
            BigInteger replacedSystemId = (BigInteger)replacementMap.get((BigInteger)key.getID());
            BigInteger replacedServerId = (BigInteger)replacementMap.get((BigInteger)value.getID());
            pairsWithReplacedIds.put(replacedSystemId != null ? (System)systemManager.getById((Object)replacedSystemId) : (System)systemManager.getById(key.getID()), replacedServerId != null ? (Server)serverManager.getById((Object)replacedServerId) : (Server)serverManager.getById(value.getID()));
        });
        return pairsWithReplacedIds;
    }

    private Void invalidateCallchainReferences(ConcurrentHashMap<Object, CallChain> callChains, Map<BigInteger, BigInteger> replacementMap) {
        ConcurrentHashMap embeddedSteps = callChains.values().parallelStream().flatMap(entry -> entry.getSteps().stream()).filter(step -> step instanceof EmbeddedStep).collect(Collectors.toMap(Identified::getID, Function.identity(), (existing, replacement) -> existing, ConcurrentHashMap::new));
        embeddedSteps.forEach((key, value) -> {
            EmbeddedStep embeddedStep = (EmbeddedStep)value;
            if (embeddedStep.getChain() != null) {
                embeddedStep.setChain((CallChain)callChains.get(embeddedStep.getChain().getID()));
            }
        });
        ObjectManager situationManager = CoreObjectManager.getInstance().getManager(Situation.class);
        callChains.values().stream().flatMap(entry -> entry.getSteps().stream()).filter(step -> step instanceof SituationStep).map(SituationStep.class::cast).collect(Collectors.toList()).stream().forEach(step -> {
            step.setSituation(this.getSituationForSituationStep(step.getSituation(), replacementMap, (ObjectManager<Situation>)situationManager));
            step.setEndSituations(this.getSituationsForSituationStep(step.getEndSituations(), replacementMap, (ObjectManager<Situation>)situationManager));
            step.setExceptionalSituations(this.getSituationsForSituationStep(step.getExceptionalSituations(), replacementMap, (ObjectManager<Situation>)situationManager));
        });
        return null;
    }

    private Set<Situation> getSituationsForSituationStep(Set<Situation> deserializedSituations, Map<BigInteger, BigInteger> replacementMap, ObjectManager<Situation> situationManager) {
        HashSet situations = Sets.newHashSet();
        deserializedSituations.stream().forEach(situation -> situations.add(this.getSituationForSituationStep((Situation)situation, replacementMap, situationManager)));
        return situations;
    }

    private Situation getSituationForSituationStep(Situation deserializedSituation, Map<BigInteger, BigInteger> replacementMap, ObjectManager<Situation> situationManager) {
        if (deserializedSituation != null) {
            BigInteger deserializedSituationId = replacementMap.get((BigInteger)deserializedSituation.getID());
            return deserializedSituationId != null ? (Situation)situationManager.getById((Object)deserializedSituationId) : (Situation)situationManager.getById(deserializedSituation.getID());
        }
        return null;
    }

    private List<Pair<Path, String>> prepareListOfFoldersForImport(Path workDir) {
        LinkedList<Pair<Path, String>> filesForImport = new LinkedList<Pair<Path, String>>();
        Arrays.stream((Object[])Objects.requireNonNull(workDir.toFile().listFiles())).filter(File::isDirectory).sorted().forEach(folder -> Arrays.stream(folder.listFiles()).filter(File::isDirectory).forEach(nestedFolder -> filesForImport.add(new Pair((Object)folder.toPath(), (Object)nestedFolder.getName()))));
        return filesForImport;
    }

    public Pair<BigInteger, String> defineParametersForParentInCaseOfTreeObjects(StubProject project, String entityType) {
        Pair result;
        switch (entityType) {
            case "System": 
            case "SystemFolder": {
                result = new Pair((Object)((BigInteger)project.getSystems().getID()), (Object)SystemFolder.class.getName());
                break;
            }
            case "CallChain": 
            case "ChainFolder": {
                result = new Pair((Object)((BigInteger)project.getCallchains().getID()), (Object)ChainFolder.class.getName());
                break;
            }
            case "Environment": 
            case "EnvFolder": {
                result = new Pair((Object)((BigInteger)project.getEnvironments().getID()), (Object)EnvFolder.class.getName());
                break;
            }
            case "ServerHB": 
            case "ServerFolder": {
                result = new Pair((Object)((BigInteger)project.getServers().getID()), (Object)ServerFolder.class.getName());
                break;
            }
            default: {
                result = new Pair(null, null);
            }
        }
        return result;
    }

    public void performActionsForImportIntoAnotherProject(Collection<Storable> storables, Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        storables.stream().filter(storable -> !(storable instanceof ProjectSettings)).forEach(storable -> storable.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    public void configAndSaveStorables(Collection<Storable> storables, StubProject project) {
        storables.forEach(storable -> this.configAndSaveStorable(null, (Storable)storable, project));
    }

    public void configAndSaveStorable(Storable newParent, Storable storable, StubProject project) {
        if (storable == null) {
            log.debug("Storable is null");
            return;
        }
        Timestamp timestampConfigAndSaveStorableStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info("Start configAndSaveStorable for entity (ID: {}, Type: {}, Name: {}). Start time: {}", new Object[]{storable.getID(), storable.getClass().getSimpleName(), storable.getName(), timestampConfigAndSaveStorableStart});
        if (storable instanceof ProjectSettings) {
            log.info("Importing project settings...");
            Map projectSettings = ((ProjectSettings)storable).getConfiguration();
            project.setStorableProp(projectSettings);
            project.store();
            this.projectSettingsService.fillCache(project, projectSettings);
            log.info("Project settings are imported successfully.");
            return;
        }
        this.checkAndRemoveOldIntegrationConfig(storable, project);
        if (storable instanceof System) {
            this.processTemplatesTransportConfigurations((System)storable);
        }
        log.info("Storable name: {} id: {} importing...", (Object)storable.getName(), storable.getID());
        Timestamp timestampReplicateStart = new Timestamp(java.lang.System.currentTimeMillis());
        log.info(" Start replication for entity (ID: {}, Type: {}, Name: {}). Start time: {}", new Object[]{storable.getID(), storable.getClass().getSimpleName(), storable.getName(), timestampReplicateStart});
        this.itfReplicationService.replicateStorableWithHistory(storable);
        Timestamp timestampReplicateFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info(" Finish replication for entity (ID: {}, Type: {}, Name: {}). Finish time: {}, Duration: {}", new Object[]{storable.getID(), storable.getClass().getSimpleName(), storable.getName(), timestampReplicateFinish, this.getTimestampDifference(timestampReplicateStart, timestampReplicateFinish)});
        Timestamp timestampConfigAndSaveStorableFinish = new Timestamp(java.lang.System.currentTimeMillis());
        log.info(" Finish configAndSaveStorable for entity (ID: {}, Type: {}, Name: {}). Finish time: {}, Duration: {}", new Object[]{storable.getID(), storable.getClass().getSimpleName(), storable.getName(), timestampConfigAndSaveStorableFinish, this.getTimestampDifference(timestampConfigAndSaveStorableStart, timestampConfigAndSaveStorableFinish)});
        log.info("Storable name: {} id: {} is imported.", (Object)storable.getName(), storable.getID());
    }

    private void processTemplatesTransportConfigurations(System system) {
        log.info("System: {} - Templates Transport Configurations processing is started...", (Object)system);
        system.getSystemTemplates().stream().forEach(systemTemplate -> this.processTemplateTransportConfiguration((Template<? extends TemplateProvider>)systemTemplate, true));
        log.info("System: {} - System templates transport configurations are processed", (Object)system);
        system.getOperations().stream().forEach(operation -> operation.getOperationTemplates().stream().forEach(operationTemplate -> this.processTemplateTransportConfiguration((Template<? extends TemplateProvider>)operationTemplate, false)));
        log.info("System: {} - Operation templates transport configurations are processed", (Object)system);
    }

    private void processTemplateTransportConfiguration(Template<? extends TemplateProvider> template, boolean isSystemTemplate) {
        Collection transportProperties = template.getTransportProperties();
        if (transportProperties.isEmpty()) {
            return;
        }
        CoreObjectManagerService coreObjectManagerService = CoreObjectManager.getInstance();
        if (isSystemTemplate) {
            ObjectManager manager = coreObjectManagerService.getManager(SystemTemplate.class);
            this.getAndCheckTemplateTransportConfiguration((Template<? extends TemplateProvider>)((Template)manager.getById(template.getID())), transportProperties);
        } else {
            ObjectManager manager = coreObjectManagerService.getManager(OperationTemplate.class);
            this.getAndCheckTemplateTransportConfiguration((Template<? extends TemplateProvider>)((Template)manager.getById(template.getID())), transportProperties);
        }
    }

    private void getAndCheckTemplateTransportConfiguration(Template<? extends TemplateProvider> templateFromDB, Collection<OutboundTemplateTransportConfiguration> transportProperties) {
        if (Objects.nonNull(templateFromDB) && !templateFromDB.getTransportProperties().isEmpty()) {
            for (OutboundTemplateTransportConfiguration transportConfiguration : transportProperties) {
                OutboundTemplateTransportConfiguration transportConfigurationFromDB = templateFromDB.getTransportProperties(transportConfiguration.getTypeName());
                if (!Objects.nonNull(transportConfigurationFromDB)) continue;
                transportConfiguration.setID(transportConfigurationFromDB.getID());
            }
        }
    }

    private void checkAndRemoveOldIntegrationConfig(Storable storable, StubProject project) {
        if (storable instanceof IntegrationConfig) {
            IntegrationConfig currentIntegrationConfig = (IntegrationConfig)storable;
            log.info("Start checking if integration config '{}' exists...", (Object)currentIntegrationConfig.getTypeName());
            Set integrationConfs = project.getIntegrationConfs();
            for (IntegrationConfig integrationConfig : integrationConfs) {
                if (!currentIntegrationConfig.getTypeName().equals(integrationConfig.getTypeName()) || currentIntegrationConfig.getID().equals(integrationConfig.getID())) continue;
                integrationConfs.remove(integrationConfig);
                integrationConfig.remove();
                project.store();
                log.info("Old integration config '{}' is removed.", (Object)currentIntegrationConfig.getTypeName());
                break;
            }
            log.info("Finish checking if integration config '{}' exists.", (Object)currentIntegrationConfig.getTypeName());
        }
    }

    private BigInteger getProjectIdByUuid(UUID projectUuid) {
        SearchManager specialManager = (SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class);
        BigInteger projectId = specialManager.getEntityInternalIdByUuid(projectUuid);
        if (projectId == null) {
            log.info("Project with uuid = {} doesn't exist. Wait the project creation...", (Object)projectUuid);
            for (int attempt = 0; attempt < this.EI_WAITING_PROJECT_CREATION_ATTEMPT_COUNT; ++attempt) {
                try {
                    Thread.sleep(this.EI_WAITING_PROJECT_CREATION_TIMEOUT);
                    projectId = specialManager.getEntityInternalIdByUuid(projectUuid);
                    if (projectId != null) {
                        log.info("Project with id = {}, uuid = {} is created, attempt# {}. Continue import...", new Object[]{projectId, projectUuid, attempt});
                        break;
                    }
                    log.info("Project with uuid = {} isn't created yet, attempt# {}. Continue waiting...", (Object)projectUuid, (Object)attempt);
                    continue;
                }
                catch (InterruptedException exc) {
                    throw new RuntimeException(String.format("Failed while waiting the creation of the project (uuid=%s) during the import!", projectUuid), exc);
                }
            }
            if (projectId == null) {
                throw new IllegalArgumentException(String.format("Project with uuid=%s wasn't created, import process can't be started!", projectUuid));
            }
        }
        return projectId;
    }

    private boolean isInternalProjectAnother(BigInteger targetProjectId, Collection<Storable> storables) {
        Storable storableForImport = storables.stream().filter(storable -> !(storable instanceof ProjectSettings)).findFirst().orElse(null);
        if (storableForImport != null) {
            return !targetProjectId.equals(storableForImport.getProjectId());
        }
        return true;
    }

    private boolean isCatalogueProjectAnotherOrNew(ExportImportData exportImportData) {
        return exportImportData.isInterProjectImport() || exportImportData.isImportFirstTime();
    }

    @ConstructorProperties(value={"objectLoaderFromDiskService", "executorToMessageBrokerSender", "projectSettingsService"})
    public ItfImportExecutor(ObjectLoaderFromDiskService objectLoaderFromDiskService, ExecutorToMessageBrokerSender executorToMessageBrokerSender, ProjectSettingsService projectSettingsService) {
        this.map.put(ProjectSettings.class.getSimpleName(), ProjectSettings.class);
        this.map.put(IntegrationConfig.class.getSimpleName(), IntegrationConfig.class);
        this.map.put(SystemFolder.class.getSimpleName(), SystemFolder.class);
        this.map.put(ChainFolder.class.getSimpleName(), ChainFolder.class);
        this.map.put(EnvFolder.class.getSimpleName(), EnvFolder.class);
        this.map.put(System.class.getSimpleName(), System.class);
        this.map.put(CallChain.class.getSimpleName(), CallChain.class);
        this.map.put(Environment.class.getSimpleName(), Environment.class);
        this.map.put(ServerHB.class.getSimpleName(), ServerHB.class);
        this.beforeImportFunctionMap.put(System.class.getSimpleName(), (Function3<ConcurrentHashMap<Object, ? extends Storable>, StubProject, Map<BigInteger, BigInteger>, Void>)(Function3 & Serializable)(input, project, replacementMap) -> this.invalidateSystemReferences((ConcurrentHashMap<Object, System>)input));
        this.beforeImportFunctionMap.put(CallChain.class.getSimpleName(), (Function3<ConcurrentHashMap<Object, ? extends Storable>, StubProject, Map<BigInteger, BigInteger>, Void>)(Function3 & Serializable)(input, project, replacementMap) -> this.invalidateCallchainReferences((ConcurrentHashMap<Object, CallChain>)input, (Map<BigInteger, BigInteger>)replacementMap));
        this.beforeImportFunctionMap.put(ServerHB.class.getSimpleName(), (Function3<ConcurrentHashMap<Object, ? extends Storable>, StubProject, Map<BigInteger, BigInteger>, Void>)(Function3 & Serializable)(input, project, replacementMap) -> this.invalidateServerReferences((ConcurrentHashMap<Object, ServerHB>)input, (Map<BigInteger, BigInteger>)replacementMap));
        this.beforeImportFunctionMap.put(Environment.class.getSimpleName(), (Function3<ConcurrentHashMap<Object, ? extends Storable>, StubProject, Map<BigInteger, BigInteger>, Void>)(Function3 & Serializable)(input, project, replacementMap) -> this.invalidateEnvironmentReferences((ConcurrentHashMap<Object, Environment>)input, (Map<BigInteger, BigInteger>)replacementMap));
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.projectSettingsService = projectSettingsService;
    }
}

