/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.export;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TemplateExtractor {
    private static final Logger log = LoggerFactory.getLogger(TemplateExtractor.class);
    public static final String LOAD_PART_PATTERN = "#load_part\\S\"+(.[^\"]*)\"";

    public Set<String> findLoadPartTemplates(String content) {
        Pattern pattern = Pattern.compile(LOAD_PART_PATTERN);
        Matcher matcher = pattern.matcher(content);
        HashSet<String> result = new HashSet<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    public Template<? extends TemplateProvider> getTemplateObject(String templateIdentifier, BigInteger projectId) {
        Collection templates = TemplateHelper.getByNameAndProjectId((String)templateIdentifier, (BigInteger)projectId);
        if (templates.size() != 0) {
            return (Template)templates.iterator().next();
        }
        log.warn("Template not found by name '{}' in project id='{}'. Trying to search by ID.", (Object)templateIdentifier, (Object)projectId);
        try {
            Template template = TemplateHelper.getById((Object)templateIdentifier);
            if (template == null) {
                log.warn("Template is not found by id '{}'", (Object)templateIdentifier);
                return null;
            }
            if (!projectId.equals(template.getProjectId())) {
                log.warn("Template is not found by id '{}' in project id='{}'", (Object)templateIdentifier, (Object)projectId);
                return null;
            }
            return template;
        }
        catch (IllegalArgumentException e) {
            log.warn("Can't find template by ID because identifier is not numeric value: {}.", (Object)templateIdentifier);
            return null;
        }
    }
}

