/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.websocket;

import java.math.BigInteger;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.report.RunSubscriberInterface;
import org.qubership.automation.itf.core.util.manager.MonitorManager;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.ui.controls.service.websocket.ClientDataMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;

@Controller
public class RunSubscriber
implements RunSubscriberInterface {
    public static final String CLIENT_IP = "clientIP";
    private Logger LOGGER = LoggerFactory.getLogger(RunSubscriber.class);
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;

    @MessageMapping(value={"/notify"})
    public void receive(@Payload ClientDataMessage message) {
        try {
            BigInteger tcContextId = new BigInteger(message.getContextId());
            TcContext tcContext = CacheServices.getTcContextCacheService().getById((Object)tcContextId);
            tcContext.put((Object)CLIENT_IP, (Object)message.getClientIP());
            tcContext.store();
            this.notifyObject(message.getContextId());
        }
        catch (Exception e) {
            this.LOGGER.error("Error occurred while receive message", (Throwable)e);
            this.notifyObject(message.getContextId());
        }
    }

    public void send(@Payload String message, @Payload String clientIP) {
        message = "{\"message\":\"" + message + "\", \"ip\":\"" + clientIP + "\"}";
        this.simpMessagingTemplate.convertAndSend((Object)"/topic/notify", (Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObject(String id) {
        Object object;
        Object object2 = object = MonitorManager.getInstance().get(id);
        synchronized (object2) {
            object.notify();
        }
    }
}

