/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.tree;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.exceptions.configuration.ConfigurationException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.FolderManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.EnvironmentObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.tree.AbstractTreeBuilder;
import org.qubership.automation.itf.ui.controls.tree.TreeController;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.tree.UITreeData;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional(readOnly=true)
public class EnvironmentTreeController
extends AbstractTreeBuilder<Environment, Folder>
implements TreeController {
    @Override
    UITreeElement fillFolder(Storable nodeProvider) {
        Folder folder = (Folder)nodeProvider;
        UITreeElement currentFolder = new UITreeElement();
        this.configureObject(currentFolder, (Storable)folder);
        this.addSubElements(currentFolder, folder.getSubFolders());
        this.addSubElements(currentFolder, folder.getObjects());
        return currentFolder;
    }

    @Override
    Class<Folder> getParentClass() {
        return Folder.class;
    }

    @Override
    Class<Environment> getChildClass() {
        return Environment.class;
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/environment/folder"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Environment Tree under Folder id {{#id}} in the project {{#projectUuid}}")
    public UITreeData getTree(@RequestParam(required=false) String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return this.getTree(id);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/environment/tree/node"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Environment Tree for current id {{#id}} or parent id {{#parentId}} in the project {{#projectUuid}}")
    public UITreeData getTreeFromNode(@RequestParam(required=false) String id, @RequestParam(required=false) String parentId, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return this.getTree(parentId);
        }
        UITreeData uiTreeData = this.buildTree(this.getEnvironmentOrFolder(id));
        this.addInboundStateToTree(uiTreeData.getTreeData());
        return uiTreeData;
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/environment/tree/node/name"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Environment Tree for node by name {{#value}} and parent id {{#parentId}} in the project {{#projectId}}/{{#projectUuid}}")
    public UITreeData getTreeFromNodeByName(@RequestParam(required=false) String value, @RequestParam(required=false) String[] filters, @RequestParam(required=false) String parentId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this.getTree(parentId);
        }
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)5);
        String[] stringArray = filters;
        int n = stringArray.length;
        block7: for (int i = 0; i < n; ++i) {
            String filter;
            switch (filter = stringArray[i]) {
                case "NAME": {
                    nodes.addAll(this.getEnvAndFolderByName(value, projectId));
                    continue block7;
                }
            }
        }
        UITreeData uiTreeData = this.buildTreeByFilter(nodes);
        this.addInboundStateToTree(uiTreeData.getTreeData());
        return uiTreeData;
    }

    private UITreeData getTree(String id) {
        Folder<Environment> folder = this.getFolderByIdOrRootIfNull(id);
        UITreeData treeData = new UITreeData();
        UITreeElement currentFolder = this.fillFolder((Storable)folder);
        this.addInboundStateToTree(currentFolder.getChildren());
        treeData.setTreeData(currentFolder.getChildren());
        return treeData;
    }

    private Collection<Storable> getEnvAndFolderByName(String name, BigInteger projectId) {
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)5);
        nodes.addAll(((EnvironmentObjectManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentObjectManager.class)).getByPieceOfNameAndProjectId(name, projectId));
        nodes.addAll(((FolderManager)CoreObjectManager.getInstance().getSpecialManager(Folder.class, FolderManager.class)).findFolderByPieceOfName("EnvFolder", name, projectId));
        return nodes;
    }

    private Storable getEnvironmentOrFolder(String id) {
        Storable node = CoreObjectManager.getInstance().getManager(Environment.class).getById((Object)id);
        if (node == null) {
            node = CoreObjectManager.getInstance().getManager(Folder.class).getById((Object)id);
        }
        if (node == null) {
            throw new ObjectNotFoundException("Environment or Environment folder", id, null, null);
        }
        return node;
    }

    @Nonnull
    private Folder<Environment> getFolderByIdOrRootIfNull(@Nullable String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ConfigurationException("folder id cannot be null");
        }
        return (Folder)CoreObjectManager.getInstance().getManager(Folder.class).getById((Object)id);
    }

    private UITreeElement addInboundStateToElement(UITreeElement element, ObjectManager<Environment> environmentManager) {
        Environment currentEnvironment = (Environment)environmentManager.getById((Object)element.getId());
        if (currentEnvironment.getEnvironmentState() != null) {
            element.setInboundState(currentEnvironment.getEnvironmentState().toString());
        }
        return element;
    }

    private void addInboundStateToTree(Collection<UITreeElement> treeElements) {
        ObjectManager environmentManager = CoreObjectManager.getInstance().getManager(Environment.class);
        for (UITreeElement element : treeElements) {
            if (!element.getIsFolder()) {
                this.addInboundStateToElement(element, (ObjectManager<Environment>)environmentManager);
                continue;
            }
            Collection<UITreeElement> children = element.getChildren();
            for (UITreeElement child : children) {
                if (child.getIsFolder()) continue;
                this.addInboundStateToElement(child, (ObjectManager<Environment>)environmentManager);
            }
        }
    }
}

