/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects;

import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(description="NOTE. Property parent is hidden to prevent circular references.")
public class UIObject
extends UIIdentifiedObject {
    private static final Logger log = LoggerFactory.getLogger(UIObject.class);
    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    private UIObject parent;
    private String description;
    private ImmutableList<String> labels;
    private String historyKey;
    private int version = -1;

    public UIObject() {
    }

    public UIObject(Storable storable) {
        this.defineObjectParam(storable);
    }

    public UIObject(Storable storable, boolean isFullWithParent) {
        this.defineObjectParam(storable, isFullWithParent);
    }

    public UIObject(UIObject uiObject) {
        this.setId(uiObject.getId());
        this.setName(uiObject.getName());
        if (uiObject.getParent() != null) {
            this.setParent(new UIObject(uiObject.getParent()));
        }
        this.setClassName(uiObject.getClassName());
        this.setVersion(uiObject.getVersion());
    }

    public UIObject getParent() {
        return this.parent;
    }

    public void setParent(UIObject parent) {
        this.parent = parent;
    }

    public void defineObjectParam(Storable storable) {
        this.defineObjectParam(storable, true);
    }

    public void defineObjectParam(Storable storable, boolean isFullWithParent) {
        this.setId(storable.getID().toString());
        this.setName(storable.getName());
        if (storable.getParent() != null && (isFullWithParent || !(storable.getParent() instanceof Folder))) {
            this.setParent(new UIObject(storable.getParent(), isFullWithParent));
        }
        this.setClassName(storable.getClass().getName());
        this.setDescription(storable.getDescription());
        if (isFullWithParent && storable instanceof LabeledStorable) {
            LabeledStorable labeledStorable = (LabeledStorable)storable;
            this.setLabels(labeledStorable.getLabels());
        } else {
            this.setLabels(null);
        }
        this.setVersion(NumberUtils.toInt((String)String.valueOf(storable.getVersion()), (int)-1));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImmutableList<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = UIHelper.isNotNullCopyOfImmutableList(labels);
    }

    public void updateObject(Storable storable) {
        UIHelper.updateObject(this, storable);
    }

    public String toString() {
        return String.format("Object '%s' with name '%s' and id '%s'", this.getClass().getSimpleName(), this.getName(), this.getId());
    }

    @Override
    public void loadChildrenByClass(Class childClass, List<Storable> children) {
    }

    public String getHistoryKey() {
        return this.historyKey;
    }

    public void setHistoryKey(String historyKey) {
        this.historyKey = historyKey;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean calcIsVersionActual(Storable storable) {
        if (this.getVersion() == -1) {
            log.warn("Storable version equals to '-1'. It means that UI doesn't have actual version number of object. Please check integration between UI and backend for object {}", storable.getClass());
        }
        return storable.getVersion().equals(this.getVersion()) || this.getVersion() == -1;
    }
}

