/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.ui.messages.objects.UIDefinitionKey;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIParsingRule;
import org.qubership.automation.itf.ui.messages.objects.UISituation;
import org.qubership.automation.itf.ui.messages.objects.template.UITemplate;
import org.qubership.automation.itf.ui.messages.objects.transport.UITransport;
import org.qubership.automation.itf.ui.messages.objects.wrap.UIWrapper;
import org.qubership.automation.itf.ui.util.UIHelper;

public class UIOperation
extends UIObject {
    private UIWrapper<UITransport> transport;
    private UIWrapper<UIDefinitionKey> definitionKey;
    private UIWrapper<List<UIParsingRule>> parsingRules;
    private UIWrapper<List<UITemplate>> templates;
    private UIWrapper<List<UISituation>> situations;
    private String mep;
    private UIWrapper<String> incoming;
    private UIWrapper<String> outgoing;

    public UIOperation() {
    }

    public UIOperation(Storable operation) {
        this((Operation)operation);
    }

    public UIOperation(Operation operation) {
        super((Storable)operation);
        TransportConfiguration transport = operation.getTransport();
        if (transport != null) {
            this.transport = new UIWrapper<UITransport>(new UITransport(transport));
        }
        this.wrapDefinitionKey(operation.getOperationDefinitionKey());
        this.wrapMep(operation.getMep());
    }

    public void fillForQuickDisplay(@NotNull Operation operation) {
        this.setId(operation.getID().toString());
        this.setName(operation.getName());
        this.setVersion(NumberUtils.toInt((String)String.valueOf(operation.getVersion()), (int)-1));
        this.wrapDefinitionKey(operation.getOperationDefinitionKey());
        this.wrapMep(operation.getMep());
        TransportConfiguration transport = operation.getTransport();
        if (transport != null) {
            UITransport uiTransport = new UITransport();
            uiTransport.fillForQuickDisplay(transport);
            this.setTransport(new UIWrapper<UITransport>(uiTransport));
        }
    }

    @Override
    public void loadChildrenByClass(Class childClass, List<Storable> children) {
        if (childClass.isAssignableFrom(OperationParsingRule.class)) {
            ArrayList uiParsingRules = Lists.newArrayList();
            for (Storable child : children) {
                uiParsingRules.add(new UIParsingRule((ParsingRule<? extends ParsingRuleProvider>)((ParsingRule)child)));
            }
            this.setParsingRules(new UIWrapper<List<UIParsingRule>>(uiParsingRules));
        }
        if (childClass.isAssignableFrom(Situation.class)) {
            ArrayList uiSituations = Lists.newArrayList();
            for (Storable child : children) {
                uiSituations.add(new UISituation((Situation)child));
            }
            this.setSituations(new UIWrapper<List<UISituation>>(uiSituations));
        }
        if (childClass.isAssignableFrom(OperationTemplate.class)) {
            ArrayList uiTemplates = Lists.newArrayList();
            for (Storable child : children) {
                uiTemplates.add(new UITemplate((Template)child));
            }
            this.setTemplates(new UIWrapper<List<UITemplate>>(uiTemplates));
        }
    }

    public UIWrapper<List<UISituation>> getSituations() {
        return this.situations;
    }

    public void setSituations(UIWrapper<List<UISituation>> situations) {
        this.situations = situations;
    }

    private String getContextDefinitionValue(String keyDefinition) {
        return UIHelper.getDefinitionValue(keyDefinition);
    }

    public UIWrapper<UITransport> getTransport() {
        return this.transport;
    }

    public void setTransport(UIWrapper<UITransport> transport) {
        this.transport = transport;
    }

    public UIWrapper<UIDefinitionKey> getDefinitionKey() {
        return this.definitionKey;
    }

    public void setDefinitionKey(UIWrapper<UIDefinitionKey> definitionKey) {
        this.definitionKey = definitionKey;
    }

    public void wrapDefinitionKey(String operationDefinitionKey) {
        if (!StringUtils.isEmpty((CharSequence)operationDefinitionKey)) {
            this.definitionKey = new UIWrapper<UIDefinitionKey>(new UIDefinitionKey(operationDefinitionKey));
        }
    }

    public UIWrapper<List<UIParsingRule>> getParsingRules() {
        return this.parsingRules;
    }

    public void setParsingRules(UIWrapper<List<UIParsingRule>> parsingRules) {
        this.parsingRules = parsingRules;
    }

    public String getMep() {
        return this.mep;
    }

    public void setMep(String mep) {
        this.mep = mep;
    }

    public void wrapMep(Mep mep) {
        if (mep != null) {
            this.mep = mep.toString();
        }
    }

    public UIWrapper<List<UITemplate>> getTemplates() {
        return this.templates;
    }

    public void setTemplates(UIWrapper<List<UITemplate>> templates) {
        this.templates = templates;
    }

    public UIWrapper<String> getIncoming() {
        return this.incoming;
    }

    public void setIncoming(UIWrapper<String> incoming) {
        this.incoming = incoming;
    }

    public UIWrapper<String> getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(UIWrapper<String> outgoing) {
        this.outgoing = outgoing;
    }
}

