/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.util.constants.PropertyConstants;
import org.qubership.automation.itf.core.util.descriptor.InterceptorPropertyDescriptor;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.parents.UINamedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIProperty
extends UINamedObject
implements Comparable<UIProperty> {
    private static final Logger log = LoggerFactory.getLogger(UIProperty.class);
    private String userName;
    private String value;
    private UIObject referenceValue;
    private boolean boolValue;
    private String optional;
    private String description;
    private String typeName;
    private String inputType;
    private String overridden;
    private String inheritedValue;
    private String select;
    private String referenceClass;
    private String[] options;
    private int order;
    private String filePathDirectoryType;
    private String uiCategory;
    private String validatePattern;

    public UIProperty() {
    }

    public UIProperty(PropertyDescriptor descriptor) {
        this.setName(descriptor.getShortName());
        this.setUserName(descriptor.getLongName());
        this.setDescription(descriptor.getDescription());
        this.setOptional(String.valueOf(descriptor.isOptional()));
        this.setSelect(Boolean.toString(descriptor.isSelect()));
        this.setOptions((String[])ArrayUtils.clone((Object[])descriptor.getOptions()));
        this.setTypeName(descriptor.getTypeName());
        this.setOrder(descriptor.getOrder());
        this.setFilePathDirectoryType(descriptor.getFileDirectoryType());
        this.setUiCategory(descriptor.getUiCategory());
        this.setValidatePattern(descriptor.getValidatePattern());
        try {
            Class<?> aClass = Class.forName(descriptor.getTypeName());
            if (Map.class.isAssignableFrom(aClass)) {
                this.inputType = "map";
            } else if (Collection.class.isAssignableFrom(aClass)) {
                this.inputType = "list";
            } else if (Storable.class.isAssignableFrom(aClass)) {
                this.inputType = "reference";
                this.referenceClass = descriptor.getTypeName();
            } else if (descriptor.loadTemplate()) {
                this.inputType = "reference";
                this.referenceClass = Template.class.getName();
            } else {
                this.inputType = File.class.isAssignableFrom(aClass) ? "file" : (Boolean.class.isAssignableFrom(aClass) ? "boolean" : (Integer.class.isAssignableFrom(aClass) ? "number" : "string"));
            }
        }
        catch (ClassNotFoundException e) {
            this.inputType = "string";
        }
    }

    public UIProperty(InterceptorPropertyDescriptor descriptor) {
        this.setName(descriptor.getName());
        this.setUserName(descriptor.getLongname());
        this.setDescription(descriptor.getDescription());
        this.setInputType(descriptor.getInputType());
        this.setOptions(descriptor.getOptions());
        this.setValue(descriptor.getValue());
        this.setOptional(String.valueOf(descriptor.isOptional()));
    }

    public UIProperty(PropertyDescriptor descriptor, String value) {
        this(descriptor);
        if ("boolean".equals(this.inputType)) {
            this.setBoolValue(Boolean.parseBoolean(value));
        } else {
            String propertyValue;
            if (value != null && StringUtils.isNotEmpty((CharSequence)descriptor.getFileDirectoryType())) {
                Matcher matcher = PropertyConstants.FILE_DIRECTORY_PATTERN.matcher(value);
                if (matcher.find()) {
                    propertyValue = matcher.group(3);
                } else {
                    log.info(String.format("Error while getting the value for file attribute %s from %s. Original value will be set.", descriptor.getLongName(), value));
                    propertyValue = value;
                }
            } else {
                propertyValue = value;
            }
            this.setValue(propertyValue);
            this.setInheritedValue(propertyValue);
        }
    }

    public UIProperty(PropertyDescriptor descriptor, UIObject value) {
        this(descriptor);
        this.setReferenceValue(value);
        this.setReferenceClass(value.getClassName());
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getValue() {
        if ("boolean".equals(this.inputType)) {
            return Boolean.toString(this.boolValue);
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOptional() {
        return this.optional;
    }

    public void setOptional(String optional) {
        this.optional = optional;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getOverridden() {
        return this.overridden;
    }

    public void setOverridden(String overridden) {
        this.overridden = overridden;
    }

    public String getInheritedValue() {
        return this.inheritedValue;
    }

    public void setInheritedValue(String inheritedValue) {
        this.inheritedValue = inheritedValue;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public UIObject getReferenceValue() {
        return this.referenceValue;
    }

    public void setReferenceValue(UIObject referenceValue) {
        this.referenceValue = referenceValue;
    }

    public String getReferenceClass() {
        return this.referenceClass;
    }

    public void setReferenceClass(String referenceClass) {
        this.referenceClass = referenceClass;
    }

    public boolean isBoolValue() {
        return this.boolValue;
    }

    public void setBoolValue(boolean boolValue) {
        this.boolValue = boolValue;
    }

    @Override
    public int compareTo(UIProperty property) {
        return Integer.compare(this.order, property.order);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getFilePathDirectoryType() {
        return this.filePathDirectoryType;
    }

    public void setFilePathDirectoryType(String filePathDirectoryType) {
        this.filePathDirectoryType = filePathDirectoryType;
    }

    public String getUiCategory() {
        return this.uiCategory;
    }

    public void setUiCategory(String uiCategory) {
        this.uiCategory = uiCategory;
    }

    public String getValidatePattern() {
        return this.validatePattern;
    }

    public void setValidatePattern(String validatePattern) {
        this.validatePattern = validatePattern;
    }
}

