/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.transport.UIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;

public class UITriggerConfiguration
extends UIConfiguration {
    private String state;
    private String error;

    public UITriggerConfiguration() {
    }

    public UITriggerConfiguration(Configuration configuration) {
        super(configuration);
    }

    @Nonnull
    static List<UIProperty> define(@Nonnull Collection<PropertyDescriptor> descriptors, InboundTransportConfiguration parent, TriggerConfiguration configuration) {
        ArrayList uiProperties = Lists.newArrayListWithExpectedSize((int)descriptors.size());
        for (PropertyDescriptor descriptor : descriptors) {
            UIProperty uiProperty;
            if (!descriptor.isForServer()) continue;
            if (!Strings.isNullOrEmpty((String)configuration.get((Object)descriptor.getShortName()))) {
                uiProperty = new UIProperty(descriptor, configuration.get((Object)descriptor.getShortName()));
                uiProperty.setOverridden("Overridden");
                if (Strings.isNullOrEmpty((String)parent.get((Object)descriptor.getShortName()))) {
                    uiProperty.setInheritedValue(parent.getReferencedConfiguration().get((Object)descriptor.getShortName()));
                } else {
                    uiProperty.setInheritedValue(parent.get((Object)descriptor.getShortName()));
                }
                uiProperties.add(uiProperty);
                continue;
            }
            uiProperty = Strings.isNullOrEmpty((String)parent.get((Object)descriptor.getShortName())) ? new UIProperty(descriptor, parent.getReferencedConfiguration().get((Object)descriptor.getShortName())) : new UIProperty(descriptor, parent.get((Object)descriptor.getShortName()));
            uiProperty.setOverridden("Inherited");
            uiProperties.add(uiProperty);
        }
        return uiProperties;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean defineProperties(TriggerConfiguration triggerConfiguration) throws RemoteException, TransportException {
        Map transportParameters = TransportRegistryManager.getInstance().getProperties(triggerConfiguration.getTypeName());
        boolean transportDeployed = transportParameters != null;
        List<UIProperty> uiProperties = transportDeployed ? UITriggerConfiguration.define(transportParameters.values(), triggerConfiguration.getParent(), triggerConfiguration) : UITriggerConfiguration.defineNonDeployed((Configuration)triggerConfiguration);
        this.setProperties(uiProperties);
        return transportDeployed;
    }
}

