/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport.interceptor;

import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.interceptor.ApplicabilityParams;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIApplicabilityParams
extends UIObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIApplicabilityParams.class);
    private UIObject environment;
    private UIObject system;

    public UIApplicabilityParams(Storable applicabilityParams) {
        this((ApplicabilityParams)applicabilityParams);
    }

    public UIApplicabilityParams(ApplicabilityParams applicabilityParams) {
        super((Storable)applicabilityParams);
        this.getApplicableParameterForUI(applicabilityParams, "Environment");
        this.getApplicableParameterForUI(applicabilityParams, "System");
    }

    public UIApplicabilityParams() {
    }

    public UIObject getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(UIObject environment) {
        this.environment = environment;
    }

    public UIObject getSystem() {
        return this.system;
    }

    public void setSystem(UIObject system) {
        this.system = system;
    }

    private void getApplicableParameterForUI(ApplicabilityParams applicabilityParams, String parameter) {
        String storableId = applicabilityParams.get((Object)parameter);
        if (StringUtils.isNotEmpty((CharSequence)storableId)) {
            Storable storable;
            if (parameter.equals("Environment")) {
                storable = CoreObjectManager.getInstance().getManager(Environment.class).getById((Object)storableId);
                if (storable != null) {
                    this.environment = new UIObject(storable);
                } else {
                    LOGGER.error(String.format("Environment with id = %s was not found. Please, import the environment or use another.", storableId));
                }
            }
            if (parameter.equals("System")) {
                storable = CoreObjectManager.getInstance().getManager(System.class).getById((Object)storableId);
                if (storable != null) {
                    this.system = new UIObject(storable);
                } else {
                    LOGGER.error(String.format("System with id = %s was not found. Please, import the system or use another.", storableId));
                }
            }
        }
    }
}

