/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.transport.interceptor;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.interceptor.ContentInterceptor;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.ParametersInterceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.ApplicabilityParams;
import org.qubership.automation.itf.core.util.descriptor.InterceptorPropertyDescriptor;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.loader.InterceptorClassLoader;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.interceptor.UIApplicabilityParams;

public class UIInterceptor
extends UIObject {
    private List<UIProperty> parameters = new ArrayList<UIProperty>();
    private int order;
    private boolean active;
    private String transportName;
    private String interceptorGroup;
    private List<UIApplicabilityParams> applicabilityParams = new ArrayList<UIApplicabilityParams>();

    public UIInterceptor(Storable interceptor) throws TransportException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        this((Interceptor)interceptor);
    }

    public UIInterceptor(Interceptor interceptor) throws IllegalArgumentException, TransportException {
        super((Storable)interceptor);
        List parameters;
        this.setOrder(interceptor.getOrder());
        this.setActive(interceptor.isActive());
        this.setTransportName(interceptor.getTransportName());
        this.setInterceptorGroup(interceptor.getInterceptorGroup());
        TransportInterceptor transportInterceptor = null;
        try {
            transportInterceptor = InterceptorClassLoader.getInstance().getInstanceClass(interceptor.getTypeName(), new Object[]{interceptor});
        }
        catch (ClassNotFoundException e) {
            throw new TransportException((Throwable)e);
        }
        if (ParametersInterceptor.class.isAssignableFrom(transportInterceptor.getClass())) {
            List<PropertyDescriptor> redefinedParameters = this.getRedefinedParametersFromTransport(interceptor.getTransportName());
            parameters = ((ParametersInterceptor)transportInterceptor).getParameters((List)redefinedParameters);
        } else {
            parameters = ((ContentInterceptor)transportInterceptor).getParameters();
        }
        for (InterceptorPropertyDescriptor parameter : parameters) {
            UIProperty uiProperty = new UIProperty(parameter);
            this.getParameters().add(uiProperty);
        }
        List applicabilityParams = interceptor.getApplicabilityParams();
        for (ApplicabilityParams params : applicabilityParams) {
            UIApplicabilityParams uiApplicabilityParams = new UIApplicabilityParams(params);
            this.getApplicabilityParams().add(uiApplicabilityParams);
        }
    }

    public UIInterceptor() {
        this.active = false;
    }

    public List<UIProperty> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<UIProperty> parameters) {
        this.parameters = parameters;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public UIResult validate() {
        for (UIProperty parameter : this.parameters) {
            if (Boolean.valueOf(parameter.getOptional()).booleanValue() || !StringUtils.isEmpty((CharSequence)parameter.getValue())) continue;
            return new UIResult(false, String.format("Parameter %s can not be empty. Please, fill the parameter.", parameter.getName()));
        }
        return new UIResult();
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    public String getInterceptorGroup() {
        return this.interceptorGroup;
    }

    public void setInterceptorGroup(String interceptorGroup) {
        this.interceptorGroup = interceptorGroup;
    }

    public List<UIApplicabilityParams> getApplicabilityParams() {
        return this.applicabilityParams;
    }

    public void setApplicabilityParams(List<UIApplicabilityParams> applicabilityParams) {
        this.applicabilityParams = applicabilityParams;
    }

    private List<PropertyDescriptor> getRedefinedParametersFromTransport(String transportTypeName) throws TransportException {
        ArrayList redefinedProperties = Lists.newArrayList();
        AccessTransport transport = TransportRegistryManager.getInstance().find(transportTypeName);
        if (transport != null) {
            try {
                for (PropertyDescriptor propertyDescriptor : transport.getProperties()) {
                    if (!propertyDescriptor.isRedefined()) continue;
                    redefinedProperties.add(propertyDescriptor);
                }
            }
            catch (RemoteException e) {
                throw new TransportException((Throwable)e);
            }
        }
        return redefinedProperties;
    }
}

