/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.service;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import org.qubership.automation.itf.core.util.config.Config;

public class TimeService {
    private static final String DATE_FORMAT = Config.getConfig().getString("log.appender.date.format");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DATE_FORMAT);

    public static String getFormattedDate(Date date) {
        Optional<Date> optional = Optional.ofNullable(date);
        return optional.map(date1 -> DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(date1.toInstant(), ZoneId.systemDefault()))).orElse("");
    }
}

