/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.services.javers.history;

import com.google.common.collect.Iterators;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javers.core.metamodel.object.SnapshotType;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.history.JaversCommitPropertyRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.history.JaversCommitRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.history.JaversGlobalIdRepository;
import org.qubership.automation.itf.core.hibernate.spring.repositories.executor.history.JaversSnapshotRepository;
import org.qubership.automation.itf.core.model.javers.JaversCountResponse;
import org.qubership.automation.itf.core.model.jpa.history.JvGlobalIdEntity;
import org.qubership.automation.itf.core.model.jpa.history.JvSnapshotEntity;
import org.qubership.automation.itf.ui.services.javers.history.DeleteHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeleteHistoryServiceImpl
implements DeleteHistoryService {
    private static final Logger log = LoggerFactory.getLogger(DeleteHistoryServiceImpl.class);
    private static final Integer FIRST_PAGE = 0;
    private final JaversSnapshotRepository snapshotRepository;
    private final JaversGlobalIdRepository globalIdRepository;
    private final JaversCommitRepository commitRepository;
    private final JaversCommitPropertyRepository commitPropertyRepository;

    @Transactional(rollbackFor={Exception.class})
    public void deleteOldAndUpdateAsInitial(Long globalId, List<JvSnapshotEntity> snapshots) {
        snapshots.forEach(snapshot -> this.deleteOldSnapshot(globalId, (JvSnapshotEntity)snapshot));
        this.findTheOldestSnapshotByGlobalIdAndUpdateTypeAsInitial(globalId);
    }

    private void deleteOldSnapshot(Long globalId, JvSnapshotEntity snapshot) {
        Long commitId = snapshot.getCommitId();
        Long version = snapshot.getVersion();
        this.snapshotRepository.deleteByVersionAndGlobalIdAndCommitId(version, globalId, commitId);
        log.info("Snapshots with version '{}', globalId '{}', commitId '{}' are deleted.", new Object[]{version, globalId, commitId});
        Long commitCount = this.snapshotRepository.countByCommitId(commitId);
        if (commitCount.equals(0L)) {
            this.commitPropertyRepository.deleteByIdCommitId(commitId);
            this.commitRepository.deleteById((Object)commitId);
            log.info("Commit properties and commits with commitId '{}' are deleted.", (Object)commitId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOldSnapshots(long maxRevisionCount) {
        this.findGlobalIdAndCount(maxRevisionCount).forEach(response -> {
            Long globalId = response.getId();
            long numberOfOldSnapshots = response.getCount() - maxRevisionCount;
            if (numberOfOldSnapshots >= 1L) {
                List<JvSnapshotEntity> oldSnapshots = this.findOldSnapshots(globalId, numberOfOldSnapshots);
                this.deleteOldAndUpdateAsInitial(globalId, oldSnapshots);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTerminatedSnapshots(Integer pageSize) {
        Page page;
        do {
            page = this.snapshotRepository.findAllByTypeIs(SnapshotType.TERMINAL, (Pageable)PageRequest.of((int)FIRST_PAGE, (int)pageSize));
            this.deleteTerminatedSnapshots((Page<JvSnapshotEntity>)page);
        } while (page.hasNext());
    }

    private void deleteTerminatedSnapshots(Page<JvSnapshotEntity> page) {
        List terminalSnapshots = page.getContent();
        Set<Long> globalIds = this.getIds(terminalSnapshots, JvSnapshotEntity::getGlobalId);
        if (globalIds.isEmpty()) {
            return;
        }
        log.info("Number of terminal globalIds '{}'.", (Object)globalIds.size());
        ArrayList snapshots = new ArrayList();
        this.doAction(globalIds, ids -> snapshots.addAll(this.snapshotRepository.findAllByGlobalIdIn((Collection)ids)));
        Set<Long> commitIds = this.getIds(snapshots, JvSnapshotEntity::getCommitId);
        List jvGlobalIdEntities = this.globalIdRepository.findAllByOwnerIdIn(globalIds);
        if (!jvGlobalIdEntities.isEmpty()) {
            Set innerGlobalIds = jvGlobalIdEntities.stream().map(JvGlobalIdEntity::getId).collect(Collectors.toSet());
            this.doAction(innerGlobalIds, arg_0 -> ((JaversSnapshotRepository)this.snapshotRepository).deleteByGlobalIdIn(arg_0));
            this.doAction(innerGlobalIds, arg_0 -> ((JaversGlobalIdRepository)this.globalIdRepository).deleteByIdIn(arg_0));
        }
        log.info("Number of terminal commitIds '{}'.", (Object)commitIds.size());
        this.doAction(globalIds, arg_0 -> ((JaversSnapshotRepository)this.snapshotRepository).deleteByGlobalIdIn(arg_0));
        log.info("Terminated snapshots are deleted.");
        this.doAction(globalIds, arg_0 -> ((JaversGlobalIdRepository)this.globalIdRepository).deleteByIdIn(arg_0));
        log.info("Terminated globalIds are deleted.");
        this.removeUsedCommitId(commitIds);
        this.doAction(commitIds, arg_0 -> ((JaversCommitPropertyRepository)this.commitPropertyRepository).deleteByIdCommitIdIn(arg_0));
        log.info("Terminated commit properties are deleted.");
        this.doAction(commitIds, arg_0 -> ((JaversCommitRepository)this.commitRepository).deleteByIdIn(arg_0));
        log.info("Terminated commits are deleted.");
    }

    private JvSnapshotEntity findTheOldestSnapshotByGlobalIdAndUpdateTypeAsInitial(Long globalId) {
        JvSnapshotEntity snapshot = this.snapshotRepository.findFirstByGlobalIdOrderByVersionAsc(globalId);
        if (Objects.isNull(snapshot)) {
            return null;
        }
        snapshot.setType(SnapshotType.INITIAL);
        return (JvSnapshotEntity)this.snapshotRepository.save((Object)snapshot);
    }

    private List<JvSnapshotEntity> findOldSnapshots(Long globalId, Long count) {
        PageRequest pageRequest = PageRequest.of((int)0, (int)Math.toIntExact(count));
        List oldSnapshots = this.snapshotRepository.findAllByGlobalIdOrderByVersionAsc(globalId, (Pageable)pageRequest);
        log.info("Number of old snapshots for globalId '{}': {}.", (Object)globalId, (Object)oldSnapshots.size());
        return oldSnapshots;
    }

    private List<JaversCountResponse> findGlobalIdAndCount(long maxRevisionCount) {
        List response = this.snapshotRepository.findGlobalIdAndCountGreaterThan(maxRevisionCount);
        log.info("Number of unique globalIds:  {}.", (Object)response.size());
        return response;
    }

    private <T> void doAction(Collection<T> collection, Consumer<? super List<T>> action) {
        Iterators.partition(collection.iterator(), (int)100).forEachRemaining(action);
    }

    private <T, R> Set<R> getIds(List<T> snapshots, Function<T, R> function) {
        return snapshots.stream().map(function).collect(Collectors.toSet());
    }

    private void removeUsedCommitId(Set<Long> commitIds) {
        HashSet<Long> commitIdsToRemove = new HashSet<Long>();
        for (Long commitId : commitIds) {
            if (this.snapshotRepository.countByCommitId(commitId) <= 0L) continue;
            commitIdsToRemove.add(commitId);
        }
        commitIds.removeAll(commitIdsToRemove);
    }

    @ConstructorProperties(value={"snapshotRepository", "globalIdRepository", "commitRepository", "commitPropertyRepository"})
    public DeleteHistoryServiceImpl(JaversSnapshotRepository snapshotRepository, JaversGlobalIdRepository globalIdRepository, JaversCommitRepository commitRepository, JaversCommitPropertyRepository commitPropertyRepository) {
        this.snapshotRepository = snapshotRepository;
        this.globalIdRepository = globalIdRepository;
        this.commitRepository = commitRepository;
        this.commitPropertyRepository = commitPropertyRepository;
    }
}

