/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.users.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.users.clients.dto.EntityDto;
import org.qubership.atp.users.clients.dto.GroupDto;
import org.qubership.atp.users.clients.dto.OperationsDto;
import org.qubership.atp.users.clients.dto.ProjectDto;
import org.qubership.atp.users.clients.dto.UserInfoDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="Projects", description="the Projects API")
public interface ProjectsApi {
    @Operation(operationId="deleteUserFromProject", summary="Delete user from project", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/users/projects/{projectId}/users/{userId}"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> deleteUserFromProject(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="userId", description="User ID", required=true) @PathVariable(value="userId") String var2);

    @Operation(operationId="getAllEntities", summary="Return all entities", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="List of service entity", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/entities"}, produces={"application/json"})
    public ResponseEntity<List<EntityDto>> getAllEntities(@Parameter(name="projectId", description="Project ID for check access", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getAllGroups", summary="Get all groups", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="Default user groups and permissions", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/users/groups"}, produces={"application/json"})
    public ResponseEntity<List<GroupDto>> getAllGroups(@Parameter(name="projectId", description="Project ID to check access", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getAllProjects", summary="Get all projects in collection", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects"}, produces={"application/json"})
    public ResponseEntity<List<ProjectDto>> getAllProjects();

    @Operation(operationId="getCustomPermissions", summary="Get custom permissions in specified project for specified group", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="Permissions for specified group in project", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationsDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/group/{groupAlias}/permissions"}, produces={"application/json"})
    public ResponseEntity<Map<String, OperationsDto>> getCustomPermissions(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="groupAlias", description="Group alias", required=true) @PathVariable(value="groupAlias") String var2);

    @Operation(operationId="getPermissionsForCurrentUser", summary="Return permissions for current user on project", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description=""), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/user/permissions"})
    public ResponseEntity<Void> getPermissionsForCurrentUser(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getProjectById", summary="Get project by id", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> getProjectById(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1);

    @Deprecated
    @Operation(operationId="getProjectUsersByProjectId", summary="Get users on the project by id", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/users"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> getProjectUsersByProjectId(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getProjectUsersByProjectIdAndGroupAlias", summary="Get users on the project by id", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/group/{groupAlias}/users"}, produces={"application/json"})
    public ResponseEntity<ProjectDto> getProjectUsersByProjectIdAndGroupAlias(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="groupAlias", description="Group Alias", required=true) @PathVariable(value="groupAlias") String var2);

    @Deprecated
    @Operation(operationId="getProjectsUsersEnrichedByUuid", summary="Get unique users of the project by project ID", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="Information about unique users of the project", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserInfoDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/users/enriched"}, produces={"application/json"})
    public ResponseEntity<List<UserInfoDto>> getProjectsUsersEnrichedByUuid(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1);

    @Operation(operationId="getProjectsUsersEnrichedByUuidAndGroupAlias", summary="Get unique users of the project by project ID and group alias", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="Information about unique users of the project", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserInfoDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users/projects/{projectId}/groups/{groupAlias}/users/enriched"}, produces={"application/json"})
    public ResponseEntity<List<UserInfoDto>> getProjectsUsersEnrichedByUuidAndGroupAlias(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="groupAlias", description="Group alias", required=true) @PathVariable(value="groupAlias") String var2);

    @Operation(operationId="updatePermissionsByProjectIdAndGroupAlias", summary="Update permissions in specified project for specified group", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description=""), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/users/projects/{projectId}/group/{groupAlias}/permissions"}, consumes={"application/json"})
    public ResponseEntity<Void> updatePermissionsByProjectIdAndGroupAlias(@Parameter(name="projectId", description="Project ID", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="groupAlias", description="Group alias", required=true) @PathVariable(value="groupAlias") String var2, @Parameter(name="request_body", description="Entities with custom permissions", required=true) @Valid @RequestBody Map<String, OperationsDto> var3);

    @Deprecated
    @Operation(operationId="updateProjectUsers", summary="Update projects user", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/v1/users/projects/update/users"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ProjectDto> updateProjectUsers(@NotNull @Parameter(name="type", description="type of user", required=true) @Valid @RequestParam(value="type", required=true) String var1, @Parameter(name="ProjectDto", description="project entity", required=true) @Valid @RequestBody ProjectDto var2);

    @Operation(operationId="updateProjectUsersInGroup", summary="Update projects user", tags={"Projects"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectDto.class))}), @ApiResponse(responseCode="400", description=""), @ApiResponse(responseCode="401", description=""), @ApiResponse(responseCode="403", description=""), @ApiResponse(responseCode="500", description="")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/v1/users/projects/{projectId}/groups/{groupAlias}/users"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ProjectDto> updateProjectUsersInGroup(@Parameter(name="projectId", description="Project Id to check access", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="groupAlias", description="Users group", required=true) @PathVariable(value="groupAlias") String var2, @Parameter(name="ProjectDto", description="Project entity", required=true) @Valid @RequestBody ProjectDto var3);
}

