/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.json.JSONObject;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.model.communication.message.CommonTriggerExecutionMessage;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerBulkActivationRequest;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSingleActivationRequest;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerSyncActivationRequest;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.util.eds.ExternalDataManagementService;
import org.qubership.automation.itf.core.util.eds.model.FileInfo;
import org.qubership.automation.itf.core.util.exception.EngineIntegrationException;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.service.SecurityHelper;
import org.qubership.automation.itf.integration.EventTriggerActivationService;
import org.qubership.automation.itf.integration.TriggerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.annotation.JmsListeners;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class StubJMSListeners {
    private static final Logger log = LoggerFactory.getLogger(StubJMSListeners.class);
    private final TriggerExecutor triggerExecutor;
    private final ObjectMapper executorIntegrationObjectMapper;
    private final EventTriggerActivationService eventTriggerActivationService;
    private final ExternalDataManagementService externalDataManagementService;
    private final Map<String, SseEmitter> sseEmitters;
    private final EventBusProvider eventBusProvider;
    private final ObjectMapper endExceptionalSituationsMapper;
    @Value(value="${atp-itf-executor.sse-reconnect-time}")
    private Long sseReconnectTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmsListener(destination="${message-broker.stubs-executor-incoming-request.queue}", containerFactory="stubDefaultJmsListenerQueueContainerFactory")
    @AtpJaegerLog
    public void onExecutorStubsSyncMessage(ActiveMQTextMessage activeMqTextMessage) {
        try {
            OffsetDateTime started = OffsetDateTime.now();
            activeMqTextMessage.acknowledge();
            this.setThreadName("stub");
            CommonTriggerExecutionMessage message = (CommonTriggerExecutionMessage)this.executorIntegrationObjectMapper.readValue(activeMqTextMessage.getText(), CommonTriggerExecutionMessage.class);
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)message.getTriggerConfigurationDescriptor().getProjectUuid());
            MdcUtils.put((String)MdcField.SESSION_ID.toString(), (String)message.getSessionId());
            String currentTraceId = activeMqTextMessage.getStringProperty("traceId");
            MdcUtils.put((String)MdcField.TRACE_ID.toString(), (String)currentTraceId);
            MdcUtils.put((String)MdcField.STUB_TRACE_ID.toString(), (String)currentTraceId);
            log.info("Project: {}. SessionId: {}. Message for execution is received.", (Object)message.getTriggerConfigurationDescriptor().getProjectUuid(), (Object)message.getSessionId());
            log.debug("Message for execution: {}", (Object)message.getMessage());
            this.triggerExecutor.produceEvent(message, started);
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JmsListener(destination="${message-broker.configurator-executor-event-triggers.topic}", containerFactory="defaultJmsListenerTopicContainerFactory")
    public void onConfiguratorExecutorEventTriggerMessage(ActiveMQTextMessage activeMqTextMessage) {
        try {
            log.info("Message for event trigger activation received");
            log.debug("Message for execution: {}", (Object)activeMqTextMessage.getText());
            this.setThreadName("event");
            JsonNode jsonMessage = this.executorIntegrationObjectMapper.readTree(activeMqTextMessage.getText());
            String type = jsonMessage.get("type").asText();
            String sessionId = jsonMessage.get("sessionId").asText();
            MdcUtils.put((String)MdcField.SESSION_ID.toString(), (String)sessionId);
            String tenantId = activeMqTextMessage.getStringProperty("X-Project-Id");
            SecurityHelper.propagateSecurityContext((JsonNode)jsonMessage);
            switch (type) {
                case "single": {
                    this.eventTriggerActivationService.switchTriggerState((EventTriggerSingleActivationRequest)this.executorIntegrationObjectMapper.readValue(activeMqTextMessage.getText(), EventTriggerSingleActivationRequest.class), tenantId, null, false);
                    return;
                }
                case "bulk": {
                    this.eventTriggerActivationService.switchTriggersState((EventTriggerBulkActivationRequest)this.executorIntegrationObjectMapper.readValue(activeMqTextMessage.getText(), EventTriggerBulkActivationRequest.class), tenantId);
                    return;
                }
                case "sync": {
                    this.eventTriggerActivationService.syncTriggersState((EventTriggerSyncActivationRequest)this.executorIntegrationObjectMapper.readValue(activeMqTextMessage.getText(), EventTriggerSyncActivationRequest.class), tenantId, true, false);
                    return;
                }
                case "afterRestoreSituationEventTrigger": {
                    this.eventTriggerActivationService.syncTriggersState((EventTriggerSyncActivationRequest)this.executorIntegrationObjectMapper.readValue(activeMqTextMessage.getText(), EventTriggerSyncActivationRequest.class), tenantId, false, true);
                    return;
                }
                case "afterRestoreOperationEventTrigger": {
                    this.eventTriggerActivationService.switchTriggerState((EventTriggerSingleActivationRequest)this.executorIntegrationObjectMapper.readValue(activeMqTextMessage.getText(), EventTriggerSingleActivationRequest.class), tenantId, true, true);
                    return;
                }
                default: {
                    log.error("Unexpected value from configurator_executor_event_triggers topic: {}", (Object)type);
                    return;
                }
            }
        }
        catch (JsonProcessingException | JMSException e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
            return;
        }
        finally {
            MDC.clear();
            SecurityContextHolder.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmsListeners(value={@JmsListener(destination="${message-broker.stubs-configurator.topic}", containerFactory="defaultJmsListenerTopicContainerFactory"), @JmsListener(destination="${message-broker.executor-configurator-event-triggers.topic}", containerFactory="defaultJmsListenerTopicContainerFactory")})
    public void onSseToConfiguratorMessage(ActiveMQTextMessage activeMqTextMessage) {
        String sessionId = "";
        SseEmitter emitter = null;
        try {
            this.setThreadName("event");
            String activeMqMessage = activeMqTextMessage.getText();
            sessionId = this.executorIntegrationObjectMapper.readTree(activeMqMessage).get("sessionId").asText();
            MdcUtils.put((String)MdcField.SESSION_ID.toString(), (String)sessionId);
            emitter = this.sseEmitters.get(sessionId);
            if (emitter != null) {
                SseEmitter.SseEventBuilder sseEvent = SseEmitter.event().id(sessionId).name("message").data((Object)activeMqMessage).reconnectTime(this.sseReconnectTime.longValue());
                emitter.send(sseEvent);
                log.debug("Message for execution: {}", (Object)sseEvent);
            }
        }
        catch (Exception ex) {
            if (emitter != null) {
                log.error("Exception while sending a response thrown by emitter with sessionId: {}", (Object)sessionId, (Object)ex);
                String clientErrorMessage = "Failed to execute request. See logs for more details.";
                emitter.completeWithError((Throwable)new EngineIntegrationException(clientErrorMessage));
            } else {
                log.error("Error while message processing: {}", (Object)activeMqTextMessage, (Object)ex);
            }
        }
        finally {
            if (emitter != null) {
                emitter.complete();
                log.info("Event emitter with sessionId: {} is completed.", (Object)sessionId);
                this.sseEmitters.remove(sessionId);
            }
            MDC.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JmsListener(destination="${message-broker.eds-update.topic}", containerFactory="defaultJmsListenerTopicContainerFactory")
    public void onExternalDataStorageUpdateMessage(ActiveMQTextMessage activeMqTextMessage) {
        try {
            this.setThreadName("eds");
            FileInfo fileInfo = (FileInfo)this.executorIntegrationObjectMapper.readValue(activeMqTextMessage.getText(), FileInfo.class);
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)fileInfo.getProjectUuid());
            switch (fileInfo.getEventType()) {
                case UPLOAD: {
                    if (fileInfo.getObjectId() != null) {
                        this.externalDataManagementService.getFileManagementService().save(this.externalDataManagementService.getExternalStorageService().getFileInfo(fileInfo.getObjectId()));
                    } else {
                        this.externalDataManagementService.getFileManagementService().save(fileInfo);
                    }
                    log.info("File '{}' is loaded into local storage successfully.", (Object)fileInfo.getFileName());
                    return;
                }
                case DELETE: {
                    this.externalDataManagementService.getFileManagementService().delete(fileInfo);
                    return;
                }
                default: {
                    throw new RuntimeException(String.format("Unknown file event type '%s' for topic 'message-broker.eds-update.topic'.", fileInfo.getEventType()));
                }
            }
        }
        catch (Exception e) {
            log.error("Error while message processing: {}", (Object)e.getMessage());
            return;
        }
        finally {
            MDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmsListener(destination="${message-broker.end-exceptional-situations-events.topic}", containerFactory="defaultJmsListenerTopicContainerFactory")
    @Transactional
    public void onEndExceptionalSituationsFinishEvent(ActiveMQTextMessage activeMqTextMessage) {
        try {
            this.setThreadName("event");
            SituationEvent.EndExceptionalSituationFinish event = (SituationEvent.EndExceptionalSituationFinish)this.endExceptionalSituationsMapper.readValue(activeMqTextMessage.getText(), SituationEvent.EndExceptionalSituationFinish.class);
            JSONObject json = new JSONObject(activeMqTextMessage.getText());
            String tcContextId = json.getJSONObject("situationInstance").getJSONObject("context").getString("tc");
            MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)tcContextId);
            TcContext tcContext = CacheServices.getTcContextCacheService().getById((Object)tcContextId);
            if (tcContext == null) {
                return;
            }
            event.getSituationInstance().getContext().setTC(tcContext);
            event.getSituationInstance().setParentContext(tcContext);
            this.eventBusProvider.post((Event)event);
        }
        catch (Exception e) {
            log.error("Error while posting finish event to EventBus after getting it from 'end_exceptional_situations_events' topic: {}", (Object)e.getMessage());
        }
        finally {
            MDC.clear();
        }
    }

    private void setThreadName(String prefix) {
        String currentName = Thread.currentThread().getName();
        int pos = currentName.indexOf(35);
        if (pos > -1) {
            Thread.currentThread().setName(prefix + currentName.substring(pos));
        } else {
            Thread.currentThread().setName(prefix);
        }
    }

    @ConstructorProperties(value={"triggerExecutor", "executorIntegrationObjectMapper", "eventTriggerActivationService", "externalDataManagementService", "sseEmitters", "eventBusProvider", "endExceptionalSituationsMapper"})
    public StubJMSListeners(TriggerExecutor triggerExecutor, ObjectMapper executorIntegrationObjectMapper, EventTriggerActivationService eventTriggerActivationService, ExternalDataManagementService externalDataManagementService, Map<String, SseEmitter> sseEmitters, EventBusProvider eventBusProvider, ObjectMapper endExceptionalSituationsMapper) {
        this.triggerExecutor = triggerExecutor;
        this.executorIntegrationObjectMapper = executorIntegrationObjectMapper;
        this.eventTriggerActivationService = eventTriggerActivationService;
        this.externalDataManagementService = externalDataManagementService;
        this.sseEmitters = sseEmitters;
        this.eventBusProvider = eventBusProvider;
        this.endExceptionalSituationsMapper = endExceptionalSituationsMapper;
    }
}

