/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.reports;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.util.Sets;
import org.qubership.automation.itf.executor.service.TCContextService;
import org.qubership.automation.itf.integration.reports.ReportsFeignClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReportsService {
    private static final Logger log = LoggerFactory.getLogger(ReportsService.class);
    private final ReportsFeignClient reportsFeignClient;
    private final TCContextService tcContextService;
    private final ScheduledExecutorService refreshPartitionsService = this.initRefreshPartitionsService();

    private ScheduledExecutorService initRefreshPartitionsService() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleWithFixedDelay(() -> {
            try {
                this.tcContextService.refreshPartitionNumbers(this.getCurrentPartitionNumbers());
            }
            catch (Throwable t) {
                log.error("Error while refreshing of current partition numbers from reporting service", t);
            }
        }, 5L, 3600L, TimeUnit.SECONDS);
        return service;
    }

    public List<Object[]> getContextProperties(String contextId, UUID projectUuid) {
        List contextPropertiesList = (List)this.reportsFeignClient.getContextProperties(contextId, projectUuid).getBody();
        return Objects.requireNonNull(contextPropertiesList).stream().map(List::toArray).collect(Collectors.toList());
    }

    public String getContextVariables(String contextId, UUID projectUuid) {
        return (String)this.reportsFeignClient.getContextVariables(contextId, projectUuid).getBody();
    }

    public Set<String> getKeys(String contextId, UUID projectUuid) {
        return Sets.newHashSet((Iterable)((Iterable)this.reportsFeignClient.getKeys(contextId, projectUuid).getBody()));
    }

    public Map<String, Integer> getCurrentPartitionNumbers() {
        return (Map)this.reportsFeignClient.getCurrentPartitionNumbers().getBody();
    }

    @ConstructorProperties(value={"reportsFeignClient", "tcContextService"})
    public ReportsService(ReportsFeignClient reportsFeignClient, TCContextService tcContextService) {
        this.reportsFeignClient = reportsFeignClient;
        this.tcContextService = tcContextService;
    }
}

