/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.integration.users;

import java.util.Set;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.springsecurity.account.SimpleKeycloakAccount;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.qubership.automation.itf.ui.model.LoginInfo;
import org.qubership.automation.itf.ui.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private static final String WARN_NO_AUTH = "Authentication is disabled - there are no access restrictions.";

    public User getLoggedUser() {
        User user = new User();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KeycloakAuthenticationToken) {
            AccessToken accessToken = ((KeycloakPrincipal)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getKeycloakSecurityContext().getToken();
            user.setName(accessToken.getName());
        } else {
            this.setUndefinedUser(user);
        }
        return user;
    }

    public String getLoggedUserToken() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof KeycloakPrincipal) {
            return ((KeycloakPrincipal)principal).getKeycloakSecurityContext().getTokenString();
        }
        return "";
    }

    public boolean checkUserRole() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KeycloakAuthenticationToken) {
            Set roles = ((SimpleKeycloakAccount)authentication.getDetails()).getRoles();
            return roles.contains("ATP_SUPPORT") || roles.contains("ATP_ADMIN");
        }
        return true;
    }

    public User getCurrentUserInfo() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = new User();
        if (principal instanceof KeycloakPrincipal) {
            AccessToken accessToken = ((KeycloakPrincipal)principal).getKeycloakSecurityContext().getToken();
            user.setId(((KeycloakPrincipal)principal).getName());
            user.setName(accessToken.getName());
        } else {
            this.setUndefinedUser(user);
        }
        return user;
    }

    public LoginInfo getLoginInfo() {
        boolean isAuthOff = false;
        User user = new User();
        LoginInfo loginInfo = new LoginInfo();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KeycloakAuthenticationToken) {
            Set roles = ((SimpleKeycloakAccount)authentication.getDetails()).getRoles();
            loginInfo.setSupport(roles.contains("ATP_SUPPORT") || roles.contains("ATP_ADMIN"));
            Object principal = authentication.getPrincipal();
            if (principal instanceof KeycloakPrincipal) {
                loginInfo.setToken(((KeycloakPrincipal)principal).getKeycloakSecurityContext().getTokenString());
                AccessToken accessToken = ((KeycloakPrincipal)principal).getKeycloakSecurityContext().getToken();
                user.setId(((KeycloakPrincipal)principal).getName());
                user.setName(accessToken.getName());
            } else {
                isAuthOff = true;
            }
        } else {
            isAuthOff = true;
        }
        if (isAuthOff) {
            this.setUndefinedUser(user);
            loginInfo.setSupport(true);
            loginInfo.setToken("");
        }
        loginInfo.setUser(user);
        return loginInfo;
    }

    private void setUndefinedUser(User user) {
        log.warn(WARN_NO_AUTH);
        user.setName("undefined");
    }
}

