/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config;

import org.qubership.automation.itf.core.util.finder.TransportRegistryFinder;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.core.util.transport.registry.base.AbstractTransportRegistry;
import org.qubership.automation.itf.core.util.transport.registry.base.TransportRegistry;
import org.qubership.automation.itf.executor.transports.holder.TransportHolder;
import org.qubership.automation.itf.executor.transports.registry.TransportRegistryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextTransport.class);
    private AbstractTransportRegistry registry;

    public void init() {
        LOGGER.info("Start transports loading...");
        try {
            this.registry = new TransportRegistryLoader();
            TransportRegistryFinder.getInstance().setTransportRegistry((TransportRegistry)this.registry);
            TransportRegistryManager transportRegistryManager = TransportRegistryManager.getInstance();
            transportRegistryManager.init(this.registry);
            transportRegistryManager.registerTransports(TransportHolder.getInstance().getTransports());
            this.registry.setLoaded(true);
            LOGGER.info("Transports are loaded successfully.");
        }
        catch (Exception e) {
            LOGGER.error("Error initialing transport object manager or modules", (Throwable)e);
        }
    }

    public void destroyed() {
        TransportRegistryManager.getInstance().destroy();
    }
}

