/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.config.ssl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"embedded.https.enabled"}, havingValue="true")
public class ItfServerCustomizer
implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
    private static final Logger log = LoggerFactory.getLogger(ItfServerCustomizer.class);
    private static final String CURRENT_HOST = "0.0.0.0";
    private final TrustManagerFactory trustManagerFactory;
    private final KeyManagerFactory keyManagerFactory;
    @Value(value="${embedded.tls.server.port}")
    private int tlsServerPort;
    @Value(value="${embedded.ssl.server.port}")
    private int sslServerPort;

    @Autowired
    public ItfServerCustomizer(TrustManagerFactory trustManagerFactory, KeyManagerFactory keyManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
        this.keyManagerFactory = keyManagerFactory;
    }

    public void customize(UndertowServletWebServerFactory factory) {
        factory.addBuilderCustomizers(new UndertowBuilderCustomizer[]{builder -> {
            this.createSslContext("TLSv1.2").ifPresent(tlsContext -> builder.addHttpsListener(this.tlsServerPort, CURRENT_HOST, tlsContext));
            this.createSslContext("SSL").ifPresent(sslContext -> builder.addHttpsListener(this.sslServerPort, CURRENT_HOST, sslContext));
        }});
    }

    private Optional<SSLContext> createSslContext(String protocol) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(protocol);
            sslContext.init(this.keyManagerFactory.getKeyManagers(), this.trustManagerFactory.getTrustManagers(), null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("Could not create SSLContext for " + protocol + " protocol.", (Throwable)e);
        }
        return Optional.ofNullable(sslContext);
    }
}

