/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.ui.messages.UIList;
import org.qubership.automation.itf.ui.messages.UIObjectList;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommonController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonController.class);
    private static boolean disabled = false;

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/common/ni"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Network Interfaces, project {{#projectUuid}}")
    public UIList<UIObject> getAllNetworkInterfaces(@RequestParam(value="projectUuid") UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        UIObjectList uiObjects = new UIObjectList();
        if (disabled) {
            return uiObjects;
        }
        try {
            List networkInterfaces = Pcaps.findAllDevs();
            for (PcapNetworkInterface networkInterface : networkInterfaces) {
                UIObject object = new UIObject();
                object.setName(networkInterface.getName());
                StringBuilder sb = new StringBuilder();
                for (PcapAddress address : networkInterface.getAddresses()) {
                    sb.append(address.getAddress().toString());
                }
                object.setDescription(networkInterface.getDescription() + sb);
                uiObjects.addObject(object);
            }
        }
        catch (PcapNativeException e) {
            LOGGER.warn("Error while searching the network devices: {}", (Object)e.toString());
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("Error while searching the network devices; may be Pcap software wasn't installed properly: {}", (Object)e.toString());
            disabled = true;
        }
        return uiObjects;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/common/filtered"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all objects by name {{#name}} and entityType {{#entityType}} in the project {{#projectId}}/{{#projectUuid}}")
    public List<? extends UIObject> getObjectsByFilteredName(@RequestParam(value="name") String name, @RequestParam(value="entityType") String entityType, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)projectUuid);
        try {
            Collection collection = null;
            if ("template".equals(entityType)) {
                collection = TemplateHelper.getByPieceOfNameAndProject((String)name, (BigInteger)projectId);
            } else if ("situation".equals(entityType)) {
                collection = ((ByProject)CoreObjectManager.getInstance().getSpecialManager(Situation.class, ByProject.class)).getByPieceOfNameAndProject(name, (Object)projectId);
            }
            if (collection != null) {
                ArrayList filteredList = Lists.newArrayListWithCapacity((int)collection.size());
                for (Storable object : collection) {
                    filteredList.add(new UIObject(object));
                }
                return filteredList;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while getting filtered name of entity: {}", (Object)e.toString());
        }
        return null;
    }
}

