/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.ui.messages.objects.UIConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    private final Environment env;
    private final ProjectSettingsService projectSettingsService;

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/config/set"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Set properties of project {{#projectUuid}}")
    public void setProperties(@RequestBody Properties properties, @RequestParam(value="projectUuid") UUID projectUuid) {
        Config.getConfig().merge(properties);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/config/get"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get property '{{#property}}' of project {{#projectUuid}}")
    public UIConfig getProperty(@RequestParam(value="property", defaultValue="") String property, @RequestParam(value="projectUuid") UUID projectUuid) {
        return new UIConfig(property, this.env.getProperty(property));
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/config/getByProjectId"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get property '{{#property}}' with default value '{{#defaultValue}}' of project {{#projectId}}/{{#projectUuid}}")
    public UIConfig getProperty(@RequestParam(value="property", defaultValue="") String property, @RequestParam(value="projectId", defaultValue="") String projectId, @RequestParam(value="defaultValue", defaultValue="") String defaultValue, @RequestParam(value="projectUuid") UUID projectUuid) {
        return new UIConfig(property, this.projectSettingsService.get((Object)projectId, property, defaultValue));
    }

    @RequestMapping(value={"/config/getAuthType"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get property by name '{{#property}}'")
    public UIConfig getAuthTypeProperty(@RequestParam(value="property", defaultValue="authentication.type") String property) {
        return new UIConfig(property, this.env.getProperty(property));
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/config/get/properties/for_run"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get properties for run with prefix {{#prefix}}, truncPrefix {{#truncPrefix}} of project {{#projectId}}/{{#projectUuid}}")
    public List<UIConfig> getPropertiesForRun(@RequestParam(value="prefix", defaultValue="") String prefix, @RequestParam(value="truncPrefix", defaultValue="true") String truncPrefix, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Map properties = this.projectSettingsService.getByPrefix((Object)projectId, prefix, Boolean.parseBoolean(truncPrefix));
        ArrayList propertiesForRun = Lists.newArrayListWithCapacity((int)properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            propertiesForRun.add(new UIConfig((String)entry.getKey(), (String)entry.getValue()));
        }
        return propertiesForRun;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/integration/config/get"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Integration config property with config name {{#configName}} and property name {{#property}} of project {{#projectId}}/{{#projectUuid}}")
    public UIConfig getIntegrationConfigProperty(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="configName", defaultValue="") String configName, @RequestParam(value="property", defaultValue="") String property, @RequestParam(value="projectUuid") UUID projectUuid) {
        StubProject project = (StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)projectId);
        if (project == null) {
            throw new ObjectNotFoundException("Project", String.valueOf(projectId), null, "get configuration '" + configName + "'");
        }
        ArrayList result = Lists.newArrayList();
        for (IntegrationConfig config : project.getIntegrationConfs()) {
            if (!configName.equals(config.getName())) continue;
            result.add(config);
            if (result.size() <= 1) continue;
            log.error("There are more than one configuration with name '{}' in ITF. Please, check 'Integrations' tab", (Object)configName);
            return new UIConfig(property, "");
        }
        return result.isEmpty() ? new UIConfig(property, "") : new UIConfig(property, ((IntegrationConfig)result.iterator().next()).get((Object)property));
    }

    @ConstructorProperties(value={"env", "projectSettingsService"})
    public ConfigController(Environment env, ProjectSettingsService projectSettingsService) {
        this.env = env;
        this.projectSettingsService = projectSettingsService;
    }
}

