/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.operation.OperationException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.copier.OriginalCopyMap;
import org.qubership.automation.itf.core.util.copier.SmartCopier;
import org.qubership.automation.itf.core.util.copier.StorableCopier;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.objects.copy.UICopyMove;
import org.qubership.automation.itf.ui.util.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Transactional(readOnly=true)
@RestController
@RequestMapping(value={"/copier"})
public class CopierController
extends ControllerHelper {
    private static final Logger log = LoggerFactory.getLogger(CopierController.class);
    private static final String WARNING_UNEXPECTED_OPERATION = "Unexpected operation for copy/move object";
    private static final int OPERATION_COPY = 1;
    private static final int OPERATION_MOVE = 2;
    private final ProjectSettingsService projectSettingsService;

    private static String appendIndexToField(String field, Object newId) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return field;
        }
        Pattern indexPattern = Pattern.compile("\\[(\\d*)]$");
        Matcher matcher = indexPattern.matcher(field);
        StringBuilder result = new StringBuilder(field);
        if (matcher.find()) {
            String newIndexStr;
            try {
                int newIndex = Integer.parseInt(matcher.group(1)) + 1;
                newIndexStr = String.valueOf(newIndex);
            }
            catch (NumberFormatException ex) {
                newIndexStr = newId.toString();
            }
            result.replace(matcher.start(1), matcher.end(1), newIndexStr);
        } else {
            result.append(" [2]");
        }
        return result.toString();
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/copyobject"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Copy selected objects in the project {{#projectUuid}}")
    public UIObject copyObject(@RequestBody UICopyMove request, @RequestParam(value="projectUuid") UUID projectUuid) {
        try {
            return this.doCopyMoveOperationInTransaction(request, 1);
        }
        catch (Exception e) {
            throw new OperationException("Copy", e.getMessage());
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/moveobject"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Move selected objects in the project {{#projectUuid}}")
    public UIObject moveObject(@RequestBody UICopyMove request, @RequestParam(value="projectUuid") UUID projectUuid) {
        try {
            return this.doCopyMoveOperationInTransaction(request, 2);
        }
        catch (Exception e) {
            throw new OperationException("Move", e.getMessage());
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/issmart"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Check if SmartCopy is turned on for project {{#projectId}}/{{#projectUuid}}")
    public boolean getIsSmartValue(@RequestParam(value="projectId") String projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return this.isSmartCopier(projectId);
    }

    private boolean isSmartCopier(String projectId) {
        return Boolean.parseBoolean(this.projectSettingsService.get((Object)projectId, "copyObjects.isSmart", "false"));
    }

    private UIObject doCopyMoveOperationInTransaction(UICopyMove request, int operation) throws Exception {
        ObjectManager manager = CoreObjectManager.getInstance().getManager(StubProject.class);
        return (UIObject)TxExecutor.execute(() -> {
            try {
                manager.setReplicationRole("replica");
                UIObject uIObject = this.doCopyMoveOperation(request, operation);
                return uIObject;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.getTopStackTrace(e));
            }
            finally {
                manager.setReplicationRole("origin");
            }
        }, (TransactionDefinition)TxExecutor.defaultWritableTransaction());
    }

    private UIObject doCopyMoveOperation(UICopyMove request, int operation) throws Exception {
        this.performPreValidationSteps(request);
        String error = this.validateRequest(request, operation);
        if (StringUtils.isEmpty((CharSequence)error)) {
            Storable destinationObject = CoreObjectManager.getInstance().getManager(Class.forName(request.getDestination().getClassName()).asSubclass(Storable.class)).getById((Object)request.getDestination().getId());
            CopierController.throwExceptionIfNull(destinationObject, request.getDestination().getName(), request.getDestination().getId(), Class.forName(request.getDestination().getClassName()).asSubclass(Storable.class), "copy/move");
            ArrayList copiedMovedObjects = Lists.newArrayList();
            String sessionId = UUID.randomUUID().toString();
            StorableCopier.setKeyAndValueMapCopyFlag((String)sessionId, (boolean)request.getCopyFlag());
            List<Storable> sourceObjects = UIHelper.initializeObjects(request.getSources());
            for (Storable source : sourceObjects) {
                Storable copiedMovedSource = this.performCopyMoveOperation(source, destinationObject, operation, request.getOther(), sessionId, request.getProjectId());
                this.performPostActions(sessionId, operation, source, copiedMovedSource, request.getProjectId());
                copiedMovedObjects.add(copiedMovedSource);
            }
            destinationObject.store();
            destinationObject.flush();
            OriginalCopyMap.getInstance().clear((Object)sessionId);
            return UIHelper.getUIPresentationByStorable(destinationObject, Class.forName(request.getSources().get(0).getClassName()), copiedMovedObjects);
        }
        throw new IllegalArgumentException(error);
    }

    private void performPostActions(String sessionId, int copyMoveOperation, Storable sourceObject, Storable copiedMovedSource, String projectId) {
        block13: {
            block11: {
                block15: {
                    block14: {
                        block12: {
                            if (copyMoveOperation != 1) break block11;
                            if (!(sourceObject instanceof Situation)) break block12;
                            this.performPostCopyActions_Situation(sessionId, (Situation)sourceObject, (Situation)copiedMovedSource);
                            break block13;
                        }
                        if (!(sourceObject instanceof Operation)) break block14;
                        for (Situation situation : ((Operation)sourceObject).getSituations()) {
                            Situation copiedSituation = (Situation)OriginalCopyMap.getInstance().get((Object)sessionId, situation.getID());
                            this.performPostCopyActions_Situation(sessionId, situation, copiedSituation);
                        }
                        break block13;
                    }
                    if (!(sourceObject instanceof System)) break block15;
                    for (Operation operation : ((System)sourceObject).getOperations()) {
                        for (Situation situation : operation.getSituations()) {
                            Situation copiedSituation = (Situation)OriginalCopyMap.getInstance().get((Object)sessionId, situation.getID());
                            this.performPostCopyActions_Situation(sessionId, situation, copiedSituation);
                        }
                    }
                    break block13;
                }
                if (!(sourceObject instanceof Environment)) break block13;
                this.performPostCopyActions_Server(copiedMovedSource, projectId);
                break block13;
            }
            if (sourceObject instanceof Situation) {
                this.performPostMoveActions_Situation((Situation)copiedMovedSource);
            } else if (sourceObject instanceof Operation) {
                for (Situation situation : ((Operation)sourceObject).getSituations()) {
                    this.performPostMoveActions_Situation(situation);
                }
            } else if (sourceObject instanceof System) {
                for (Operation operation : ((System)sourceObject).getOperations()) {
                    for (Situation situation : operation.getSituations()) {
                        this.performPostMoveActions_Situation(situation);
                    }
                }
            }
        }
    }

    private void performPostMoveActions_Situation(Situation movedSituation) {
        movedSituation.getParsingRules().removeIf(parsingRule -> !parsingRule.getParent().getID().equals(movedSituation.getParent().getID()));
    }

    private void performPostCopyActions_Situation(String sessionId, Situation sourceSituation, Situation copiedSituation) {
        if (copiedSituation == null) {
            return;
        }
        if (sourceSituation.getParent().getID().equals(copiedSituation.getParent().getID())) {
            return;
        }
        if (sourceSituation.getParsingRules().isEmpty()) {
            return;
        }
        HashSet<OperationParsingRule> changedOperationParsingRules = new HashSet<OperationParsingRule>();
        for (ParsingRule parsingRule : sourceSituation.getParsingRules()) {
            OperationParsingRule copiedParsingRule = (OperationParsingRule)OriginalCopyMap.getInstance().get((Object)sessionId, parsingRule.getID());
            if (copiedParsingRule == null) continue;
            changedOperationParsingRules.add(copiedParsingRule);
        }
        copiedSituation.setParsingRules(changedOperationParsingRules);
    }

    private void performPostCopyActions_Server(Storable copiedSource, String projectId) {
        this.fillProjectIdFromServer(((Environment)copiedSource).getOutbound(), projectId);
        this.fillProjectIdFromServer(((Environment)copiedSource).getInbound(), projectId);
    }

    private void fillProjectIdFromServer(Map<System, Server> entrySource, String projectId) {
        for (Map.Entry<System, Server> entry : entrySource.entrySet()) {
            Server serverHB = entry.getValue();
            if (serverHB.getProjectId() != null) continue;
            serverHB.setProjectId(new BigInteger(projectId));
        }
    }

    private Storable performCopyMoveOperation(Storable source, Storable destinationObject, int operation, JSONObject other, String sessionId, String projectId) throws Exception {
        ObjectManager objectManager = CoreObjectManager.getInstance().getManager(source.getClass().asSubclass(Storable.class));
        switch (operation) {
            case 1: {
                Storable copiedSource = objectManager.copy(destinationObject, source, projectId, sessionId);
                if (this.isSmartCopier(projectId) && source.getClass().getName().endsWith("Environment")) {
                    if (Objects.nonNull(other)) {
                        copiedSource = SmartCopier.setAllValuesOnCopyStorable((Storable)copiedSource, (Storable)source, (JSONObject)other, (String)projectId);
                    } else {
                        copiedSource.setName(CopierController.appendIndexToField(copiedSource.getName(), copiedSource.getID()));
                    }
                } else {
                    copiedSource.setName(CopierController.appendIndexToField(copiedSource.getName(), copiedSource.getID()));
                }
                return copiedSource;
            }
            case 2: {
                objectManager.move(destinationObject, source, sessionId);
                break;
            }
            default: {
                log.warn(WARNING_UNEXPECTED_OPERATION);
            }
        }
        return source;
    }

    private void performPreValidationSteps(UICopyMove copyMoveRequest) throws ClassNotFoundException {
        UIObject firstElement = copyMoveRequest.getSources().get(0);
        Storable firstSource = CoreObjectManager.getInstance().getManager(Class.forName(firstElement.getClassName()).asSubclass(Storable.class)).getById((Object)firstElement.getId());
        if (firstSource instanceof CallChain || firstSource instanceof ChainFolder || firstSource instanceof System || firstSource instanceof SystemFolder) {
            Storable destinationObject;
            UIObject dest = copyMoveRequest.getDestination();
            try {
                destinationObject = dest.getId() == null ? null : CoreObjectManager.getInstance().getManager(Class.forName(dest.getClassName()).asSubclass(Storable.class)).getById((Object)dest.getId());
            }
            catch (Exception ignore) {
                dest = null;
                destinationObject = null;
            }
            if (dest == null || !(destinationObject instanceof ChainFolder) && !(destinationObject instanceof SystemFolder)) {
                if (firstSource.getParent() != null) {
                    copyMoveRequest.setDestination(new UITreeElement(firstSource.getParent()));
                } else {
                    Folder rootFolder = null;
                    StubProject project = (StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)copyMoveRequest.getProjectId());
                    if (firstSource instanceof CallChain) {
                        rootFolder = project.getCallchains();
                    } else if (firstSource instanceof System) {
                        rootFolder = project.getSystems();
                    }
                    UITreeElement uiRootFolder = new UITreeElement((Storable)rootFolder);
                    uiRootFolder.setRoot(true);
                    copyMoveRequest.setDestination(uiRootFolder);
                }
            }
        } else if (firstSource instanceof Environment) {
            Storable destinationObject;
            UIObject dest = copyMoveRequest.getDestination();
            try {
                destinationObject = dest.getId() == null ? null : CoreObjectManager.getInstance().getManager(Class.forName(dest.getClassName()).asSubclass(Storable.class)).getById((Object)dest.getId());
            }
            catch (Exception ignore) {
                dest = null;
                destinationObject = null;
            }
            if (dest == null || !(destinationObject instanceof Folder)) {
                if (firstSource.getParent() != null) {
                    copyMoveRequest.setDestination(new UITreeElement(firstSource.getParent()));
                } else {
                    Folder rootFolder = ((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)copyMoveRequest.getProjectId())).getEnvironments();
                    UITreeElement uiRootFolder = new UITreeElement((Storable)rootFolder);
                    uiRootFolder.setRoot(true);
                    copyMoveRequest.setDestination(uiRootFolder);
                }
            }
        }
    }

    private String validateRequest(UICopyMove copyMoveRequest, int operationType) {
        String error = this.destinationIsNotNull(copyMoveRequest, operationType);
        this.destinationIsTheSameAsSource(copyMoveRequest);
        return error;
    }

    private String destinationIsNotNull(UICopyMove copyMoveRequest, int operationType) {
        if (copyMoveRequest.getDestination() == null) {
            return "Destination for " + (operationType == 1 ? "copied" : "moved") + " objects wasn't selected. Please, select the destination.";
        }
        return "";
    }

    private void destinationIsTheSameAsSource(UICopyMove copyMoveRequest) {
        UIObject destination = copyMoveRequest.getDestination();
        for (UIObject source : copyMoveRequest.getSources()) {
            if (!source.getId().equals(destination.getId()) || destination.getParent() == null) continue;
            copyMoveRequest.setDestination(destination.getParent());
        }
    }

    @ConstructorProperties(value={"projectSettingsService"})
    public CopierController(ProjectSettingsService projectSettingsService) {
        this.projectSettingsService = projectSettingsService;
    }
}

