/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.stub.fast.FastConfigurationRequest;
import org.qubership.automation.itf.core.stub.fast.FastConfigurationResponse;
import org.qubership.automation.itf.core.stub.fast.FastStubConfigurationAction;
import org.qubership.automation.itf.ui.services.faststubs.FastStubsService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FastStubsController {
    private final FastStubsService fastStubsService;

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @PostMapping(value={"/fast-stubs/candidates"})
    @AuditAction(auditAction="Get fast stubs candidates (situations) by operations '{{#operationIds}}' of project {{#projectUuid}}")
    public Object getFastStubsCandidates(@RequestBody List<BigInteger> operationIds, @RequestParam UUID projectUuid) {
        return this.fastStubsService.getFastStubsCandidates(operationIds, projectUuid);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"CREATE\")")
    @PostMapping(value={"/fast-stubs/configuration"})
    @AuditAction(auditAction="Configuration fast stubs config by operations of project {{#projectUuid}} with action {{#action}}")
    public FastConfigurationResponse generateFastStubsConfigs(@RequestBody FastConfigurationRequest fastConfigurationRequest, @RequestParam FastStubConfigurationAction action, @RequestParam UUID projectUuid) {
        return this.fastStubsService.generateFastStubsConfigs(fastConfigurationRequest, action, projectUuid);
    }

    @ConstructorProperties(value={"fastStubsService"})
    public FastStubsController(FastStubsService fastStubsService) {
        this.fastStubsService = fastStubsService;
    }
}

