/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.messages.objects.ExistenceChecker;
import org.qubership.automation.itf.ui.messages.objects.StarterSituationExistanceChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ObjectConfigurationController {
    public final Logger LOGGER = LoggerFactory.getLogger(ObjectConfigurationController.class);

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).SITUATION.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/situation/exists"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Check if Situation exists in the project {{#projectId}}/{{#projectUuid}}")
    public ResponseEntity isSituationExists(@RequestBody StarterSituationExistanceChecker checker, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        String situationName = this.findSituation(checker, projectId);
        return situationName == null ? this.getResponseEntity(HttpStatus.NO_CONTENT, new String[0]) : this.getResponseEntity(HttpStatus.OK, situationName);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/entity/exists"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Check if Entity exists in the project {{#projectId}}/{{#projectUuid}}")
    public ResponseEntity isEntityExists(@RequestBody ExistenceChecker checker, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Storable storable = this.checkEntityExisting(checker, projectId);
        if (storable != null) {
            String returnedData = storable instanceof Operation ? storable.getName() + "|" + ((Operation)storable).getTransport().getName() : storable.getName();
            return this.getResponseEntity(HttpStatus.OK, returnedData);
        }
        return this.getResponseEntity(HttpStatus.NO_CONTENT, new String[0]);
    }

    private Storable checkEntityExisting(ExistenceChecker checker, BigInteger projectId) {
        if (checker != null && checker.getEntityName() != null) {
            Collection operations;
            Template storable = null;
            if ("Template".equals(checker.getEntityClass())) {
                Collection templates = TemplateHelper.getByParentNameAndProject((String)checker.getEntityParent(), (BigInteger)projectId);
                for (Template template : templates) {
                    if (!checker.getEntityName().equals(template.getName())) continue;
                    storable = template;
                }
            } else if ("Operation".equals(checker.getEntityClass()) && (operations = ((ByProject)CoreObjectManager.getInstance().getSpecialManager(Operation.class, ByProject.class)).getByParentNameAndProject(checker.getEntityParent(), (Object)projectId)) != null) {
                for (Operation operation : operations) {
                    Map.Entry<String, String> entry = checker.getParams().entrySet().iterator().next();
                    try {
                        Field field = operation.getClass().getDeclaredField(entry.getKey());
                        field.setAccessible(true);
                        String fieldValue = (String)field.get(operation);
                        if (!entry.getValue().equals(fieldValue)) continue;
                        storable = operation;
                        break;
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        this.LOGGER.error(String.format("Error while getting the value of %s for %s", entry.getKey(), operation.getName()));
                    }
                }
            }
            return storable;
        }
        return null;
    }

    private String findSituation(StarterSituationExistanceChecker checker, BigInteger projectId) {
        Operation parentOperation;
        ExistenceChecker parentChecker = checker.getParentChecker();
        if (parentChecker != null && (parentOperation = (Operation)this.checkEntityExisting(parentChecker, projectId)) != null) {
            for (Situation situation : parentOperation.getSituations()) {
                if (!this.isStepExists(checker.getSenderName(), checker.getReceiverName(), checker.getOperationChecker(), checker.getTemplateName(), (StepContainer)situation, projectId)) continue;
                return situation.getName();
            }
        }
        return null;
    }

    private boolean isStepExists(String senderName, String receiverName, ExistenceChecker operationChecker, String templateName, StepContainer stepContainer, BigInteger projectId) {
        for (Step step : stepContainer.getSteps()) {
            IntegrationStep integrationStep = (IntegrationStep)step;
            if (!this.isNamesEquals(senderName, (Storable)integrationStep.getSender()) || !this.isNamesEquals(receiverName, (Storable)integrationStep.getReceiver()) || operationChecker != null && this.checkEntityExisting(operationChecker, projectId) == null || !this.isNamesEquals(templateName, (Storable)integrationStep.returnStepTemplate())) continue;
            return true;
        }
        return false;
    }

    private boolean isNamesEquals(String objectName, Storable storable) {
        if (storable == null && StringUtils.isBlank((CharSequence)objectName)) {
            return true;
        }
        return storable != null && storable.getName().equalsIgnoreCase(objectName);
    }

    private ResponseEntity<String> getResponseEntity(HttpStatus statusCode, String ... response) {
        if (ArrayUtils.isEmpty((Object[])response)) {
            return new ResponseEntity(statusCode);
        }
        return new ResponseEntity((Object)response[0], statusCode);
    }
}

