/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.qubership.automation.itf.ui.controls.util.Collector;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.controls.util.ReferenceRegenerator;
import org.qubership.automation.itf.ui.messages.EnumReferenceRegenerationClass;
import org.qubership.automation.itf.ui.messages.ReferenceRegenerationRequest;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.qubership.automation.itf.ui.messages.objects.request.referenceregenerator.UIReplacement;
import org.qubership.automation.itf.ui.messages.objects.request.referenceregenerator.UIReplacementTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referenceRegenerator"})
public class ReferenceRegeneratorController
extends ControllerHelper {
    private static final Logger log = LoggerFactory.getLogger(ReferenceRegeneratorController.class);

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/getCompatibleSystems"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Get Compatible Systems")
    public Set<UIReplacement> getCompatibleSystems(@RequestBody ReferenceRegenerationRequest request, @RequestParam(value="projectUuid") UUID projectUuid) {
        try {
            return this.getCompatibleSystemsByIds(request.getIds(), request.getEntityClass());
        }
        catch (Exception e) {
            log.error("Error while compatible systems collecting: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException(this.getTopStackTrace(e));
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/regenerateReferences"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Regenerate References")
    public void regenerateReferences(@RequestBody UIReplacementTarget request, @RequestParam(value="projectUuid") UUID projectUuid) {
        try {
            this.doRegenerateOperation(request);
        }
        catch (Exception e) {
            log.error("Error while regenerate references processing: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void doRegenerateOperation(UIReplacementTarget request) throws Exception {
        HashSet<Storable> sourceObjects = new HashSet<Storable>(this.initObjects(request.getSources()));
        HashMap<System, System> systemsToReplacementMap = this.initializeSystemToReplacementMap(request.getTargetSystems());
        Class<?> clazz = ((Storable)sourceObjects.stream().findAny().orElse(null)).getClass();
        if (systemsToReplacementMap.isEmpty() || sourceObjects.isEmpty()) {
            return;
        }
        if (System.class.equals(clazz)) {
            ReferenceRegenerator.regenerateSystems(sourceObjects, systemsToReplacementMap);
        } else {
            ReferenceRegenerator.regenerateSituationSteps(systemsToReplacementMap, Collector.collectSituationStepsFromStorables(sourceObjects, clazz));
        }
    }

    private List<Storable> initObjects(Collection<UIObject> sources) {
        ArrayList<Storable> result = new ArrayList<Storable>();
        CoreObjectManagerService coreObjectManager = CoreObjectManager.getInstance();
        for (UIIdentifiedObject uIIdentifiedObject : sources) {
            String sourceId = uIIdentifiedObject.getId();
            Class<? extends Storable> sourceClassName = EnumReferenceRegenerationClass.fromValue(uIIdentifiedObject.getClassName()).getEntityClass();
            result.add(coreObjectManager.getManager(sourceClassName).getById((Object)sourceId));
        }
        return result;
    }

    private HashMap<System, System> initializeSystemToReplacementMap(Set<UIReplacement> targetSystems) {
        HashMap<System, System> result = new HashMap<System, System>();
        ObjectManager om = CoreObjectManager.getInstance().getManager(System.class);
        for (UIReplacement targetSystem : targetSystems) {
            result.put((System)om.getById((Object)targetSystem.getId()), (System)om.getById((Object)targetSystem.getReplacement().getId()));
        }
        return result;
    }

    private Set<UIReplacement> getCompatibleSystemsByIds(String[] ids, Class<? extends Storable> clazz) throws ClassNotFoundException, IllegalArgumentException {
        HashSet<System> storables = new HashSet<System>();
        for (String id : ids) {
            storables.add((System)CoreObjectManager.getInstance().getManager(clazz.asSubclass(Storable.class)).getById((Object)id));
        }
        if (storables.contains(null)) {
            throw new IllegalArgumentException("Selected objects must be instances of the same class. You can't select folder and storable objects at once.");
        }
        if (System.class.equals(clazz)) {
            return this.getCompatibleSystemsForSystems(Collector.collectSystemsFromSystems(storables));
        }
        if (SystemFolder.class.equals(clazz)) {
            return this.getCompatibleSystemsForSystems(Collector.collectSystemsFromFolders(storables));
        }
        return this.getCompatibleSystemsForSituationSteps(Collector.collectSituationStepsFromStorables(storables, clazz));
    }

    private HashSet<UIReplacement> getCompatibleSystemsForSystems(Set<System> systems) {
        HashSet<UIReplacement> uiReplacements = new HashSet<UIReplacement>();
        for (System system : systems) {
            UIReplacement uiReplacement = new UIReplacement(system);
            ReferenceRegeneratorController.getManager(System.class).getByNatureId(system.getID(), null).forEach(s -> {
                if (!s.getID().equals(system.getID())) {
                    uiReplacement.addCompatibleSystem((System)s);
                }
            });
            uiReplacements.add(uiReplacement);
        }
        return uiReplacements;
    }

    private Set<UIReplacement> getCompatibleSystemsForSituationSteps(Set<SituationStep> steps) {
        return this.getCompatibleSystemsForSystems(Collector.collectSystemsFromSituationSteps(steps));
    }
}

