/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIList;
import org.qubership.automation.itf.ui.messages.UIObjectList;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SelectController
extends ControllerHelper {
    private static final LoadingCache<String, UIList<UIObject>> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, UIList<UIObject>>(){

        public UIList<UIObject> load(@Nonnull String className) throws Exception {
            UIObjectList uiObjects = new UIObjectList();
            Class<Storable> aClass = Class.forName(className).asSubclass(Storable.class);
            for (Storable storable : CoreObjectManager.getInstance().getManager(aClass).getAll()) {
                if (!aClass.isAssignableFrom(storable.getClass())) continue;
                uiObjects.addObject(new UIObject(storable));
            }
            return uiObjects;
        }
    });

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/select/options"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get list of '{{#className}}' objects from project {{#projectId}}")
    public UIList getList(@RequestParam(value="className", defaultValue="") String className, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        return (UIList)TxExecutor.execute(() -> {
            UIList<UIObject> uiList = (UIList<UIObject>)CACHE.get((Object)className);
            return uiList == null ? new UIObjectList() : uiList;
        });
    }
}

