/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UITCContext;
import org.qubership.automation.itf.ui.messages.objects.UITCContextList;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TCContextController
extends ControllerHelper {
    private static final String DATE_FORMAT = Config.getConfig().getString("log.appender.date.format");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT).withZone(ZoneId.systemDefault()).withLocale(Locale.ENGLISH);

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/starter/tccontexts"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get TCContexts in the project {{#projectId}} [Deprecated, to be deleted]")
    public UITCContextList getTcContexts(@RequestParam(value="projectUuid") UUID projectUuid) {
        UITCContextList uiContexts = new UITCContextList();
        Collection stoppedItems = Collections2.filter((Collection)CoreObjectManager.getInstance().getManager(TcContext.class).getAll(), input -> input != null && !Status.IN_PROGRESS.equals((Object)input.getStatus()));
        Collection contexts = Collections2.transform((Collection)stoppedItems, (Function)new Function<TcContext, UITCContext>(){

            @Nullable
            public UITCContext apply(TcContext input) {
                UITCContext uiTcContext = new UITCContext();
                uiTcContext.setName(String.format("%s %s [%s]", input.getName(), input.getStartTime().toInstant().atZone(ZoneId.systemDefault()).format(dateTimeFormatter), input.getStatus().toString()));
                uiTcContext.setId(input.getID().toString());
                return uiTcContext;
            }
        });
        uiContexts.setTccontexts(Lists.newArrayList((Iterable)contexts));
        return uiContexts;
    }
}

