/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.eci;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvConfigurationManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.environments.convert.ConverterFactory;
import org.qubership.automation.itf.environments.object.ECEntity;
import org.qubership.automation.itf.environments.object.impl.ECConnection;
import org.qubership.automation.itf.environments.object.impl.ECEnvironment;
import org.qubership.automation.itf.environments.object.impl.ECSystem;
import org.qubership.automation.itf.environments.parse.ParserFactory;
import org.qubership.automation.itf.environments.util.validation.ECIErrorsCache;
import org.qubership.automation.itf.environments.util.validation.ECIValidationError;
import org.qubership.automation.itf.environments.util.validation.ValidationLevel;
import org.qubership.automation.itf.ui.controls.eci.EciEntityConstant;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.parents.UIIdentifiedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/eci"})
public class EciController {
    private static final Logger log = LoggerFactory.getLogger(EciController.class);
    private final Map<UUID, List<ECIValidationError>> errorsCache = ECIErrorsCache.getInstance().getErrorsCache().asMap();

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/project"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get ATP-Environments Project Id bound")
    public Set<String> getEcProjectId(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        HashSet<String> projects = new HashSet<String>();
        projects.addAll(((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(Environment.class)).getEcProjectIds(projectId));
        projects.addAll(((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(System.class)).getEcProjectIds(projectId));
        projects.addAll(((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(TransportConfiguration.class)).getEcProjectIds(projectId));
        return projects;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/bind"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Bind Entity with id {{#entityId}} to ATP-Environments Object id {{#ecId}} from project {{#ecProjectId}}")
    public UIResult bindEntityToEC(@RequestParam(value="id") BigInteger entityId, @RequestParam(value="class") EciEntityConstant entityClass, @RequestParam(value="ecId") String ecId, @RequestParam(value="ecName") String ecName, @RequestParam(value="ecProjectId") String ecProjectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        try {
            Class<? extends EciConfigurable> asClass = entityClass.getEntityClass();
            EciConfigurable storable = (EciConfigurable)CoreObjectManager.getInstance().getManager(asClass).getById((Object)entityId);
            storable.setEciParameters(ecId, ecProjectId);
            if (storable instanceof System) {
                ((System)storable).setEcLabel(ecName);
            }
            storable.store();
            log.info("Storable [id={}, name={}, type={}] was bound to EC[id={}, project={}]", new Object[]{storable.getID(), storable.getName(), entityClass, ecId, ecProjectId});
            return new UIResult(true, String.format("%s was bound to EC", asClass.getSimpleName()));
        }
        catch (Exception e) {
            log.error("Storable [id={}, type={}] was not bound to EC[id={}, project={}]. Exception: {}", new Object[]{entityId, entityClass, ecId, ecProjectId, e});
            return new UIResult(false, String.format("%s wasn't bound to EC", entityClass.getEntityClass().getSimpleName()));
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/update"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Entity with id {{#entityId}} from EC (type {{#entityClassName}}, parent id {{#entityParentId}})")
    public UIResult updateEntityFromEc(@RequestParam(value="entityId") BigInteger entityId, @RequestParam(value="parentId") BigInteger entityParentId, @RequestParam(value="className") EciEntityConstant entityClassName, @RequestBody(required=false) String entity, @RequestParam(value="projectUuid") UUID projectUuid) {
        try {
            Class<? extends EciConfigurable> entityClass = entityClassName.getEntityClass();
            ECEntity eciConfigurable = ParserFactory.getParser(entityClass).parse((Object)entity);
            if (!StringUtils.isEmpty((CharSequence)eciConfigurable.getEcId())) {
                Storable parent = entityClass.isAssignableFrom(TransportConfiguration.class) ? CoreObjectManager.managerFor(System.class).getById((Object)entityParentId) : CoreObjectManager.managerFor(Folder.class).getById((Object)entityParentId);
                this.convertAndStoreEntity((ECEntity<? extends EciConfigurable>)eciConfigurable, entityClass, parent);
                return new UIResult(true, String.format("%s was updated from EC", entityClass.getSimpleName()));
            }
            EciConfigurable storable = (EciConfigurable)CoreObjectManager.managerFor(entityClass).getById((Object)entityId);
            storable.unbindEntityWithHierarchy();
            storable.store();
            log.warn("Storable [id={}, name={}, type={}] was unbound from EC during update", new Object[]{storable.getID(), storable.getName(), entityClassName});
            UIResult warn = new UIResult();
            warn.setSuccess(false);
            warn.setMessage(String.format("%s was unbound from EC during update", entityClass.getSimpleName()));
            return warn;
        }
        catch (Exception e) {
            log.error("Storable [id={}, type={}] wasn't updated from EC. Exception: {}", new Object[]{entityId, entityClassName, e});
            return new UIResult(false, String.format("%s wasn't updated from EC", entityClassName.getEntityClass().getSimpleName()));
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/unbind"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Unbind Entities with type {{#entityClass}} from EC")
    public UIResult unbindEntityFromEC(@RequestBody UIIdentifiedObject[] objects, @RequestParam(value="entityClass") EciEntityConstant entityClassName, @RequestParam(value="projectUuid") UUID projectUuid) {
        try {
            Class<? extends EciConfigurable> entityClass = entityClassName.getEntityClass();
            for (UIIdentifiedObject object : objects) {
                EciConfigurable storable = (EciConfigurable)CoreObjectManager.getInstance().getManager(entityClass).getById((Object)object.getId());
                log.info("Storable [id={}, name={}, type={}] was unbound from EC[id={}, project={}]", new Object[]{storable.getID(), storable.getName(), entityClass, storable.getEcId(), storable.getEcProjectId()});
                storable.unbindEntityWithHierarchy();
                storable.store();
            }
            return new UIResult(true, String.format("%s was unbound from EC", entityClass.getSimpleName()));
        }
        catch (Exception e) {
            log.error("Unbinding was failed. Exception: {}", (Object)e.getMessage());
            return new UIResult(false, String.format("%s wasn't unbound from EC", entityClassName.getEntityClass().getSimpleName()));
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/upload/environments"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Upload Environments from EC from project {{#projectId}}/{{#projectUuid}}")
    public void uploadEnvironmentsFromEc(@RequestParam BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid, @RequestBody ECEnvironment[] ecEnvironments) {
        Folder environmentFolder = ((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)projectId)).getEnvironments();
        for (ECEnvironment ecEnvironment : ecEnvironments) {
            this.removeSystemWithoutItfParameters(ecEnvironment);
            this.fillEcProjectIdHierarchically(ecEnvironment);
            this.convertAndStoreEntity((ECEntity<? extends EciConfigurable>)ecEnvironment, ecEnvironment.getGenericType(), (Storable)environmentFolder);
        }
    }

    private void removeSystemWithoutItfParameters(ECEnvironment ecEnvironment) {
        List systems = ecEnvironment.getSystems();
        if (systems != null) {
            String systemNames = "";
            systems.removeIf(ecSystem -> ecSystem.getServer() == null || "".equals(ecSystem.getServer().getName()) || "".equals(ecSystem.getServer().getUrl()));
            for (ECSystem ecSystem2 : systems) {
                systemNames = systemNames + ecSystem2.getName() + ",";
            }
            if (!"".equals(systemNames)) {
                log.info("System(s) [{}] to be uploaded for the environment [name={}] from EC", (Object)systemNames, (Object)ecEnvironment.getName());
            } else {
                log.info("There is no systems to upload for the environment [name={}] from EC", (Object)ecEnvironment.getName());
            }
        } else {
            log.info("There is no systems under environment [name={}] from EC", (Object)ecEnvironment.getName());
        }
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/update/environments"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Environments from EC")
    public void updateEnvironmentsFromEc(@RequestBody ECEnvironment[] ecEnvironments, @RequestParam(value="projectUuid") UUID projectUuid) {
        this.updateEntitiesFromEc((ECEntity<? extends EciConfigurable>[])ecEnvironments);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/update/systems"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Systems from EC")
    public void updateSystemsFromEc(@RequestBody ECSystem[] ecSystems, @RequestParam(value="projectUuid") UUID projectUuid) {
        this.updateEntitiesFromEc((ECEntity<? extends EciConfigurable>[])ecSystems);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/update/transports"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Transports from EC")
    public void uploadTransportsFromEc(@RequestBody ECConnection[] ecConnections, @RequestParam(value="projectUuid") UUID projectUuid) {
        this.updateEntitiesFromEc((ECEntity<? extends EciConfigurable>[])ecConnections);
    }

    private void updateEntitiesFromEc(ECEntity<? extends EciConfigurable>[] ecEntities) {
        for (ECEntity<? extends EciConfigurable> ecEntity : ecEntities) {
            if (StringUtils.isEmpty((CharSequence)ecEntity.getEcId())) {
                ((EciConfigurable)CoreObjectManager.getInstance().getManager(ecEntity.getGenericType()).getById((Object)ecEntity.getSourceEntityId())).unbindEntityWithHierarchy();
                log.info("Storable [id={}, type={}] has become unbind from EC during updating", (Object)ecEntity.getSourceEntityId(), (Object)ecEntity.getGenericType());
                continue;
            }
            if (ecEntity instanceof ECEnvironment) {
                this.removeSystemWithoutItfParameters((ECEnvironment)ecEntity);
                this.fillEcProjectIdHierarchically((ECEnvironment)ecEntity);
            }
            this.convertAndStoreEntity(ecEntity, ecEntity.getGenericType(), CoreObjectManager.getInstance().getManager(ecEntity.getParentClass()).getById((Object)ecEntity.getSourceEntityParentId()));
        }
    }

    private void convertAndStoreEntity(ECEntity<? extends EciConfigurable> ecEntity, Class<? extends EciConfigurable> entityClass, Storable parent) {
        UUID eciSessionId = UUID.randomUUID();
        EciConfigurable convert = ConverterFactory.getConverter(entityClass).convert(ecEntity, parent, eciSessionId, new Object[0]);
        if (convert != null) {
            convert.store();
        }
        this.logUploadingResult(ecEntity.getName(), eciSessionId);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @GetMapping(value={"/get/byproject/{ecProjectId}"})
    @AuditAction(auditAction="Update Entities By EcProject")
    public UpdateEntitiesByEcProjectStructure updateEntitiesByEcProject(@PathVariable(value="ecProjectId") String ecProjectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        Collection environments = ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(Environment.class)).getByEcProjectId(ecProjectId);
        Collection systems = ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(System.class)).getByEcProjectId(ecProjectId);
        Collection transports = ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(TransportConfiguration.class)).getByEcProjectId(ecProjectId);
        ArrayList systemsInEnvs = Lists.newArrayList();
        ArrayList transportInSystem = Lists.newArrayList();
        for (Environment environment : environments) {
            for (System system : systems) {
                if (environment.getInbound().get(system) != null || environment.getOutbound().get(system) != null) {
                    systemsInEnvs.add(system);
                }
                Set systemTransports = system.getTransports();
                for (TransportConfiguration transport : transports) {
                    if (systemTransports.stream().filter(systemTransport -> systemTransport.getID().equals(transport.getID())).findAny().orElse(null) == null) continue;
                    transportInSystem.add(transport);
                }
                if (transportInSystem.isEmpty()) continue;
                transports.removeAll(transportInSystem);
                transportInSystem.clear();
            }
            if (systemsInEnvs.isEmpty()) continue;
            systems.removeAll(systemsInEnvs);
            systemsInEnvs.clear();
        }
        HashMap entitiesForUpdate = Maps.newHashMap();
        entitiesForUpdate.put("environments", environments.stream().map(x$0 -> new EciRequestObject((EciConfigurable)x$0)).collect(Collectors.toSet()));
        entitiesForUpdate.put("systems", systems.stream().map(x$0 -> new EciRequestObject((EciConfigurable)x$0)).collect(Collectors.toSet()));
        entitiesForUpdate.put("transports", transports.stream().map(x$0 -> new EciRequestObject((EciConfigurable)x$0)).collect(Collectors.toSet()));
        return new UpdateEntitiesByEcProjectStructure(UUID.fromString(ecProjectId), entitiesForUpdate);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/unbind/byproject/{ecProjectId}"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Unbind Entities By EcProject")
    public void unbindEntitiesByEcProject(@PathVariable(value="ecProjectId") String ecProjectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(Environment.class)).unbindByEcProject(ecProjectId);
        ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(System.class)).unbindByEcProject(ecProjectId);
        ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(TransportConfiguration.class)).unbindByEcProject(ecProjectId);
        ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(OutboundTransportConfiguration.class)).unbindByEcProject(ecProjectId);
        ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(InboundTransportConfiguration.class)).unbindByEcProject(ecProjectId);
        ((EnvConfigurationManager)CoreObjectManager.getInstance().getManager(Server.class)).unbindByEcProject(ecProjectId);
        log.info("Entities under EC-project have become unbind: {}", (Object)ecProjectId);
    }

    private void logUploadingResult(String entityName, UUID eciSessionId) {
        List<ECIValidationError> errorsList = this.errorsCache.get(eciSessionId);
        if (errorsList != null) {
            for (ECIValidationError eciValidationError : errorsList) {
                if (eciValidationError.getValidationLevel().equals((Object)ValidationLevel.ERROR)) {
                    log.error("{} was uploaded with next error: {}", (Object)entityName, (Object)eciValidationError.getError());
                    continue;
                }
                log.warn("{} was uploaded with next warning: {}", (Object)entityName, (Object)eciValidationError.getError());
            }
            this.errorsCache.remove(eciSessionId);
        } else {
            log.info("Uploading of {} from Environment Configurator has been completed successfully.", (Object)entityName);
        }
    }

    private void fillEcProjectIdHierarchically(ECEnvironment ecEnvironment) {
        String ecProjectId = ecEnvironment.getEcProjectId();
        for (ECSystem ecSystem : ecEnvironment.getSystems()) {
            ecSystem.setEcProjectId(ecProjectId);
            for (ECConnection ecConnection : ecSystem.getConnections()) {
                ecConnection.setEcProjectId(ecProjectId);
            }
        }
    }

    private class EciRequestObject {
        private UUID id;
        private String parentId;
        private String sourceEntityId;

        public EciRequestObject(EciConfigurable eciConfigurable) {
            this.id = UUID.fromString(eciConfigurable.getEcId());
            this.parentId = eciConfigurable.getParent().getID().toString();
            this.sourceEntityId = eciConfigurable.getID().toString();
        }

        public UUID getId() {
            return this.id;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getSourceEntityId() {
            return this.sourceEntityId;
        }

        public void setSourceEntityId(String sourceEntityId) {
            this.sourceEntityId = sourceEntityId;
        }
    }

    private class UpdateEntitiesByEcProjectStructure {
        private UUID ecProjectId;
        private Map<String, Set<EciRequestObject>> entities;

        public UpdateEntitiesByEcProjectStructure(UUID ecProjectId, Map<String, Set<EciRequestObject>> entities) {
            this.ecProjectId = ecProjectId;
            this.entities = entities;
        }

        public UUID getEcProjectId() {
            return this.ecProjectId;
        }

        public void setEcProjectId(UUID ecProjectId) {
            this.ecProjectId = ecProjectId;
        }

        public Map<String, Set<EciRequestObject>> getEntities() {
            return this.entities;
        }

        public void setEntities(Map<String, Set<EciRequestObject>> entities) {
            this.entities = entities;
        }
    }
}

