/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.environment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.assertj.core.util.Lists;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.EnvironmentManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.EnvironmentObjectManager;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.CoreObjectManagerService;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.environment.InboundInfo;
import org.qubership.automation.itf.ui.messages.objects.environment.TransportInfo;
import org.qubership.automation.itf.ui.messages.objects.environment.UIServerInbound;
import org.qubership.automation.itf.ui.messages.objects.transport.UIInboundConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UITriggerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tags(value={@Tag(name="Environment trigger queries API.", description="Environment trigger API to query environment trigger. Called through REST."), @Tag(name="Environment trigger commands API.", description="Environment trigger API to control environment trigger. Called through REST.")})
public class EnvironmentSwitchController
extends ControllerHelper {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentSwitchController.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"environment/status"}, method={RequestMethod.GET})
    @Operation(summary="GetEnvironmentState", description="Retrieve environment status by id", tags={"Environment trigger queries API."})
    public String getStatus(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        Environment environment = this.updateEnvStateFromDb(id);
        return "{ \"state\" : \"" + environment.getEnvironmentState().toString() + "\", \"result\" : \"success\" }";
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/environment/inbound/info"}, method={RequestMethod.GET})
    @Operation(summary="GetEnvironmentInfo", description="Retrieve environment info by id", tags={"Environment trigger queries API."})
    public Map<String, Object> getInboundInfo(@RequestParam(value="id", defaultValue="0") BigInteger id, @RequestParam(value="projectUuid") UUID projectUuid) throws JsonProcessingException {
        ArrayList<UIServerInbound> uiInbounds = new ArrayList<UIServerInbound>();
        for (String info : ((EnvironmentManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentManager.class)).getInboundInfo(id)) {
            InboundInfo inboundInfo = (InboundInfo)this.objectMapper.readValue(info, InboundInfo.class);
            UIServerInbound serverInbound = new UIServerInbound();
            serverInbound.setName(inboundInfo.getSystemServer());
            ArrayList uiInboundConfigurations = Lists.newArrayList();
            for (TransportInfo transportInfo : inboundInfo.getTransports()) {
                UIInboundConfiguration uiInboundConfiguration = new UIInboundConfiguration();
                UIObject uiTransport = new UIObject();
                uiTransport.setName(transportInfo.getTransportName());
                uiInboundConfiguration.setTransport(uiTransport);
                ArrayList triggerConfigurations = Lists.newArrayList();
                transportInfo.getTriggers().stream().filter(uiTriggerInfo -> uiTriggerInfo.getTriggerId() != null).forEach(uiTriggerInfo -> {
                    UITriggerConfiguration triggerConfiguration = new UITriggerConfiguration();
                    triggerConfiguration.setName(uiTriggerInfo.getTriggerName());
                    triggerConfiguration.setState(TriggerState.fromString((String)uiTriggerInfo.getTriggerState()).getState());
                    triggerConfigurations.add(triggerConfiguration);
                });
                uiInboundConfiguration.setTriggers(triggerConfigurations);
                uiInboundConfigurations.add(uiInboundConfiguration);
            }
            serverInbound.setConfigurations(uiInboundConfigurations);
            uiInbounds.add(serverInbound);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("inboundsInfo", uiInbounds);
        return result;
    }

    private Environment updateEnvStateFromDb(@Nonnull String objectId) {
        CoreObjectManagerService objectManagerService = CoreObjectManager.getInstance();
        TriggerState stateFromDb = TriggerState.fromString((String)((EnvironmentObjectManager)objectManagerService.getSpecialManager(Environment.class, EnvironmentObjectManager.class)).getEnvironmentStateById(objectId));
        Environment environment = (Environment)objectManagerService.getManager(Environment.class).getById((Object)objectId);
        if (Objects.nonNull(environment) && !stateFromDb.equals((Object)environment.getEnvironmentState())) {
            environment.setEnvironmentState(stateFromDb);
            environment.store();
        }
        return environment;
    }
}

