/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.server;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.json.simple.JSONObject;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchByProjectIdManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.TriggerSample;
import org.qubership.automation.itf.core.model.communication.message.ServerTriggerSyncRequest;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.entities.util.ConfigurationControllerHelper;
import org.qubership.automation.itf.ui.controls.entities.util.ResponseCacheHelper;
import org.qubership.automation.itf.ui.controls.service.integration.ItfStubsRequestsService;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.environment.UIServerInbound;
import org.qubership.automation.itf.ui.messages.objects.environment.UIServerOutbound;
import org.qubership.automation.itf.ui.messages.objects.transport.UIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIInboundConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;
import org.qubership.automation.itf.ui.messages.objects.transport.UITriggerConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tags(value={@Tag(name="Server configuration queries API.", description="Server configuration API to query server configuration. Called through REST."), @Tag(name="Server configuration commands API.", description="Server configuration API to control server configuration. Called through REST.")})
public class ServerConfigurationController {
    private static final String INBOUND = "inbound";
    private static final String OUTBOUND = "outbound";
    private final ConfigurationControllerHelper configurationControllerHelper;
    private final ItfStubsRequestsService itfStubsRequestsService;
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;

    @Transactional(readOnly=true)
    @Modifying
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/server/outbound"}, method={RequestMethod.GET})
    @Operation(summary="GetOutbound", description="Retrieve outbound for system by server id, system id", tags={"Server configuration queries API."})
    @AuditAction(auditAction="Get all Outbounds for System id {{#systemId}} and Server id {{#serverId}} in the project {{#projectUuid}}")
    public UIServerOutbound getOutboundForSystem(@RequestParam(value="serverId", defaultValue="0") String serverId, @RequestParam(value="systemId", defaultValue="0") String systemId, @RequestParam(value="projectUuid") UUID projectUuid) {
        String operation = "retrieve outbound for system by server id, system id";
        Server server = (Server)this.getAndCheckObject(serverId, Server.class, operation);
        System system = (System)this.getAndCheckObject(systemId, System.class, operation);
        UIServerOutbound serverOutbound = new UIServerOutbound(server);
        serverOutbound.defineSystem(system);
        serverOutbound.defineConfiguration(server.getOutbounds(system));
        return serverOutbound;
    }

    @Transactional(readOnly=true)
    @Modifying
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/server/inbound"}, method={RequestMethod.GET})
    @Operation(summary="GetInbound", description="Retrieve inbound for system by server id, system id", tags={"Server configuration queries API."})
    @AuditAction(auditAction="Get all Inbounds for System id {{#systemId}} and Server id {{#serverId}} in the project {{#projectUuid}}")
    public UIServerInbound getInboundForSystem(@RequestParam(value="serverId", defaultValue="0") String serverId, @RequestParam(value="systemId", defaultValue="0") String systemId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        String operation = "retrieve inbound for system by server id, system id";
        Server server = (Server)this.getAndCheckObject(serverId, Server.class, operation);
        System system = (System)this.getAndCheckObject(systemId, System.class, operation);
        UIServerInbound serverInbound = new UIServerInbound(server);
        serverInbound.defineSystem(system);
        serverInbound.defineConfiguration(server.getInbounds(system));
        return serverInbound;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/server/outbound"}, method={RequestMethod.PUT})
    @Operation(summary="SetOutbound", description="Set outbound for system by server id, system id", tags={"Server configuration commands API."})
    @AuditAction(auditAction="Setup Outbounds for System id {{#systemId}} and Server id {{#serverId}} in the project {{#projectUuid}}")
    public void setupOutbound(@RequestParam(value="serverId", defaultValue="0") String serverId, @RequestParam(value="systemId", defaultValue="0") String systemId, @RequestBody UIServerOutbound serverOutbound, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        String operation = "set outbound for system by server id, system id";
        Server server = (Server)this.getAndCheckObject(serverId, Server.class, operation);
        System system = (System)this.getAndCheckObject(systemId, System.class, operation);
        server.setUrl(serverOutbound.getUrl());
        if (serverOutbound.getConfigurations() != null) {
            for (UIConfiguration uiConfiguration : serverOutbound.getConfigurations()) {
                OutboundTransportConfiguration configuration = server.getOutbound(system, uiConfiguration.getType());
                if ("Outbound REST Synchronous".equals(uiConfiguration.getUserTypeName()) || "Outbound SOAP Over HTTP Synchronous".equals(uiConfiguration.getUserTypeName())) {
                    ResponseCacheHelper.beforeUpdatedForRestAndSoapTransport((Configuration)configuration, uiConfiguration, projectId);
                }
                for (UIProperty uiProperty : uiConfiguration.getProperties()) {
                    this.configurationControllerHelper.setProperty((Configuration)configuration, uiProperty, projectUuid);
                }
            }
        }
        server.store();
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/server/inbound"}, method={RequestMethod.PUT})
    @Operation(summary="SetInbound", description="Set inbound for system by server id, system id", tags={"Server configuration commands API."})
    @AuditAction(auditAction="Setup Inbounds for System id {{#systemId}} and Server id {{#serverId}} in the project {{#projectUuid}}")
    public ServerTriggerSyncRequest setupInbound(@RequestParam(value="serverId", defaultValue="0") String serverId, @RequestParam(value="systemId", defaultValue="0") String systemId, @RequestParam(value="quickSave", defaultValue="false") boolean quickSave, @RequestBody UIServerInbound serverInbound, @RequestParam(value="projectUuid") UUID projectUuid) throws Exception {
        ServerTriggerSyncRequest serverTriggerSyncRequest = new ServerTriggerSyncRequest();
        String operation = "set inbound for system by server id, system id";
        Server server = (Server)this.getAndCheckObject(serverId, Server.class, operation);
        System system = (System)this.getAndCheckObject(systemId, System.class, operation);
        server.setUrl(serverInbound.getUrl());
        Collection inbound = server.getInbounds(system);
        if (serverInbound.getConfigurations() != null) {
            for (UIInboundConfiguration configuration : serverInbound.getConfigurations()) {
                for (InboundTransportConfiguration entry : inbound) {
                    if (!entry.getReferencedConfiguration().getID().toString().equals(configuration.getTransport().getId())) continue;
                    for (UIProperty property : configuration.getProperties()) {
                        if ("Overridden".equals(property.getOverridden()) || "Edited".equals(property.getOverridden())) {
                            this.configurationControllerHelper.setProperty((Configuration)entry, property, projectUuid);
                            continue;
                        }
                        entry.remove((Object)property.getName());
                    }
                    serverTriggerSyncRequest = this.synchronizeTriggers((Collection<UITriggerConfiguration>)configuration.getTriggers(), entry, quickSave, projectUuid);
                }
            }
        }
        server.store();
        return serverTriggerSyncRequest;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"server/checkSystemServerDuplications"}, method={RequestMethod.GET})
    @Operation(summary="CheckDuplicates", description="Check for System-Server duplicates", tags={"Server configuration queries API."})
    @AuditAction(auditAction="Check System+Server duplicates under Environments in the project {{projectId}}/{{#projectUuid}}")
    public String checkSystemServerDuplications(@RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        JSONObject result = new JSONObject();
        StringBuilder res = new StringBuilder();
        Collection environments = ((SearchByProjectIdManager)CoreObjectManager.getInstance().getSpecialManager(Environment.class, SearchByProjectIdManager.class)).getByProjectId(projectId);
        for (Environment env1 : environments) {
            for (Environment env2 : environments) {
                if (env1.getID() == env2.getID()) continue;
                res.append(this.findDuplications(env1, env2, INBOUND));
                res.append(this.findDuplications(env1, env2, OUTBOUND));
            }
        }
        result.put((Object)"info", (Object)res.toString());
        return result.toJSONString();
    }

    private Storable getAndCheckObject(String objectId, Class clazz, String operation) {
        Storable obj = ControllerHelper.getManager(clazz).getById((Object)objectId);
        ControllerHelper.throwExceptionIfNull(obj, "", objectId, clazz, operation);
        return obj;
    }

    private String findDuplications(Environment env1, Environment env2, String type) {
        Set env2Entry;
        Iterator iterator;
        StringBuilder result = new StringBuilder();
        if (INBOUND.equals(type)) {
            iterator = env1.getInbound().entrySet().iterator();
            env2Entry = env2.getInbound().entrySet();
        } else {
            iterator = env1.getOutbound().entrySet().iterator();
            env2Entry = env2.getOutbound().entrySet();
        }
        while (iterator.hasNext()) {
            Map.Entry pair = iterator.next();
            if (!env2Entry.contains(pair)) continue;
            result.append(env2.getName()).append(" has duplicated System/Server pair: ").append(pair.getKey()).append(" - ").append(pair.getValue()).append(";<br><br>");
        }
        return result.toString();
    }

    private ServerTriggerSyncRequest synchronizeTriggers(Collection<UITriggerConfiguration> uiTriggers, InboundTransportConfiguration parent, boolean quickSaveMode, UUID projectUuid) {
        ServerTriggerSyncRequest serverTriggerSyncRequest = new ServerTriggerSyncRequest();
        if (uiTriggers != null) {
            serverTriggerSyncRequest.getTriggerIdToDeactivate().addAll(this.deleteMissedTriggers(uiTriggers, parent, projectUuid));
            this.addNewTriggers(uiTriggers, parent, projectUuid);
            serverTriggerSyncRequest.getTriggerIdToReactivate().addAll(this.updateExistingTriggers(uiTriggers, parent, quickSaveMode, projectUuid));
        }
        return serverTriggerSyncRequest;
    }

    private List<TriggerSample> deleteMissedTriggers(Collection<UITriggerConfiguration> uiTriggers, InboundTransportConfiguration parent, UUID projectUuid) {
        ArrayList<TriggerSample> triggerSamples = new ArrayList<TriggerSample>();
        Collection triggersToDelete = Collections2.filter((Collection)parent.getTriggerConfigurations(), input -> {
            String idstr = Objects.toString(input.getID());
            for (UITriggerConfiguration uiEventTrigger : uiTriggers) {
                if (uiEventTrigger.getId() == null || !uiEventTrigger.getId().equals(idstr)) continue;
                return false;
            }
            return true;
        });
        for (TriggerConfiguration trigger : triggersToDelete) {
            triggerSamples.add(this.itfStubsRequestsService.createTriggerSample(trigger, projectUuid));
            trigger.remove();
            CoreObjectManager.managerFor(TriggerConfiguration.class).remove((Storable)trigger, true);
        }
        Lists.newArrayList((Iterable)triggersToDelete).forEach(parent.getTriggerConfigurations()::remove);
        return triggerSamples;
    }

    private void addNewTriggers(Collection<UITriggerConfiguration> uiTriggers, InboundTransportConfiguration parent, UUID projectUuid) {
        Collection triggersToAdd = Collections2.filter(uiTriggers, input -> Strings.isNullOrEmpty((String)input.getId()));
        for (UITriggerConfiguration uiTrigger : triggersToAdd) {
            TriggerConfiguration trigger = new TriggerConfiguration(parent);
            this.setTriggerParameters(trigger, uiTrigger, projectUuid);
            trigger.store();
            parent.getTriggerConfigurations().add(trigger);
        }
    }

    private List<TriggerSample> updateExistingTriggers(Collection<UITriggerConfiguration> uiTriggers, InboundTransportConfiguration parent, boolean quickSaveMode, UUID projectUuid) {
        ArrayList<TriggerSample> triggerSamples = new ArrayList<TriggerSample>();
        Collection triggersToModify = Collections2.filter(uiTriggers, input -> !Strings.isNullOrEmpty((String)input.getId()));
        for (UITriggerConfiguration uiTrigger : triggersToModify) {
            for (TriggerConfiguration trigger : parent.getTriggerConfigurations()) {
                if (!trigger.getID().toString().equals(uiTrigger.getId())) continue;
                this.setTriggerParameters(trigger, uiTrigger, projectUuid);
                triggerSamples.add(this.itfStubsRequestsService.createTriggerSample(trigger, projectUuid));
            }
        }
        return triggerSamples;
    }

    private void setTriggerParameters(TriggerConfiguration trigger, UITriggerConfiguration uiTrigger, UUID projectUuid) {
        trigger.setName(uiTrigger.getName());
        if (trigger.getID() == null) {
            trigger.setState(TriggerState.INACTIVE);
        }
        for (UIProperty property : uiTrigger.getProperties()) {
            if ("Overridden".equals(property.getOverridden()) || "Edited".equals(property.getOverridden())) {
                this.configurationControllerHelper.setProperty((Configuration)trigger, property, projectUuid);
                continue;
            }
            trigger.remove((Object)property.getName());
        }
    }

    @ConstructorProperties(value={"configurationControllerHelper", "itfStubsRequestsService"})
    public ServerConfigurationController(ConfigurationControllerHelper configurationControllerHelper, ItfStubsRequestsService itfStubsRequestsService) {
        this.configurationControllerHelper = configurationControllerHelper;
        this.itfStubsRequestsService = itfStubsRequestsService;
    }
}

