/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.entities.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.ServerObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.message.delete.DeleteEntityResultMessage;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.common.AbstractController;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.UIIds;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.environment.UIServer;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServerController
extends AbstractController<UIServer, Server> {
    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/server/all"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Servers from project {{#projectUuid}}")
    public List<? extends UIObject> getAll(@RequestParam(value="projectUuid") UUID projectUuid) {
        return super.getAll();
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/server/allbyparent"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Servers in Folder by id {{#parentId}} in the project {{#projectUuid}}")
    public List<? extends UIObject> getAll(@RequestParam(value="parentId", defaultValue="0") String parentId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return super.getAll(parentId);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/server"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Server by id {{#id}} in the project {{#projectUuid}}")
    public UIServer getById(@RequestParam(value="id", defaultValue="0") String id, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UIServer)super.getById(id);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"CREATE\")")
    @RequestMapping(value={"/server"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Create Server under Folder id {{#parentId}} in the project {{#projectId}}/{{#projectUuid}}")
    public UIServer create(@RequestParam(value="parent", defaultValue="0") String parentId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        return (UIServer)super.create(parentId, projectId);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"CREATE\")")
    @RequestMapping(value={"/server/duplicate"}, method={RequestMethod.POST})
    @AuditAction(auditAction="Copy Servers in the project {{#projectId}}/{{#projectUuid}}")
    public ArrayList<UIServer> create(@RequestParam(value="parent", defaultValue="0") String parentId, @RequestBody ArrayList<UIServer> uiServerSources, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        ArrayList<UIServer> uiServerDests = new ArrayList<UIServer>();
        for (UIServer uiServerSource : uiServerSources) {
            UIServer serverDest = (UIServer)super.create(uiServerSource.getParent().getId(), projectId);
            serverDest.setName(uiServerSource.getName().concat(" copy"));
            serverDest.setUrl(uiServerSource.getUrl());
            uiServerDests.add(super.update(serverDest));
        }
        return uiServerDests;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/server"}, method={RequestMethod.PUT})
    @AuditAction(auditAction="Update Server by id {{#uiServer.id}} in the project {{#projectUuid}}")
    public UIServer update(@RequestBody UIServer uiServer, @RequestParam(value="projectUuid") UUID projectUuid) {
        return super.update(uiServer);
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"UPDATE\")")
    @RequestMapping(value={"/server"}, method={RequestMethod.DELETE})
    @AuditAction(auditAction="Delete Servers from Project {{#projectUuid}}")
    public DeleteEntityResultMessage<String, UIObject> delete(@RequestParam(value="ignoreUsages", defaultValue="false") Boolean ignoreUsages, @RequestBody UIIds ids, @RequestParam(value="projectUuid") UUID projectUuid) {
        HashMap serversWithTriggers = new HashMap();
        HashMap<String, String> usingServers = new HashMap<String, String>();
        for (String id : ids.getIds()) {
            Server server = (Server)ControllerHelper.getManager(Server.class).getById((Object)id);
            ControllerHelper.throwExceptionIfNull((Storable)server, "", id, Server.class, "delete server(s)");
            ArrayList<UIObject> triggers = new ArrayList<UIObject>();
            Map blockingTriggers = ControllerHelper.getManager(Server.class).findImportantChildren((Storable)server);
            if (blockingTriggers != null && !blockingTriggers.isEmpty() && blockingTriggers.containsKey("TransportTriggers")) {
                for (BigInteger triggerId : (List)blockingTriggers.get("TransportTriggers")) {
                    UIObject uiObject = new UIObject();
                    uiObject.setId(triggerId.toString());
                    uiObject.setClassName("TransportTrigger");
                    triggers.add(uiObject);
                }
            }
            if (!triggers.isEmpty()) {
                serversWithTriggers.put(server.getID().toString(), triggers);
                continue;
            }
            Collection usageInfo = ControllerHelper.getManager(Server.class).remove((Storable)server, ignoreUsages.booleanValue());
            if (usageInfo == null) continue;
            usingServers.put(server.getID().toString(), this.usageInfoListAsString(usageInfo));
        }
        return new DeleteEntityResultMessage(serversWithTriggers, usingServers);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @RequestMapping(value={"/server/usages"}, method={RequestMethod.POST})
    public Map<String, Object> getUsages(@RequestParam(value="projectUuid") UUID projectUuid, @RequestBody UIIds uiServersObj) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        HashSet<String> environments = new HashSet<String>();
        for (String serverId : uiServersObj.getIds()) {
            Server server = (Server)ControllerHelper.getManager(Server.class).getById((Object)serverId);
            Collection usages = server.findUsages();
            for (UsageInfo usage : usages) {
                environments.add(String.valueOf(usage.getReferer().getID()));
            }
        }
        res.put("usages", environments);
        return res;
    }

    @Transactional
    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"DELETE\")")
    @RequestMapping(value={"/server/deleteUnusedOutboundConfigurations"}, method={RequestMethod.DELETE})
    public UIResult deleteUnusedConfigurationByProjectId(@RequestParam(value="projectId") BigInteger projectId) {
        try {
            int deletedCount = ((ServerObjectManager)CoreObjectManager.getInstance().getSpecialManager(Server.class, ServerObjectManager.class)).deleteUnusedOutboundConfigurationsByProjectId(projectId);
            return new UIResult(true, String.format("%s rows are deleted", deletedCount));
        }
        catch (Exception ex) {
            return new UIResult(false, String.format("Deleting isn't performed due to error: %s", ex.getMessage()));
        }
    }

    @Override
    protected Server _beforeUpdate(UIServer uiServer, Server server) {
        server.setUrl(uiServer.getUrl());
        return super._beforeUpdate(uiServer, server);
    }

    @Override
    protected Class<Server> _getGenericUClass() {
        return Server.class;
    }

    @Override
    protected UIServer _newInstanceTClass(Server object) {
        return new UIServer(object);
    }

    @Override
    protected Storable _getParent(String parentId) {
        return ControllerHelper.getManager(Folder.class).getById((Object)parentId);
    }
}

