/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.files;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.automation.itf.core.util.eds.model.UIFileInfo;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.qubership.automation.itf.ui.controls.files.FileManagerService;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.qubership.automation.itf.ui.messages.objects.file.TreeNode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FileManagerController {
    private final FileManagerService fileManagerService;

    public FileManagerController(FileManagerService fileManagerService) {
        this.fileManagerService = fileManagerService;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/files/path"})
    public TreeNode[] getPathTreeNode(@RequestParam UUID projectUuid) {
        return this.fileManagerService.getPathTreeNode(projectUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @GetMapping(value={"/files/byPath"})
    public Set<UIFileInfo> getFilesByPath(@RequestParam String filePath, @RequestParam EdsContentType contentType, @RequestParam UUID projectUuid) {
        return this.fileManagerService.getFilesByPath(filePath, contentType, projectUuid);
    }

    @PreAuthorize(value="@entityAccess.isSupport() or @entityAccess.isAdmin()")
    @DeleteMapping(value={"/files/remove"})
    public UIResult remove(@RequestBody List<UIFileInfo> filesInfo, @RequestParam UUID projectUuid, @RequestHeader(value="X-Project-Id") String tenantId) throws IOException {
        return this.fileManagerService.remove(filesInfo, projectUuid, tenantId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\") and !T(org.qubership.automation.itf.core.util.eds.service.EdsContentType).KEYSTORE.equals(#contentType)")
    @GetMapping(value={"/file/content"})
    public UIResult getContent(@RequestParam EdsContentType contentType, @RequestParam String filePath, @RequestParam String fileName, @RequestParam UUID projectUuid) {
        return this.fileManagerService.getContent(contentType, filePath, fileName, projectUuid);
    }
}

