/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.diameter;

import java.math.BigInteger;
import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.diameter.config.DiameterParserType;
import org.qubership.automation.itf.core.message.DictionaryReloadMessage;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.ui.messages.objects.UIResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DiameterTransportController {
    private static final Logger log = LoggerFactory.getLogger(DiameterTransportController.class);
    private ExecutorToMessageBrokerSender executorToMessageBrokerSender;

    @Autowired
    public void setExecutorToMessageBrokerSender(ExecutorToMessageBrokerSender executorToMessageBrokerSender) {
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectUuid, \"READ\")")
    @PostMapping(value={"/forceDictionaryReload"})
    @AuditAction(auditAction="Force dictionary reload for transport id {{#transport}}, parser {{#parser}} in the project {{#project}}/{{#projectUuid}}")
    public UIResult forceDictionaryReload(@RequestParam(value="transport") BigInteger transport, @RequestParam(value="parser") String parser, @RequestParam(value="project") BigInteger project, @RequestParam(value="projectUuid") UUID projectUuid, @RequestHeader(value="X-Project-Id") String tenantId) {
        String dictionaryPath = ((TransportConfiguration)CoreObjectManager.getInstance().getManager(TransportConfiguration.class).getById((Object)transport)).get((Object)"configPath");
        Class parserClass = DiameterParserType.defineParserClass((String)parser);
        this.executorToMessageBrokerSender.sendMessageToSyncReloadDictionaryTopic((Object)new DictionaryReloadMessage(dictionaryPath, parserClass, project), tenantId);
        return new UIResult(true, String.format("Diameter dictionary is successfully reloaded from path: %s\n Parser: %s", dictionaryPath, parserClass.getSimpleName()));
    }
}

