/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.service.token;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Base64;
import org.apache.commons.lang.NotImplementedException;
import org.qubership.automation.itf.ui.controls.service.token.TokenGeneratorRequest;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tags(value={@Tag(name="Token generator commands API.", description="Service used for generating authentication tokens by provided user-password pair.")})
public class TokenGeneratorService {
    @RequestMapping(value={"/service/token"}, method={RequestMethod.POST})
    @Operation(summary="GenerateToken", description="Generate token of chosen type based on username/password pair. Generated token can be used in further requests to authorize them by putting the token to the \"Authorization\" header in request. Supported token types: Basic.", tags={"Token generator commands API."})
    public String generateToken(@RequestBody TokenGeneratorRequest tokenGeneratorRequest) {
        return this.generateTokenFromRequest(tokenGeneratorRequest);
    }

    private String generateTokenFromRequest(TokenGeneratorRequest tokenGeneratorRequest) {
        TokenGeneratorRequest.TokenType tokenType = TokenGeneratorRequest.TokenType.fromText(tokenGeneratorRequest.getTokenType());
        switch (tokenType) {
            case BASIC: {
                return tokenType.prefix() + " " + Base64.getEncoder().encodeToString((tokenGeneratorRequest.getUsername() + ":" + tokenGeneratorRequest.getPassword()).getBytes());
            }
            case JWT: {
                throw new NotImplementedException("JWT token generation is no supported");
            }
        }
        throw new IllegalArgumentException("Unknown token type exception");
    }
}

