/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.tree;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.math.NumberUtils;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.ui.controls.tree.TreeBuilder;
import org.qubership.automation.itf.ui.controls.util.ControllerConstants;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.tree.UITreeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeBuilder<C extends Storable, P extends Storable>
extends ControllerHelper
implements TreeBuilder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractTreeBuilder.class);
    private static final Predicate<Map.Entry<Object, UITreeElement>> PREDICATE = entry -> !((UITreeElement)entry.getValue()).isRoot();

    @Override
    public UITreeData buildTree(Storable node) {
        UITreeElement currentItem = null;
        UITreeData treeData = new UITreeData();
        Storable parentFolder = null;
        if (this.getParentClass().isAssignableFrom(node.getClass())) {
            parentFolder = node;
        } else if (this.getChildClass().isAssignableFrom(node.getClass())) {
            parentFolder = this.getParentFolder(node);
        }
        while (parentFolder != null) {
            UITreeElement treeElement = this.fillFolder(parentFolder);
            if (currentItem != null) {
                treeElement.getChildren().remove(currentItem);
                treeElement.getChildren().add(currentItem);
            }
            parentFolder = this.getParentFolder(parentFolder);
            currentItem = treeElement;
        }
        if (currentItem != null) {
            treeData.setTreeData(currentItem.getChildren());
        }
        return treeData;
    }

    public UITreeData buildTreeByFilter(Collection<Storable> storables) {
        HashMap uiTreeElementMap = Maps.newHashMap();
        UITreeData treeData = new UITreeData();
        storables.forEach(storable -> {
            UITreeElement elem = new UITreeElement((Storable)storable);
            if (this.getParentClass().isAssignableFrom(storable.getClass())) {
                elem.setIsFolder(true);
            } else if (this.getChildClass().isAssignableFrom(storable.getClass())) {
                elem.setIsFolder(false);
            }
            if (storable instanceof EciConfigurable) {
                elem.setEcId(((EciConfigurable)storable).getEcId());
            }
            this.putUITreeElementAndParents(uiTreeElementMap, elem);
        });
        return this.buildTreeStructure(uiTreeElementMap, treeData);
    }

    public UITreeData buildTreeById(UIObject uiObject) {
        HashMap uiTreeElementMap = Maps.newHashMap();
        UITreeData treeData = new UITreeData();
        this.putUITreeElementAndParents(uiTreeElementMap, new UITreeElement(uiObject, false));
        return this.buildTreeStructure(uiTreeElementMap, treeData);
    }

    public UITreeData buildTreeStructure(Map<Object, UITreeElement> uiTreeElementMap, UITreeData treeData) {
        for (Map.Entry<Object, UITreeElement> treeElementEntry : uiTreeElementMap.entrySet()) {
            UITreeElement value = treeElementEntry.getValue();
            if (Objects.isNull(value.getParent())) {
                value.setRoot(true);
            } else {
                uiTreeElementMap.get(value.getParent().getId()).addChild(value);
            }
            value.setExpanded(true);
            value.setParent(null);
            value.setFolder(null);
        }
        uiTreeElementMap.entrySet().removeIf(PREDICATE);
        if (uiTreeElementMap.isEmpty()) {
            return treeData;
        }
        treeData.setTreeData(((UITreeElement)((Map.Entry)uiTreeElementMap.entrySet().stream().findFirst().get()).getValue()).getChildren());
        return treeData;
    }

    @Nullable
    private Storable getParentFolder(Storable node) {
        Storable parent = node.getParent();
        return parent;
    }

    abstract UITreeElement fillFolder(Storable var1);

    abstract Class<P> getParentClass();

    abstract Class<C> getChildClass();

    @Override
    public void configureObject(UITreeElement treeElement, Storable storable) {
        if (storable == null) {
            return;
        }
        treeElement.setId(storable.getID().toString());
        treeElement.setName(storable.getName());
        treeElement.setDescription(storable.getDescription());
        if (storable.getParent() != null) {
            treeElement.setParent(new UIObject(storable.getParent()));
        }
        if (storable instanceof LabeledStorable) {
            treeElement.setLabels(((LabeledStorable)storable).getLabels());
        }
        if (storable instanceof EciConfigurable) {
            treeElement.setEcId(((EciConfigurable)storable).getEcId());
        }
        treeElement.setClassName(storable.getClass().getName());
        treeElement.setIsFolder(this.getParentClass().isAssignableFrom(storable.getClass()));
        treeElement.setVersion(NumberUtils.toInt((String)String.valueOf(storable.getVersion()), (int)-1));
    }

    @Override
    public <T extends Storable> void addSubElements(UITreeElement currentFolder, Collection<T> objects) {
        for (Storable storable : objects) {
            UITreeElement object = new UITreeElement();
            this.configureObject(object, storable);
            if (this.getParentClass().isAssignableFrom(storable.getClass())) {
                object.setIsFolder(true);
            }
            if (currentFolder.getChildren().contains(object)) continue;
            currentFolder.addChild(object);
        }
    }

    private void putUITreeElementAndParents(Map<Object, UITreeElement> uiTreeElementMap, UITreeElement uiTreeElement) {
        uiTreeElementMap.put(uiTreeElement.getId(), uiTreeElement);
        if (uiTreeElement.getParent() != null) {
            this.putUITreeElementAndParents(uiTreeElementMap, new UITreeElement(uiTreeElement.getParent(), true));
        }
    }

    public Collection<Storable> getAllLabeledByPieceOfName(String value, Collection<Storable> objects) {
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)ControllerConstants.DEFAULT_OBJECTS_COUNT_FOUND_BY_NAME.getIntValue());
        for (Storable labeledObj : objects) {
            if (!this.findLabeledByPieceOfName(labeledObj, value).booleanValue()) continue;
            nodes.add(labeledObj);
        }
        return nodes;
    }

    public HashSet<String> getAllObjectsLabels(Collection<Storable> objects) {
        HashSet labelsSet = Sets.newHashSetWithExpectedSize((int)ControllerConstants.DEFAULT_LABELS_COUNT.getIntValue());
        for (Storable labeledObj : objects) {
            List labels;
            if (!(labeledObj instanceof LabeledStorable) || (labels = ((LabeledStorable)labeledObj).getLabels()) == null) continue;
            labelsSet.addAll(labels);
        }
        return labelsSet;
    }

    public Boolean findLabeledByPieceOfName(Storable labeledObject, String labelName) {
        List labels = null;
        if (labeledObject instanceof LabeledStorable && (labels = ((LabeledStorable)labeledObject).getLabels()) != null) {
            for (String label : labels) {
                if (!label.toLowerCase().contains(labelName)) continue;
                return true;
            }
        }
        return false;
    }
}

