/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.controls.tree;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.automation.itf.core.exceptions.common.ObjectNotFoundException;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ByProject;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.SystemObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;
import org.qubership.automation.itf.ui.controls.tree.AbstractTreeBuilder;
import org.qubership.automation.itf.ui.controls.tree.TreeController;
import org.qubership.automation.itf.ui.messages.objects.UITreeElement;
import org.qubership.automation.itf.ui.messages.objects.template.UITemplate;
import org.qubership.automation.itf.ui.messages.tree.UITreeData;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional(readOnly=true)
public class TemplateTreeController
extends AbstractTreeBuilder<Template, TemplateProvider>
implements TreeController {
    @Override
    public UITreeData getTree(String id, UUID projectUuid) {
        return this.getTree(id, System.class.getName(), projectUuid);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/folder"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Template Tree under Folder id {{#id}} in the project {{#projectUuid}}")
    public UITreeData getTree(@RequestParam(required=false) String id, @RequestParam(required=false) String className, @RequestParam(value="projectUuid") UUID projectUuid) {
        UITreeElement currentFolder;
        UITreeData treeData = new UITreeData();
        if (StringUtils.isBlank((CharSequence)className) && !StringUtils.isBlank((CharSequence)id)) {
            try {
                return this.buildTreeById(new UITemplate(TemplateHelper.getById((Object)id)));
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while was getting template with id + " + id);
                id = "";
            }
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            currentFolder = new UITreeElement();
            BigInteger projectId = ((SearchManager)CoreObjectManager.getInstance().getSpecialManager(StubProject.class, SearchManager.class)).getEntityInternalIdByUuid(projectUuid);
            ((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getByProjectId(projectId).forEach(templateProvider -> {
                UITreeElement element = new UITreeElement();
                this.configureObject(element, (Storable)templateProvider);
                currentFolder.addChild(element);
            });
        } else {
            currentFolder = this.fillFolder((Storable)this.getTemplateProvider(id, className));
        }
        if (currentFolder.getId() == null) {
            this.fillSystemFolders(currentFolder, (Folder<System>)((Folder)CoreObjectManager.getInstance().getManager(Folder.class).getById((Object)id)));
        }
        treeData.setTreeData(currentFolder.getChildren());
        return treeData;
    }

    private void fillSystemFolders(UITreeElement parentUiElement, Folder<System> systemFolder) {
        systemFolder.getObjects().forEach(templateProvider -> {
            UITreeElement element = new UITreeElement();
            this.configureObject(element, (Storable)templateProvider);
            parentUiElement.addChild(element);
        });
        systemFolder.getSubFolders().forEach(systemSubfolder -> this.fillSystemFolders(parentUiElement, (Folder<System>)systemSubfolder));
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/tree/node"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Template Tree for current id {{#id}} or parent id {{#parentId}} in the project {{#projectUuid}}")
    public UITreeData getTreeFromNode(@RequestParam(required=false) String id, @RequestParam(required=false) String parentId, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.getTree(parentId, projectUuid);
        }
        UITreeData uiTreeData = this.getTree(parentId, projectUuid);
        Storable node = this.getTemplateOrFolder(id);
        if (node instanceof System) {
            this.replaceAndExpandSystem(uiTreeData, (System)node);
        } else if (node instanceof Operation) {
            this.replaceAndExpandSystemExpandOperation(uiTreeData, (System)node.getParent(), (Operation)node);
        } else if (node.getParent() instanceof System) {
            this.replaceAndExpandSystem(uiTreeData, (System)node.getParent());
        } else {
            this.replaceAndExpandSystemExpandOperation(uiTreeData, (System)node.getParent().getParent(), (Operation)node.getParent());
        }
        return uiTreeData;
    }

    private void replaceAndExpandSystem(UITreeData uiTreeData, System system) {
        UITreeElement uiTreeElementSystem = new UITreeElement((Storable)system);
        uiTreeElementSystem.setFolder(null);
        uiTreeElementSystem.setIsFolder(true);
        uiTreeElementSystem.setExpanded(true);
        for (Operation oper : system.getOperations()) {
            UITreeElement uiTreeElementOperation = new UITreeElement((Storable)oper);
            uiTreeElementOperation.setFolder(null);
            uiTreeElementOperation.setIsFolder(true);
            uiTreeElementSystem.getChildren().add(uiTreeElementOperation);
        }
        for (Template template : system.returnTemplates()) {
            UITreeElement uiTreeElementTemplate = new UITreeElement((Storable)template);
            uiTreeElementSystem.getChildren().add(uiTreeElementTemplate);
        }
        uiTreeData.getTreeData().remove(uiTreeElementSystem);
        uiTreeData.getTreeData().add(uiTreeElementSystem);
    }

    private void replaceAndExpandSystemExpandOperation(UITreeData uiTreeData, System system, Operation operation) {
        UITreeElement uiTreeElementSystem = new UITreeElement((Storable)system);
        uiTreeElementSystem.setFolder(null);
        uiTreeElementSystem.setIsFolder(true);
        uiTreeElementSystem.setExpanded(true);
        for (Operation oper : system.getOperations()) {
            UITreeElement uiTreeElementOperation = new UITreeElement((Storable)oper);
            uiTreeElementOperation.setFolder(null);
            uiTreeElementOperation.setIsFolder(true);
            if (oper.equals((Object)operation)) {
                uiTreeElementOperation.setExpanded(true);
                for (Template template : oper.returnTemplates()) {
                    UITreeElement uiTreeElementTemplate = new UITreeElement((Storable)template);
                    uiTreeElementOperation.getChildren().add(uiTreeElementTemplate);
                }
            }
            uiTreeElementSystem.getChildren().add(uiTreeElementOperation);
        }
        for (Template template : system.returnTemplates()) {
            UITreeElement uiTreeElementTemplate = new UITreeElement((Storable)template);
            uiTreeElementSystem.getChildren().add(uiTreeElementTemplate);
        }
        uiTreeData.getTreeData().remove(uiTreeElementSystem);
        uiTreeData.getTreeData().add(uiTreeElementSystem);
    }

    @Override
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/tree/node/name"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get Template Tree for node by name {{#value}} and parent id {{#parentId}} in the project {{#projectId}}/{{#projectUuid}}")
    public UITreeData getTreeFromNodeByName(@RequestParam(required=false) String value, @RequestParam(required=false) String[] filters, @RequestParam(required=false) String parentId, @RequestParam(value="projectId") BigInteger projectId, @RequestParam(value="projectUuid") UUID projectUuid) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this.getTree(parentId, projectUuid);
        }
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)5);
        String[] stringArray = filters;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String filter;
            switch (filter = stringArray[i]) {
                case "NAME": {
                    nodes.addAll(this.getAllNodesByName(value, projectId));
                    continue block8;
                }
                case "LABEL": {
                    nodes.addAll(this.getAllLabeledByPieceOfName(value.toLowerCase(), this.getAllNodesByName("", projectId)));
                    continue block8;
                }
            }
        }
        return this.buildTreeByFilter(nodes);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.automation.itf.ui.util.UserManagementEntities).TEMPLATE.getName(),#projectUuid, 'READ')")
    @RequestMapping(value={"/template/label"}, method={RequestMethod.GET})
    @AuditAction(auditAction="Get all Template Labels in the project {{#projectId}}/{{#projectUuid}}")
    public Set<String> gelLabels(@RequestParam(value="projectUuid") UUID projectUuid, @RequestParam(value="projectId") BigInteger projectId) {
        return TemplateHelper.getAllLabels((BigInteger)projectId);
    }

    @Override
    UITreeElement fillFolder(Storable nodeProvider) {
        UITreeElement currentFolder = new UITreeElement();
        if (nodeProvider instanceof TemplateProvider) {
            TemplateProvider templateProvider = (TemplateProvider)nodeProvider;
            this.configureObject(currentFolder, (Storable)templateProvider);
            if (templateProvider instanceof System) {
                this.addSubElements(currentFolder, ((System)templateProvider).getOperations());
            }
            this.addSubElements(currentFolder, templateProvider.returnTemplates());
        } else if (nodeProvider instanceof SystemFolder) {
            SystemFolder systemFolder = (SystemFolder)nodeProvider;
            this.configureObject(currentFolder, (Storable)systemFolder);
            this.addSubElements(currentFolder, systemFolder.getObjects());
            this.addSubElements(currentFolder, systemFolder.getSubFolders());
        }
        return currentFolder;
    }

    @Override
    Class<TemplateProvider> getParentClass() {
        return TemplateProvider.class;
    }

    @Override
    Class<Template> getChildClass() {
        return Template.class;
    }

    private Storable getTemplateOrFolder(@RequestParam String id) {
        Template node = TemplateHelper.getById((Object)id);
        if (node == null) {
            node = CoreObjectManager.getInstance().getManager(System.class).getById((Object)id);
        }
        if (node == null) {
            node = CoreObjectManager.getInstance().getManager(Operation.class).getById((Object)id);
        }
        if (node == null) {
            throw new ObjectNotFoundException("Template or its parent (System/Operation)", id, null, null);
        }
        return node;
    }

    private Collection<Storable> getAllNodesByName(@RequestParam String name, BigInteger projectId) {
        HashSet nodes = Sets.newHashSetWithExpectedSize((int)5);
        nodes.addAll(((ByProject)CoreObjectManager.getInstance().getSpecialManager(Operation.class, ByProject.class)).getByPieceOfNameAndProject(name, (Object)projectId));
        nodes.addAll(TemplateHelper.getByPieceOfNameAndProject((String)name, (BigInteger)projectId));
        nodes.addAll(((SystemObjectManager)CoreObjectManager.getInstance().getSpecialManager(System.class, SystemObjectManager.class)).getByPieceOfNameAndProject(name, (Object)projectId));
        return nodes;
    }

    private TemplateProvider getTemplateProvider(@RequestParam(required=false) String id, String className) {
        Class clazz = System.class.getName().equalsIgnoreCase(className) ? System.class : Operation.class;
        return (TemplateProvider)CoreObjectManager.getInstance().getManager(clazz).getById((Object)id);
    }
}

