/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.monitoring;

import java.util.Date;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.service.TimeService;

public class UIProcessItem
extends UIObject {
    private Status status = Status.NOT_STARTED;
    private Date startTime;
    private Date endTime;
    private long duration = 0L;

    public UIProcessItem() {
    }

    public UIProcessItem(AbstractInstance instance) {
        super((Storable)instance);
        AbstractInstance a = instance.getParent();
        this.status = instance.getStatus();
        this.startTime = instance.getStartTime();
        this.endTime = instance.getEndTime();
        if (this.startTime != null && this.endTime != null) {
            this.duration = this.endTime.getTime() - this.startTime.getTime();
        }
    }

    public String getStatus() {
        return this.status.toString();
    }

    public String getStartTime() {
        return TimeService.getFormattedDate(this.startTime);
    }

    public String getEndTime() {
        return TimeService.getFormattedDate(this.endTime);
    }

    public String getDuration() {
        return String.format("%.3f (s)", (double)this.duration / 1000.0);
    }

    @Override
    public UIProcessItem getParent() {
        return (UIProcessItem)super.getParent();
    }
}

