/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.Pair;
import org.qubership.automation.itf.core.util.constants.SituationLevelValidation;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.ui.controls.util.ControllerConstants;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.UIParsingRule;
import org.qubership.automation.itf.ui.messages.objects.UITypedObject;
import org.qubership.automation.itf.ui.messages.objects.eventtrigger.UIEventTrigger;
import org.qubership.automation.itf.ui.messages.objects.wrap.UIWrapper;
import org.qubership.automation.itf.ui.util.UIHelper;

public class UISituation
extends UITypedObject {
    private static final String TYPE = "situation";
    private static final Function<EventTrigger, UIEventTrigger> TO_UI_TRIGGER_FULL = input -> new UIEventTrigger((EventTrigger)input);
    private static final Function<EventTrigger, UIEventTrigger> TO_UI_TRIGGER_SHORT = input -> new UIEventTrigger((EventTrigger)input, false);
    private String mep;
    private ImmutableList<UIEventTrigger> triggers;
    private UIWrapper<Set<UIParsingRule>> parsingRules;
    private UIObject receiver;
    private UIObject operation;
    private UIObject template;
    private long delay;
    private String unit;
    private int priority;
    private SituationLevelValidation validateIncoming;
    private String bvTestcase;
    private List<Pair<String, String>> keysToRegenerate = Lists.newArrayList();
    private UIWrapper<String> preScript;
    private UIWrapper<String> postScript;
    private UIWrapper<String> preValidationScript;
    private boolean ignoreErrors;

    public UISituation() {
    }

    public UISituation(String id, String name) {
        this.setId(id);
        this.setName(name);
    }

    public UISituation(Storable situation) {
        this((Situation)situation);
    }

    public UISituation(Situation situation) {
        super((Storable)situation);
        IntegrationStep step = situation.getIntegrationStep();
        if (step != null) {
            if (step.getReceiver() != null) {
                this.receiver = new UIObject((Storable)step.getReceiver());
            }
            if (step.getOperation() != null) {
                this.operation = new UIObject((Storable)step.getOperation());
            }
            if (step.returnStepTemplate() != null) {
                this.template = new UIObject((Storable)step.returnStepTemplate());
            }
            this.delay = step.getDelay();
            this.unit = step.getUnit();
        }
        this.commonInit(situation, true);
    }

    public UISituation(Situation situation, boolean isFullWithParent) {
        super((Storable)situation, isFullWithParent);
        IntegrationStep step = situation.getIntegrationStep();
        if (step != null) {
            if (step.getReceiver() != null) {
                this.receiver = new UIObject((Storable)step.getReceiver(), isFullWithParent);
            }
            if (step.getOperation() != null) {
                this.operation = new UIObject((Storable)step.getOperation(), isFullWithParent);
            }
            if (step.returnStepTemplate() != null) {
                this.template = new UIObject((Storable)step.returnStepTemplate(), isFullWithParent);
            }
            this.delay = step.getDelay();
            this.unit = step.getUnit();
        }
        this.commonInit(situation, isFullWithParent);
    }

    private void commonInit(Situation situation, boolean isFullWithParent) {
        this.setType(TYPE);
        this.defineParsingRules(situation.getParsingRules(), isFullWithParent);
        this.validateIncoming = situation.getValidateIncoming();
        this.bvTestcase = situation.getBvTestcase();
        this.mep = situation.getMep().toString();
        this.setPreScript(new UIWrapper<String>(situation.getPreScript()));
        this.setPostScript(new UIWrapper<String>(situation.getPostScript()));
        this.setPreValidationScript(new UIWrapper<String>(situation.getPreValidationScript()));
        this.setLabels(situation.getLabels());
        this.setIgnoreErrors(situation.isIgnoreErrors());
        if (situation.getOperationEventTriggers().isEmpty() && situation.getSituationEventTriggers().isEmpty()) {
            if (situation.getParent().getTransport() != null && situation.getMep().isInboundRequest()) {
                UIEventTrigger uiEventTrigger = new UIEventTrigger();
                uiEventTrigger.setType(ControllerConstants.OPERATION_EVENT_TRIGGER_TYPE.getStringValue());
                uiEventTrigger.setName(uiEventTrigger.getType());
                this.setTriggers(Collections.singletonList(uiEventTrigger));
                ControllerHelper.addEventTriggers(this.getTriggers(), situation);
                ArrayList<UIEventTrigger> arrayList = new ArrayList<UIEventTrigger>();
                for (EventTrigger eventTrigger : situation.getSituationEventTriggers()) {
                    arrayList.add(new UIEventTrigger(eventTrigger));
                }
                this.setTriggers(arrayList);
            }
        } else {
            this.setTriggers(Collections2.transform((Collection)situation.getAllEventTriggers(), isFullWithParent ? TO_UI_TRIGGER_FULL : TO_UI_TRIGGER_SHORT));
        }
        for (OperationEventTrigger operationEventTrigger : situation.getOperationEventTriggers()) {
            this.priority = operationEventTrigger.getPriority();
        }
        for (Map.Entry entry : situation.getKeysToRegenerate().entrySet()) {
            this.keysToRegenerate.add((Pair<String, String>)new Pair(entry.getKey(), entry.getValue()));
        }
    }

    private void defineParsingRules(Set<ParsingRule> parsingRules, boolean isFullWithParent) {
        if (this.parsingRules == null) {
            this.parsingRules = new UIWrapper<HashSet>(Sets.newHashSetWithExpectedSize((int)parsingRules.size()));
        }
        if (parsingRules != null) {
            for (ParsingRule entry : parsingRules) {
                this.parsingRules.getData().add(new UIParsingRule((ParsingRule<? extends ParsingRuleProvider>)entry, isFullWithParent));
            }
        }
    }

    public ImmutableList<UIEventTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Collection<UIEventTrigger> triggers) {
        this.triggers = UIHelper.isNotNullCopyOfImmutableList(triggers);
    }

    public UIWrapper<Set<UIParsingRule>> getParsingRules() {
        return this.parsingRules;
    }

    public void setParsingRules(UIWrapper<Set<UIParsingRule>> parsingRules) {
        this.parsingRules = parsingRules;
    }

    public UIObject getReceiver() {
        return this.receiver;
    }

    public void setReceiver(UIObject receiver) {
        this.receiver = receiver;
    }

    public UIObject getOperation() {
        return this.operation;
    }

    public void setOperation(UIObject operation) {
        this.operation = operation;
    }

    public UIObject getTemplate() {
        return this.template;
    }

    public void setTemplate(UIObject template) {
        this.template = template;
    }

    public String getMep() {
        return this.mep;
    }

    public void setMep(String mep) {
        this.mep = mep;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public SituationLevelValidation getValidateIncoming() {
        return this.validateIncoming;
    }

    public void setValidateIncoming(SituationLevelValidation validateIncoming) {
        this.validateIncoming = validateIncoming;
    }

    public String getBvTestcase() {
        return this.bvTestcase;
    }

    public void setBvTestcase(String bvTestcase) {
        this.bvTestcase = bvTestcase;
    }

    public List<Pair<String, String>> getKeysToRegenerate() {
        return this.keysToRegenerate;
    }

    public void setKeysToRegenerate(List<Pair<String, String>> keysToRegenerate) {
        this.keysToRegenerate = keysToRegenerate;
    }

    public UIWrapper<String> getPreScript() {
        return this.preScript;
    }

    public void setPreScript(UIWrapper<String> preScript) {
        this.preScript = preScript;
    }

    public UIWrapper<String> getPostScript() {
        return this.postScript;
    }

    public void setPostScript(UIWrapper<String> postScript) {
        this.postScript = postScript;
    }

    public UIWrapper<String> getPreValidationScript() {
        return this.preValidationScript;
    }

    public void setPreValidationScript(UIWrapper<String> preValidationScript) {
        this.preValidationScript = preValidationScript;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }
}

