/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.callchain.step;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.ui.controls.util.ControllerHelper;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.callchain.step.UIAbstractCallChainStep;

public class UISituationStep
extends UIAbstractCallChainStep {
    private UIObject situation;
    private Collection<UIObject> endSituations = Sets.newHashSetWithExpectedSize((int)2);
    private Collection<UIObject> exceptionalSituation = Sets.newHashSetWithExpectedSize((int)5);
    private boolean waitAllEndSituations;
    private boolean retryOnFail;
    private long retryTimeout;
    private String retryTimeoutUnit;
    private int validationMaxAttempts;
    private long validationMaxTime;
    private String validationUnitMaxTime;

    public UISituationStep() {
        this.setType("situationStep");
    }

    public UISituationStep(SituationStep step) {
        super((AbstractCallChainStep)step, true);
        this.fillUiSituationStep(step, true);
    }

    public UISituationStep(SituationStep step, boolean isFullWithParent) {
        super((AbstractCallChainStep)step, isFullWithParent);
        this.fillUiSituationStep(step, isFullWithParent);
    }

    public UISituationStep(SituationStep step, String stepName) {
        super((AbstractCallChainStep)step, true);
        this.fillUiSituationStep(step, true);
        this.setStepName(stepName);
    }

    public UISituationStep(SituationStep step, String stepName, boolean isFullWithParent) {
        super((AbstractCallChainStep)step, isFullWithParent);
        this.fillUiSituationStep(step, isFullWithParent);
        this.setStepName(stepName);
    }

    private void fillUiSituationStep(SituationStep step, boolean isFullWithParent) {
        this.setType("situationStep");
        if (step.getSituation() != null) {
            this.setSituation(new UIObject((Storable)step.getSituation(), isFullWithParent));
        }
        if (!step.getEndSituations().isEmpty()) {
            for (Situation situation : step.getEndSituations()) {
                this.endSituations.add(new UIObject((Storable)situation, isFullWithParent));
            }
        }
        this.waitAllEndSituations = step.getWaitAllEndSituations();
        if (!step.getExceptionalSituations().isEmpty()) {
            for (Situation situation : step.getExceptionalSituations()) {
                this.exceptionalSituation.add(new UIObject((Storable)situation, isFullWithParent));
            }
        }
        this.fillConditionsFromStep((AbstractCallChainStep)step);
        this.fillConditionRetryPropsFromStep(step);
        this.fillValidationRetryPropsFromStep(step);
        this.setPreScript(step.getPreScript());
    }

    private void fillConditionRetryPropsFromStep(SituationStep step) {
        this.setConditionRetry(step.isConditionRetry());
        this.setConditionMaxAttempts(step.getConditionMaxAttempts());
        this.setConditionMaxTime(step.getConditionMaxTime());
        this.setConditionUnitMaxTime(step.getConditionUnitMaxTime());
    }

    private void fillValidationRetryPropsFromStep(SituationStep step) {
        this.setRetryOnFail(step.isRetryOnFail());
        this.setRetryTimeout(step.getRetryTimeout());
        this.setRetryTimeoutUnit(step.getRetryTimeoutUnit());
        this.setValidationMaxAttempts(step.getValidationMaxAttempts());
        this.setValidationMaxTime(step.getValidationMaxTime());
        this.setValidationUnitMaxTime(step.getValidationUnitMaxTime());
    }

    @Override
    public void _updateStep(AbstractCallChainStep step) {
        Situation thisSituation;
        SituationStep situationStep = (SituationStep)step;
        ObjectManager manager = CoreObjectManager.getInstance().getManager(Situation.class);
        if (this.situation != null && this.situation.getId() != null) {
            Situation situation = (Situation)manager.getById((Object)this.situation.getId());
            ControllerHelper.throwExceptionIfNull((Storable)situation, this.situation.getName(), this.situation.getId(), Situation.class, "get Situation by id");
            situationStep.setSituation(situation);
        } else {
            situationStep.setSituation(null);
        }
        situationStep.getEndSituations().clear();
        if (this.endSituations != null && !this.endSituations.isEmpty()) {
            for (UIObject uiSituation : this.endSituations) {
                if (uiSituation == null || uiSituation.getId() == null) continue;
                thisSituation = (Situation)manager.getById((Object)uiSituation.getId());
                ControllerHelper.throwExceptionIfNull((Storable)thisSituation, uiSituation.getName(), uiSituation.getId(), Situation.class, "get End Situation by id");
                situationStep.getEndSituations().add(thisSituation);
            }
            situationStep.setWaitAllEndSituations(this.getWaitAllEndSituations());
        }
        situationStep.getExceptionalSituations().clear();
        if (this.exceptionalSituation != null && !this.exceptionalSituation.isEmpty()) {
            for (UIObject uiSituation : this.exceptionalSituation) {
                if (uiSituation == null || uiSituation.getId() == null) continue;
                thisSituation = (Situation)manager.getById((Object)uiSituation.getId());
                ControllerHelper.throwExceptionIfNull((Storable)thisSituation, uiSituation.getName(), uiSituation.getId(), Situation.class, "get Exceptional Situation by id");
                situationStep.getExceptionalSituations().add(thisSituation);
            }
        }
        situationStep.setConditionRetry(this.isConditionRetry());
        situationStep.setConditionMaxAttempts(this.getConditionMaxAttempts());
        situationStep.setConditionMaxTime(this.getConditionMaxTime());
        situationStep.setConditionUnitMaxTime(this.getConditionUnitMaxTime());
        situationStep.setRetryOnFail(this.isRetryOnFail());
        situationStep.setRetryTimeout(this.getRetryTimeout());
        situationStep.setRetryTimeoutUnit(this.getRetryTimeoutUnit());
        situationStep.setValidationMaxAttempts(this.getValidationMaxAttempts());
        situationStep.setValidationMaxTime(this.getValidationMaxTime());
        situationStep.setValidationUnitMaxTime(this.getValidationUnitMaxTime());
        this.processConditions((AbstractCallChainStep)situationStep);
    }

    public UIObject getSituation() {
        return this.situation;
    }

    public void setSituation(UIObject situation) {
        this.situation = situation;
    }

    public Collection<UIObject> getEndSituations() {
        return this.endSituations;
    }

    public void setEndSituations(Collection<UIObject> endSituations) {
        this.endSituations = endSituations;
    }

    public Collection<UIObject> getExceptionalSituation() {
        return this.exceptionalSituation;
    }

    public void setExceptionalSituation(Collection<UIObject> exceptionalSituation) {
        this.exceptionalSituation = exceptionalSituation;
    }

    public boolean getWaitAllEndSituations() {
        return this.waitAllEndSituations;
    }

    public void setWaitAllEndSituations(boolean waitAllEndSituations) {
        this.waitAllEndSituations = waitAllEndSituations;
    }

    public boolean isRetryOnFail() {
        return this.retryOnFail;
    }

    public void setRetryOnFail(boolean retryOnFail) {
        this.retryOnFail = retryOnFail;
    }

    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public String getRetryTimeoutUnit() {
        return this.retryTimeoutUnit;
    }

    public void setRetryTimeoutUnit(String retryTimeoutUnit) {
        this.retryTimeoutUnit = retryTimeoutUnit;
    }

    public int getValidationMaxAttempts() {
        return this.validationMaxAttempts;
    }

    public void setValidationMaxAttempts(int validationMaxAttempts) {
        this.validationMaxAttempts = validationMaxAttempts;
    }

    public long getValidationMaxTime() {
        return this.validationMaxTime;
    }

    public void setValidationMaxTime(long validationMaxTime) {
        this.validationMaxTime = validationMaxTime;
    }

    public String getValidationUnitMaxTime() {
        return this.validationUnitMaxTime;
    }

    public void setValidationUnitMaxTime(String validationUnitMaxTime) {
        this.validationUnitMaxTime = validationUnitMaxTime;
    }
}

