/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.ui.messages.objects.environment;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.ui.messages.objects.UIObject;
import org.qubership.automation.itf.ui.messages.objects.environment.UIServer;
import org.qubership.automation.itf.ui.messages.objects.integration.ec.UIECIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIConfiguration;
import org.qubership.automation.itf.ui.messages.objects.transport.UIProperty;

public class UIServerOutbound
extends UIServer {
    private static final String INPUT_TYPE_REFERENCE = "reference";
    private static final Function<OutboundTransportConfiguration, UIECIConfiguration<OutboundTransportConfiguration>> TO_UI_OUTBOUND_CONF = new Function<OutboundTransportConfiguration, UIECIConfiguration<OutboundTransportConfiguration>>(){

        public UIECIConfiguration<OutboundTransportConfiguration> apply(OutboundTransportConfiguration input) {
            ArrayList uiProperties;
            UIECIConfiguration<OutboundTransportConfiguration> uiConfiguration = new UIECIConfiguration<OutboundTransportConfiguration>(input);
            uiConfiguration.fillUserTypeNameFromConfiguration((Configuration)input);
            uiConfiguration.setEcId(input.getEcId());
            try {
                boolean transportDeployed;
                Map transportParameters = TransportRegistryManager.getInstance().getProperties(input.getTypeName());
                boolean bl = transportDeployed = transportParameters != null;
                if (transportDeployed) {
                    uiProperties = Lists.newArrayListWithExpectedSize((int)transportParameters.size());
                    for (PropertyDescriptor descriptor : transportParameters.values()) {
                        if (!descriptor.isForServer()) continue;
                        UIProperty uiProperty = new UIProperty(descriptor, input.get((Object)descriptor.getShortName()));
                        if (UIServerOutbound.INPUT_TYPE_REFERENCE.equals(uiProperty.getInputType()) && !"".equals(uiProperty.getValue())) {
                            String id = uiProperty.getValue();
                            if (id == null) {
                                uiProperty.setReferenceValue(null);
                            } else {
                                Class<?> propertyType = Class.forName(uiProperty.getReferenceClass());
                                Object storable = "Template".equals(propertyType.getSimpleName()) ? TemplateHelper.getById((Object)id) : CoreObjectManager.getInstance().getManager(propertyType.asSubclass(Storable.class)).getById((Object)id);
                                if (storable == null) {
                                    uiProperty.setReferenceValue(null);
                                } else {
                                    uiProperty.setReferenceValue(new UIObject((Storable)storable));
                                }
                            }
                        }
                        uiProperties.add(uiProperty);
                    }
                } else {
                    uiProperties = UIConfiguration.defineNonDeployed((Configuration)input);
                }
            }
            catch (Exception e) {
                uiProperties = UIConfiguration.defineNonDeployed((Configuration)input);
            }
            uiConfiguration.setProperties(uiProperties);
            return uiConfiguration;
        }
    };
    private UIObject system;
    private ImmutableList<UIConfiguration> configurations;
    private String url;

    public UIServerOutbound() {
    }

    public UIServerOutbound(Server storable) {
        super(storable);
        this.url = storable.getUrl();
    }

    public UIObject getSystem() {
        return this.system;
    }

    public void setSystem(UIObject system) {
        this.system = system;
    }

    public ImmutableList<UIConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<UIECIConfiguration<OutboundTransportConfiguration>> configurations) {
        this.configurations = ImmutableList.copyOf(configurations);
    }

    public void defineSystem(System system) {
        this.system = new UIObject((Storable)system);
    }

    public void defineConfiguration(Collection<OutboundTransportConfiguration> configurations) {
        this.setConfigurations(Collections2.transform(configurations, TO_UI_OUTBOUND_CONF));
    }
}

